/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.io.DataOutputStream;
import java.io.IOException;

public class ChunkedOutputStream
extends DataOutputStream {
    private static final byte[] hexaTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final byte[] crlf = new byte[]{13, 10};
    private static final byte[] zeroChunk = new byte[]{48, 13, 10};
    private static final int DEFAULT_CHUNK_SIZE = 512;
    protected byte[] buffer = null;
    protected int bufptr = 0;
    protected int chunksize = -1;
    protected byte[] bheader = new byte[32];

    public ChunkedOutputStream(DataOutputStream dataOutputStream) {
        this(new byte[512], dataOutputStream);
    }

    public ChunkedOutputStream(byte[] byArray, DataOutputStream dataOutputStream) {
        super(dataOutputStream);
        this.buffer = byArray;
        this.chunksize = byArray.length;
    }

    protected final void append(int n) throws IOException {
        if (this.bufptr + 1 >= this.chunksize) {
            this.sendChunk();
        }
        this.buffer[this.bufptr++] = (byte)(n & 0xFF);
    }

    protected final void append(byte[] byArray, int n, int n2) throws IOException {
        if (this.bufptr + n2 >= this.chunksize) {
            this.sendChunk();
        }
        if (n2 < this.buffer.length) {
            System.arraycopy(byArray, n, this.buffer, this.bufptr, n2);
            this.bufptr += n2;
        } else {
            this.sendChunk(byArray, n, n2);
        }
    }

    public void close() throws IOException {
        this.sendChunk();
        super.close();
    }

    public void flush() throws IOException {
        this.sendChunk();
        super.flush();
    }

    protected void sendChunk() throws IOException {
        if (this.bufptr == 0) {
            return;
        }
        this.sendChunk(this.buffer, 0, this.bufptr);
        this.bufptr = 0;
    }

    protected void sendChunk(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        int n3 = n2;
        int n4 = 3;
        this.bheader[30] = 13;
        this.bheader[31] = 10;
        while (n3 > 15) {
            this.bheader[32 - n4] = hexaTable[n3 % 16];
            n3 >>= 4;
            ++n4;
        }
        this.bheader[32 - n4] = hexaTable[n3];
        this.out.write(this.bheader, 32 - n4, n4);
        this.out.write(byArray, n, n2);
        this.out.write(crlf, 0, 2);
        this.out.flush();
    }

    protected void sendClose() throws IOException {
        this.out.write(zeroChunk, 0, 3);
        this.out.write(crlf, 0, 2);
        this.out.flush();
    }

    public void write(int n) throws IOException {
        this.append(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.append(byArray, n, n2);
    }
}

