/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.util;

import org.w3c.util.CachedThread;

public class ThreadCache {
    private static final boolean debug = false;
    private static final int DEFAULT_CACHESIZE = 5;
    protected boolean inited = false;
    protected ThreadGroup group = null;
    protected int cachesize = 5;
    protected int threadcount = 0;
    protected int threadid = 0;
    protected int idlethreads = 0;
    protected boolean growasneeded = false;
    protected int usedthreads = 0;
    protected CachedThread freelist = null;
    protected int idletimeout = 5000;
    protected int threadpriority = 5;

    public ThreadCache(String string) {
        this(new ThreadGroup(string));
    }

    public ThreadCache(ThreadGroup threadGroup) {
        this.group = threadGroup;
    }

    public ThreadCache(ThreadGroup threadGroup, String string) {
        this(new ThreadGroup(threadGroup, string));
    }

    protected synchronized CachedThread allocateThread(boolean bl) {
        CachedThread cachedThread;
        block5: {
            cachedThread = null;
            while (true) {
                if (this.freelist != null) {
                    cachedThread = this.freelist;
                    this.freelist = this.freelist.next;
                    break block5;
                }
                if (this.threadcount < this.cachesize || this.growasneeded) {
                    cachedThread = this.createThread();
                    break block5;
                }
                if (!bl) break;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return null;
        }
        return cachedThread;
    }

    private synchronized CachedThread createThread() {
        ++this.threadcount;
        ++this.threadid;
        return new CachedThread(this, this.threadid);
    }

    final synchronized int getIdleTimeout() {
        return this.threadcount <= this.idlethreads ? -1 : this.idletimeout;
    }

    public boolean getThread(Runnable runnable, boolean bl) {
        CachedThread cachedThread;
        if (!this.inited) {
            throw new RuntimeException("Uninitialized thread cache");
        }
        while ((cachedThread = this.allocateThread(bl)) != null) {
            ++this.usedthreads;
            if (!cachedThread.wakeup(runnable)) continue;
            return true;
        }
        return false;
    }

    public ThreadGroup getThreadGroup() {
        return this.group;
    }

    public int getThreadPriority() {
        return this.threadpriority;
    }

    public synchronized void initialize() {
        int n = 0;
        while (n < this.idlethreads) {
            CachedThread cachedThread = this.createThread();
            cachedThread.next = this.freelist;
            this.freelist = cachedThread;
            cachedThread.start();
            ++n;
        }
        this.inited = true;
    }

    final synchronized void isDead(CachedThread cachedThread) {
        if (!cachedThread.isTerminated()) {
            --this.threadcount;
            this.notifyAll();
        }
    }

    final synchronized boolean isFree(CachedThread cachedThread, boolean bl) {
        if (bl && this.threadcount > this.idlethreads) {
            if (!cachedThread.isTerminated()) {
                --this.threadcount;
                --this.usedthreads;
                this.notifyAll();
            }
            return false;
        }
        if (this.threadcount <= this.cachesize) {
            cachedThread.next = this.freelist;
            this.freelist = cachedThread;
            --this.usedthreads;
            this.notifyAll();
            return true;
        }
        if (!cachedThread.isTerminated()) {
            --this.threadcount;
            --this.usedthreads;
            this.notifyAll();
        }
        return false;
    }

    public void setCachesize(int n) {
        this.setCachesize(n, true);
    }

    public synchronized void setCachesize(int n, boolean bl) {
        this.cachesize = n;
        if (bl) {
            this.idlethreads = n >> 1;
        }
    }

    public void setGrowAsNeeded(boolean bl) {
        this.growasneeded = bl;
    }

    public synchronized void setIdleTimeout(int n) {
        this.idletimeout = n;
    }

    public void setThreadPriority(int n) {
        this.threadpriority = n;
    }

    public synchronized void waitForCompletion() {
        while (this.usedthreads > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

