/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.util;

import org.w3c.util.ThreadCache;

class CachedThread
extends Thread {
    Runnable runner = null;
    boolean alive = true;
    ThreadCache cache = null;
    CachedThread next = null;
    boolean terminated = false;
    boolean started = false;
    boolean firstime = true;

    CachedThread(ThreadCache threadCache, int n) {
        super(threadCache.getThreadGroup(), String.valueOf(threadCache.getThreadGroup().getName()) + ":" + n);
        this.cache = threadCache;
        this.setPriority(threadCache.getThreadPriority());
        this.setDaemon(true);
    }

    synchronized boolean isTerminated() {
        boolean bl = this.terminated;
        this.terminated = true;
        return bl;
    }

    synchronized void kill() {
        this.alive = false;
        this.notify();
    }

    public void run() {
        try {
            do {
                Runnable runnable;
                if ((runnable = this.waitForRunner()) == null) continue;
                runnable.run();
            } while (this.alive);
        }
        finally {
            Object var2_2 = null;
            this.cache.isDead(this);
        }
    }

    public synchronized void start() {
        super.start();
        this.started = true;
    }

    synchronized Runnable waitForRunner() {
        boolean bl = false;
        while (this.alive) {
            if (this.runner != null) {
                Runnable runnable = this.runner;
                this.firstime = false;
                this.runner = null;
                return runnable;
            }
            if (this.firstime) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.alive = this.cache.isFree(this, bl);
            if (!this.alive) continue;
            try {
                int n = this.cache.getIdleTimeout();
                bl = false;
                if (n > 0) {
                    this.wait(n);
                    bl = this.runner == null;
                    continue;
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    synchronized boolean wakeup(Runnable runnable) {
        if (this.alive) {
            this.runner = runnable;
            if (!this.started) {
                this.start();
            }
            this.notify();
            return true;
        }
        return false;
    }
}

