/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.widgets;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.w3c.tools.widgets.ImageCache;
import org.w3c.tools.widgets.NodeHandler;
import org.w3c.tools.widgets.TreeNode;

public class TreeBrowser
extends Canvas
implements AdjustmentListener {
    public static final int SCROLLBARS_ALWAYS = 0;
    public static final int SCROLLBARS_ASNEEDED = 1;
    public static final int SINGLE = 0;
    public static final int MULTIPLE = 1;
    static final int HMARGIN = 5;
    static final int VMARGIN = 5;
    static final int HGAP = 10;
    static final int DXLEVEL = 20;
    private Scrollbar vscroll;
    private Scrollbar hscroll;
    private int maxwidth = 0;
    private int startx = 0;
    private Color selectColor = new Color(0, 0, 128);
    private Color selectFontColor = Color.white;
    private int scrollbarDisplayPolicy = 1;
    private boolean hierarchyChanged = true;
    protected Vector items;
    protected Vector selection = new Vector(1, 1);
    protected int topItem = 0;
    protected int visibleItemCount = 20;
    protected int selectionPolicy = 0;
    protected int fontHeight;

    protected TreeBrowser() {
        this.items = new Vector();
        this.addMouseListener(new BrowserMouseListener());
    }

    public TreeBrowser(Object object, String string, NodeHandler nodeHandler, Image image) {
        this();
        this.initialize(object, string, nodeHandler, image);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.vscroll) {
            this.topItem = adjustmentEvent.getValue();
        } else {
            this.startx = adjustmentEvent.getValue();
        }
        this.repaint();
    }

    public synchronized void collapse(TreeNode treeNode) {
        TreeNode treeNode2 = treeNode;
        if (treeNode2.children != -1) {
            treeNode2.children = -1;
            int n = this.items.indexOf(treeNode) + 1;
            while (n < this.items.size()) {
                TreeNode treeNode3 = (TreeNode)this.items.elementAt(n);
                if (treeNode3.level > treeNode2.level) {
                    this.items.removeElementAt(n);
                    if (!treeNode3.selected) continue;
                    this.unselect(treeNode3);
                    continue;
                }
                this.hierarchyChanged = true;
                return;
            }
        }
    }

    public TreeNode getNode(Object object) {
        int n = this.items.size();
        int n2 = 0;
        while (n2 < n) {
            if (object.equals(((TreeNode)this.items.elementAt(n2)).getItem())) {
                return (TreeNode)this.items.elementAt(n2);
            }
            ++n2;
        }
        return null;
    }

    public TreeNode getParent(TreeNode treeNode) {
        int n = this.items.indexOf(treeNode);
        int n2 = n - 1;
        while (n2 >= 0) {
            TreeNode treeNode2 = (TreeNode)this.items.elementAt(n2);
            if (treeNode2.level < treeNode.level) {
                return treeNode2;
            }
            --n2;
        }
        return null;
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 400);
    }

    public int getSelectionPolicy() {
        return this.selectionPolicy;
    }

    protected void initialize(Object object, String string, NodeHandler nodeHandler, Image image) {
        this.items.addElement(new TreeNode(object, string, nodeHandler, image, 0));
    }

    public void insert(TreeNode treeNode, Object object, NodeHandler nodeHandler, String string, Image image) {
        if (treeNode == null) {
            throw new IllegalArgumentException("null parent");
        }
        if (nodeHandler == null && string == null) {
            throw new IllegalArgumentException("non-null item required");
        }
        if (nodeHandler == null) {
            nodeHandler = treeNode.handler;
        }
        if (string == null) {
            string = nodeHandler.toString();
        }
        treeNode.children = treeNode.children == -1 ? 1 : ++treeNode.children;
        boolean bl = false;
        TreeNode treeNode2 = null;
        int n = this.items.indexOf(treeNode) + treeNode.children;
        while (n < this.items.size() && ((TreeNode)this.items.elementAt((int)n)).level > treeNode.level) {
            ++n;
        }
        treeNode2 = new TreeNode(object, string, nodeHandler, image, treeNode.level + 1);
        this.items.insertElementAt(treeNode2, n);
        this.hierarchyChanged = true;
    }

    protected TreeNode itemAt(int n) {
        int n2 = this.topItem;
        while (n2 < this.items.size() && n > 0) {
            if (n < this.fontHeight) {
                return (TreeNode)this.items.elementAt(n2);
            }
            n -= this.fontHeight;
            ++n2;
        }
        return null;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        TreeNode treeNode;
        this.fontHeight = graphics.getFontMetrics().getHeight();
        int n5 = graphics.getFontMetrics().getAscent();
        int n6 = this.items.size();
        Dimension dimension = this.getSize();
        int n7 = dimension.height - 10;
        int n8 = dimension.width - 10;
        graphics.clipRect(5, 5, n8, n7);
        graphics.translate(5, 5);
        int n9 = 0;
        Stack<Integer> stack = new Stack<Integer>();
        Graphics graphics2 = graphics.create();
        graphics2.setColor(this.selectColor);
        graphics.setFont(this.getFont());
        this.visibleItemCount = 0;
        int n10 = -1;
        if (this.hierarchyChanged) {
            this.maxwidth = 0;
        }
        int n11 = 0;
        while (n11 < this.topItem) {
            treeNode = (TreeNode)this.items.elementAt(n11);
            if (this.hierarchyChanged) {
                n4 = treeNode.level * 20;
                n3 = graphics.getFontMetrics().stringWidth(treeNode.label);
                this.maxwidth = Math.max(this.maxwidth, n4 + 20 + n3);
            }
            if (treeNode.level > n10) {
                stack.push(new Integer(n11 - 1));
                n10 = treeNode.level;
            }
            if (treeNode.level < n10) {
                n2 = treeNode.level;
                while (n2 < n10) {
                    stack.pop();
                    ++n2;
                }
                n10 = treeNode.level;
            }
            ++n11;
        }
        int n12 = n6 - this.topItem;
        n2 = n7 / this.fontHeight;
        if (n12 < n2) {
            this.topItem = Math.max(0, this.topItem - (n2 - n12));
        }
        if (n8 >= this.maxwidth) {
            this.startx = 0;
        } else if (this.startx + n8 > this.maxwidth) {
            this.startx = this.maxwidth - n8;
        }
        int n13 = this.topItem;
        while (n13 < n6) {
            int n14;
            treeNode = (TreeNode)this.items.elementAt(n13);
            if (treeNode.level > n10) {
                stack.push(new Integer(n13 - 1));
                n10 = treeNode.level;
            }
            if (treeNode.level < n10) {
                n = treeNode.level;
                while (n < n10) {
                    stack.pop();
                    ++n;
                }
                n10 = treeNode.level;
            }
            n4 = treeNode.level * 20 - this.startx;
            if (n9 <= n7) {
                if (treeNode.selected) {
                    graphics2.fillRect(n4, n9 - 1, Math.max(n8 - 1, this.maxwidth - 1), this.fontHeight);
                    graphics.setColor(this.selectFontColor);
                    graphics.drawImage(treeNode.icon, n4, n9, this);
                    graphics.drawString(treeNode.label, n4 + 20, n9 + n5);
                    graphics.setColor(this.getForeground());
                } else {
                    graphics.setColor(this.getForeground());
                    graphics.drawImage(treeNode.icon, n4, n9, this);
                    graphics.drawString(treeNode.label, n4 + 20, n9 + n5);
                }
                n14 = (Integer)stack.peek();
                if (n14 != -1) {
                    n = n14 - this.topItem;
                    graphics.drawLine(n4 - 5, n9 + this.fontHeight / 2, n4 - 20 + 5, n9 + this.fontHeight / 2);
                    if (treeNode.handler.isDirectory(this, treeNode)) {
                        graphics.drawRect(n4 - 20 + 5 - 2, n9 + this.fontHeight / 2 - 2, 4, 4);
                    }
                    graphics.drawLine(n4 - 20 + 5, n9 + this.fontHeight / 2, n4 - 20 + 5, (n + 1) * this.fontHeight - 1);
                }
                ++this.visibleItemCount;
            } else {
                n14 = (Integer)stack.peek();
                if (n14 != -1 && ((n = n14 - this.topItem) + 1) * this.fontHeight - 1 < n7) {
                    graphics.drawLine(n4 - 20 + 5, n7 - 1, n4 - 20 + 5, (n + 1) * this.fontHeight - 1);
                }
            }
            if (this.hierarchyChanged) {
                n4 = treeNode.level * 20;
                n3 = graphics.getFontMetrics().stringWidth(treeNode.label);
                this.maxwidth = Math.max(this.maxwidth, n4 + 20 + n3);
            }
            n9 += this.fontHeight;
            ++n13;
        }
        if (this.hierarchyChanged) {
            n = n6;
            while (n < this.items.size()) {
                treeNode = (TreeNode)this.items.elementAt(n);
                n4 = treeNode.level * 20;
                n3 = graphics.getFontMetrics().stringWidth(treeNode.label);
                this.maxwidth = Math.max(this.maxwidth, n4 + 20 + n3);
                ++n;
            }
        }
        this.hierarchyChanged = false;
        this.updateScrollbars();
    }

    public void remove(TreeNode treeNode) {
        TreeNode treeNode2 = null;
        for (int i = this.items.indexOf(treeNode); i >= 0; --i) {
            treeNode2 = (TreeNode)this.items.elementAt(i);
            if (treeNode2.level >= treeNode.level) {
                continue;
            }
            --treeNode2.children;
            break;
        }
        this.items.removeElement(treeNode);
        if (treeNode.selected) {
            this.unselect(treeNode);
        }
        this.hierarchyChanged = true;
    }

    public void removeBranch(TreeNode treeNode) {
        int n = this.items.indexOf(treeNode) + 1;
        int n2 = this.items.size() - 1;
        int n3 = n;
        while (n3 < n2) {
            if (((TreeNode)this.items.elementAt((int)n)).level <= treeNode.level) break;
            this.remove((TreeNode)this.items.elementAt(n));
            ++n3;
        }
        this.remove(treeNode);
        this.hierarchyChanged = true;
    }

    public void select(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        if (this.selectionPolicy == 0) {
            this.unselectAll();
        }
        this.selection.addElement(treeNode);
        treeNode.selected = true;
    }

    public Enumeration selection() {
        return this.selection.elements();
    }

    public void setHorizontalScrollbar(Scrollbar scrollbar) {
        this.hscroll = scrollbar;
        this.hscroll.addAdjustmentListener(this);
        int n = this.getSize().width - 10;
        this.hscroll.setMaximum(n);
        this.hscroll.setVisibleAmount(n);
        this.hscroll.setBlockIncrement(20);
    }

    public void setScrollbarDisplayPolicy(int n) {
        this.scrollbarDisplayPolicy = n;
        this.hierarchyChanged = false;
    }

    public void setSelectionBackgroudColor(Color color) {
        this.selectColor = color;
    }

    public void setSelectionFontColor(Color color) {
        this.selectFontColor = color;
    }

    public void setSelectionPolicy(int n) {
        this.selectionPolicy = n;
    }

    public void setVerticalScrollbar(Scrollbar scrollbar) {
        this.vscroll = scrollbar;
        this.vscroll.addAdjustmentListener(this);
        this.vscroll.setMaximum(this.visibleItemCount);
        this.vscroll.setVisibleAmount(this.visibleItemCount);
        this.vscroll.setBlockIncrement(this.visibleItemCount);
    }

    public void unselect(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        this.selection.removeElement(treeNode);
        treeNode.selected = false;
    }

    public void unselectAll() {
        Enumeration enumeration = this.selection.elements();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = (TreeNode)enumeration.nextElement();
            treeNode.selected = false;
        }
    }

    public void update(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Image image = null;
        Dimension dimension = this.getSize();
        image = ImageCache.getImage(this, dimension.width, dimension.height);
        Graphics graphics2 = image.getGraphics();
        if (rectangle != null) {
            graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        graphics2.setColor(this.getForeground());
        this.paint(graphics2);
        graphics.drawImage(image, 0, 0, this);
    }

    private void updateScrollbars() {
        int n = this.items.size() + 1;
        if (this.items.size() > this.visibleItemCount) {
            this.vscroll.setMaximum(n);
            this.vscroll.setVisibleAmount(this.visibleItemCount);
            this.vscroll.setVisible(true);
        } else {
            this.vscroll.setValue(0);
            this.vscroll.setMaximum(n);
            this.vscroll.setVisibleAmount(n);
            if (this.scrollbarDisplayPolicy == 1) {
                this.vscroll.setVisible(false);
            }
        }
        int n2 = this.getSize().width - 10;
        this.hscroll.setMaximum(this.maxwidth);
        this.hscroll.setVisibleAmount(n2);
        if (this.maxwidth > n2) {
            this.hscroll.setVisible(true);
        } else if (this.scrollbarDisplayPolicy == 1) {
            this.hscroll.setVisible(false);
        }
    }

    private class BrowserMouseListener
    extends MouseAdapter {
        BrowserMouseListener() {
        }

        private void clickAt(TreeNode treeNode, MouseEvent mouseEvent) {
            if (treeNode == null) {
                return;
            }
            int n = mouseEvent.getX() - 5;
            if (treeNode.handler == null) {
                return;
            }
            if (n >= treeNode.level * 20 && n <= treeNode.level * 20 + 20) {
                if (treeNode.children != -1) {
                    treeNode.handler.notifyCollapse(TreeBrowser.this, treeNode);
                } else {
                    treeNode.handler.notifyExpand(TreeBrowser.this, treeNode);
                }
            } else if (n > treeNode.level * 20 + 10) {
                treeNode.handler.notifySelect(TreeBrowser.this, treeNode);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            TreeNode treeNode;
            if (mouseEvent.getClickCount() > 1 && (treeNode = TreeBrowser.this.itemAt(n = mouseEvent.getY() - 5)) != null && treeNode.handler != null) {
                treeNode.handler.notifyExecute(TreeBrowser.this, treeNode);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getY() - 5;
            if (mouseEvent.getClickCount() == 1) {
                this.clickAt(TreeBrowser.this.itemAt(n), mouseEvent);
            }
        }
    }
}

