/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.upgrade;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.w3c.tools.resources.upgrade.Attribute;

public class StringArrayAttribute
extends Attribute {
    public StringArrayAttribute(String string, String[] stringArray, Integer n) {
        super(string, stringArray, n);
        this.type = "java.lang.String[]";
    }

    public boolean checkValue(Object object) {
        return object instanceof String[];
    }

    public int getPickleLength(Object object) {
        String[] stringArray = (String[])object;
        int n = 4;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            int n3 = string.length();
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3) {
                char c = string.charAt(n5);
                n4 = c >= '\u0001' && c <= '\u007f' ? ++n4 : (c > '\u07ff' ? (n4 += 3) : (n4 += 2));
                ++n5;
            }
            n += n4 + 2;
            ++n2;
        }
        return n;
    }

    public void pickle(DataOutputStream dataOutputStream, Object object) throws IOException {
        String[] stringArray = (String[])object;
        dataOutputStream.writeInt(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            dataOutputStream.writeUTF(stringArray[n]);
            ++n;
        }
    }

    public String stringify(Object object) {
        if (object == null || !(object instanceof String[])) {
            return null;
        }
        String[] stringArray = (String[])object;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append('|');
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public Object unpickle(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = dataInputStream.readUTF();
            ++n2;
        }
        return stringArray;
    }
}

