/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.store;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.tools.resources.store.NewReference;
import org.w3c.tools.resources.store.ResourceStore;
import org.w3c.tools.resources.store.ResourceStoreImpl;
import org.w3c.tools.resources.store.ResourceStoreManager;
import org.w3c.util.LRUAble;

public class NewStoreEntry
extends AttributeHolder
implements LRUAble {
    protected static int ATTR_REPOSITORY = -1;
    protected static int ATTR_KEY = -1;
    boolean istransient = false;
    LRUAble next = null;
    LRUAble prev = null;
    ResourceStore store = null;
    Hashtable references = null;
    ResourceStoreManager manager = null;
    File rep = null;

    static {
        SimpleAttribute simpleAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.tools.resources.store.NewStoreEntry");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        simpleAttribute = new StringAttribute("repository", null, 4);
        ATTR_REPOSITORY = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new IntegerAttribute("key", null, 4);
        ATTR_KEY = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
    }

    public NewStoreEntry() {
    }

    NewStoreEntry(ResourceStoreManager resourceStoreManager, File file, Integer n) {
        this.manager = resourceStoreManager;
        this.store = null;
        this.rep = file;
        this.references = new Hashtable();
        this.setValue(ATTR_KEY, (Object)n);
    }

    NewStoreEntry(ResourceStoreManager resourceStoreManager, String string, Integer n) {
        this.manager = resourceStoreManager;
        this.store = null;
        this.references = new Hashtable();
        this.setValue(ATTR_REPOSITORY, (Object)string);
        this.setValue(ATTR_KEY, (Object)n);
    }

    synchronized ResourceReference addResource(Resource resource, Hashtable hashtable) {
        this.getStore();
        this.store.addResource(resource);
        String string = resource.getIdentifier();
        NewReference newReference = new NewReference(this, string, hashtable);
        this.references.put(string, newReference);
        return newReference;
    }

    synchronized void deleteStore() {
        Enumeration enumeration = this.references.elements();
        NewReference newReference = null;
        while (enumeration.hasMoreElements()) {
            newReference = (NewReference)enumeration.nextElement();
            newReference.invalidate();
        }
        this.getRepository().delete();
        if (this.store != null) {
            this.store = null;
            this.manager.decrLoadedStore();
        }
        this.references = null;
    }

    public synchronized Enumeration enumerateResourceIdentifiers() {
        this.getStore();
        return this.store.enumerateResourceIdentifiers();
    }

    protected Integer getKey() {
        return (Integer)this.getValue(ATTR_KEY, null);
    }

    public LRUAble getNext() {
        return this.next;
    }

    public LRUAble getPrev() {
        return this.prev;
    }

    protected File getRepository() {
        String string = this.getString(ATTR_REPOSITORY, null);
        if (this.rep == null) {
            this.rep = new File(this.manager.storedir, string);
        }
        return this.rep;
    }

    synchronized ResourceStore getStore() {
        if (this.store == null) {
            this.store = new ResourceStoreImpl();
            this.store.initialize(this.manager, this, this.getRepository(), this.manager.serializer);
            this.manager.incrLoadedStore();
        }
        return this.store;
    }

    void initialize(ResourceStoreManager resourceStoreManager) {
        this.manager = resourceStoreManager;
        this.references = new Hashtable();
    }

    public boolean isTransient() {
        return this.istransient;
    }

    synchronized ResourceReference loadResource(String string, Hashtable hashtable) {
        ResourceReference resourceReference = this.lookupResource(string);
        if (resourceReference != null) {
            return resourceReference;
        }
        resourceReference = new NewReference(this, string, hashtable);
        try {
            try {
                Resource resource = resourceReference.lock();
                if (resource == null) {
                    ResourceReference resourceReference2 = null;
                    Object var6_7 = null;
                    resourceReference.unlock();
                    return resourceReference2;
                }
            }
            catch (InvalidResourceException invalidResourceException) {
                ResourceReference resourceReference3 = null;
                Object var6_8 = null;
                resourceReference.unlock();
                return resourceReference3;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            resourceReference.unlock();
            throw throwable;
        }
        Object var6_9 = null;
        resourceReference.unlock();
        this.references.put(string, resourceReference);
        return resourceReference;
    }

    public ResourceReference lookupResource(String string) {
        return (ResourceReference)this.references.get(string);
    }

    public synchronized void markModified(Resource resource) {
        this.getStore();
        this.store.markModified(resource);
    }

    public synchronized void removeResource(String string) {
        this.getStore();
        NewReference newReference = (NewReference)this.references.get(string);
        if (newReference != null) {
            this.references.remove(string);
            this.manager.getEventQueue().removeSourceEvents(newReference);
            newReference.invalidate();
        }
        this.store.removeResource(string);
    }

    public synchronized void renameResource(String string, String string2) {
        this.getStore();
        this.store.renameResource(string, string2);
        NewReference newReference = (NewReference)this.lookupResource(string);
        if (newReference != null) {
            newReference.identifier = string2;
            this.references.remove(string);
            this.references.put(string2, newReference);
        }
    }

    synchronized void saveResource(Resource resource) {
        this.getStore();
        this.store.saveResource(resource);
    }

    synchronized void saveStore() {
        if (this.store != null) {
            this.store.save();
        }
    }

    public void setNext(LRUAble lRUAble) {
        this.next = lRUAble;
    }

    public void setPrev(LRUAble lRUAble) {
        this.prev = lRUAble;
    }

    public void setTransient(boolean bl) {
        this.istransient = bl;
    }

    synchronized void shutdownStore() {
        if (this.store != null) {
            this.store.shutdown();
            this.store = null;
            this.manager.decrLoadedStore();
        }
    }

    synchronized boolean unloadStore() {
        if (this.store != null) {
            Enumeration enumeration = this.references.elements();
            ResourceReference resourceReference = null;
            while (enumeration.hasMoreElements()) {
                resourceReference = (ResourceReference)enumeration.nextElement();
                if (!resourceReference.isLocked()) continue;
                return false;
            }
            if (!this.store.acceptUnload()) {
                return false;
            }
            this.shutdownStore();
        }
        return true;
    }
}

