/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.serialization.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.serialization.ResourceDescription;
import org.w3c.tools.resources.serialization.SerializationException;
import org.w3c.tools.resources.serialization.Serializer;
import org.w3c.tools.resources.serialization.xml.JigXML;
import org.w3c.tools.resources.serialization.xml.XMLDescrReader;
import org.w3c.tools.resources.serialization.xml.XMLDescrWriter;
import org.w3c.tools.resources.serialization.xml.XMLReader;
import org.w3c.tools.resources.serialization.xml.XMLResourceWriter;
import org.w3c.tools.resources.serialization.xml.XMLSubsetReader;
import org.w3c.util.LookupTable;
import org.xml.sax.Parser;

public class XMLSerializer
implements Serializer,
JigXML {
    public static final String PARSER_P = "com.jclark.xml.sax.Driver";
    protected Class parser_class = null;

    public XMLSerializer() {
        try {
            this.parser_class = Class.forName(PARSER_P);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.parser_class = null;
        }
    }

    protected Parser getParser() throws SerializationException {
        try {
            return (Parser)this.parser_class.newInstance();
        }
        catch (Exception exception) {
            throw new SerializationException("Unable to intantiate : com.jclark.xml.sax.Driver");
        }
    }

    public AttributeHolder[] readAttributeHolders(Reader reader) throws IOException, SerializationException {
        Parser parser = this.getParser();
        XMLReader xMLReader = new XMLReader(reader, parser);
        return xMLReader.readAttributeHolders();
    }

    public LookupTable[] readAttributes(Reader reader, String[] stringArray) throws IOException, SerializationException {
        Parser parser = this.getParser();
        XMLSubsetReader xMLSubsetReader = new XMLSubsetReader(reader, parser, stringArray);
        return xMLSubsetReader.readAttributeTables();
    }

    public ResourceDescription[] readResourceDescriptions(Reader reader) throws IOException, SerializationException {
        Parser parser = this.getParser();
        XMLDescrReader xMLDescrReader = new XMLDescrReader(reader, parser);
        return xMLDescrReader.readResourceDescriptions();
    }

    public Resource[] readResources(Reader reader) throws IOException, SerializationException {
        Parser parser = this.getParser();
        XMLReader xMLReader = new XMLReader(reader, parser);
        return xMLReader.readResources();
    }

    public void writeResourceDescriptions(Resource[] resourceArray, Writer writer) throws IOException, SerializationException {
        XMLResourceWriter xMLResourceWriter = new XMLResourceWriter(writer);
        xMLResourceWriter.startDocument();
        int n = 0;
        while (n < resourceArray.length) {
            xMLResourceWriter.writeResourceDescription(resourceArray[n]);
            ++n;
        }
        xMLResourceWriter.closeDocument();
    }

    public void writeResourceDescriptions(ResourceDescription[] resourceDescriptionArray, Writer writer) throws IOException, SerializationException {
        XMLDescrWriter xMLDescrWriter = new XMLDescrWriter(writer);
        xMLDescrWriter.startDocument();
        int n = 0;
        while (n < resourceDescriptionArray.length) {
            xMLDescrWriter.writeResourceDescription(resourceDescriptionArray[n]);
            ++n;
        }
        xMLDescrWriter.closeDocument();
    }

    public void writeResources(AttributeHolder[] attributeHolderArray, Writer writer) throws IOException, SerializationException {
        XMLResourceWriter xMLResourceWriter = new XMLResourceWriter(writer);
        xMLResourceWriter.startDocument();
        int n = 0;
        while (n < attributeHolderArray.length) {
            xMLResourceWriter.writeResource(attributeHolderArray[n]);
            ++n;
        }
        xMLResourceWriter.closeDocument();
    }
}

