/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.serialization.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.tools.resources.ArrayAttribute;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.ContainerInterface;
import org.w3c.tools.resources.FrameArrayAttribute;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.serialization.xml.JigXML;
import org.w3c.tools.resources.serialization.xml.XMLWriter;

public class XMLResourceWriter
extends XMLWriter
implements JigXML {
    public XMLResourceWriter(Writer writer) {
        super(writer);
    }

    protected void startResource(AttributeHolder attributeHolder) throws IOException {
        String string = attributeHolder.getClass().getName();
        this.writer.write("<resource class='" + string + "'>\n");
    }

    protected void startResourceDescr(AttributeHolder attributeHolder) throws IOException {
        int n;
        String string = attributeHolder.getClass().getName();
        this.writer.write("<resource class='" + string + "'>\n");
        Vector<String> vector = new Vector<String>(10);
        Class<?> clazz = attributeHolder.getClass();
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray != null) {
            n = 0;
            while (n < classArray.length) {
                vector.addElement(classArray[n].getName());
                ++n;
            }
        }
        this.writeInherit(clazz.getSuperclass(), vector);
        ++this.level;
        n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            this.indent();
            this.writer.write("<implements class='" + string2 + "'/>\n");
            ++n;
        }
        --this.level;
        this.writeChildren(attributeHolder);
    }

    protected void writeAttribute(Attribute attribute, Object object, boolean bl) throws IOException {
        ++this.level;
        if (attribute instanceof SimpleAttribute) {
            this.indent();
            this.writer.write("<attribute name='" + attribute.getName() + "' ");
            this.writer.write("flag='" + attribute.getFlag() + "' ");
            this.writer.write("class='" + attribute.getClass().getName() + "'>");
            if (object == null) {
                this.writer.write("@@NULL@@");
            } else {
                this.writer.write(XMLWriter.encode(((SimpleAttribute)attribute).pickle(object)));
            }
            this.writer.write("</attribute>\n");
        } else if (attribute instanceof ArrayAttribute) {
            this.indent();
            this.writer.write("<array name='" + attribute.getName() + "' ");
            this.writer.write("flag='" + attribute.getFlag() + "' ");
            this.writer.write("class='" + attribute.getClass().getName() + "' ");
            String[] stringArray = null;
            stringArray = object == null ? new String[]{} : ((ArrayAttribute)attribute).pickle(object);
            int n = stringArray.length;
            this.writer.write("length='" + n + "'>\n");
            ++this.level;
            int n2 = 0;
            while (n2 < n) {
                this.indent();
                this.writer.write("<value>" + XMLWriter.encode(stringArray[n2]) + "</" + "value" + ">\n");
                ++n2;
            }
            --this.level;
            this.indent();
            this.writer.write("</array>\n");
        } else if (attribute instanceof FrameArrayAttribute) {
            this.indent();
            this.writer.write("<resourcearray name='" + attribute.getName() + "' ");
            this.writer.write("class='" + attribute.getClass().getName() + "' ");
            ResourceFrame[] resourceFrameArray = null;
            resourceFrameArray = object == null ? new ResourceFrame[]{} : (ResourceFrame[])object;
            int n = resourceFrameArray.length;
            this.writer.write("length='" + n + "'>\n");
            if (bl) {
                int n3 = 0;
                while (n3 < n) {
                    this.writeResourceDescription(resourceFrameArray[n3]);
                    ++n3;
                }
            } else {
                int n4 = 0;
                while (n4 < n) {
                    this.writeResource(resourceFrameArray[n4]);
                    ++n4;
                }
            }
            this.indent();
            this.writer.write("</resourcearray>\n");
        }
        --this.level;
    }

    protected void writeChildren(AttributeHolder attributeHolder) throws IOException {
        if (attributeHolder instanceof ContainerInterface) {
            Vector<String> vector = new Vector<String>();
            Enumeration enumeration = ((ContainerInterface)((Object)attributeHolder)).enumerateResourceIdentifiers(true);
            while (enumeration.hasMoreElements()) {
                vector.addElement((String)enumeration.nextElement());
            }
            int n = vector.size();
            ++this.level;
            this.indent();
            this.writer.write("<children length='" + n + "'>\n");
            ++this.level;
            int n2 = 0;
            while (n2 < n) {
                this.indent();
                this.writer.write("<child>" + (String)vector.elementAt(n2) + "</" + "child" + ">\n");
                ++n2;
            }
            --this.level;
            this.indent();
            this.writer.write("</children>\n");
            --this.level;
        }
    }

    protected void writeInherit(Class clazz, Vector vector) throws IOException {
        if (clazz != null) {
            ++this.level;
            this.indent();
            this.writer.write("<inherit class='" + clazz.getName() + "'>\n");
            Class<?>[] classArray = clazz.getInterfaces();
            if (classArray != null) {
                int n = 0;
                while (n < classArray.length) {
                    vector.addElement(classArray[n].getName());
                    ++n;
                }
            }
            this.writeInherit(clazz.getSuperclass(), vector);
            this.indent();
            this.writer.write("</inherit>\n");
            --this.level;
        }
    }

    public void writeResource(AttributeHolder attributeHolder) throws IOException {
        ++this.level;
        this.indent();
        this.startResource(attributeHolder);
        Attribute[] attributeArray = attributeHolder.getAttributes();
        int n = 0;
        while (n < attributeArray.length) {
            Object object = attributeHolder.getValue(n, null);
            if (!attributeArray[n].checkFlag(8)) {
                this.writeAttribute(attributeArray[n], object, false);
            }
            ++n;
        }
        this.indent();
        this.closeResource();
        --this.level;
    }

    public void writeResourceDescription(AttributeHolder attributeHolder) throws IOException {
        ++this.level;
        this.indent();
        this.startResourceDescr(attributeHolder);
        Attribute[] attributeArray = attributeHolder.getAttributes();
        int n = 0;
        while (n < attributeArray.length) {
            Object object = attributeHolder.getValue(n, null);
            if (!attributeArray[n].checkFlag(8)) {
                this.writeAttribute(attributeArray[n], object, true);
            }
            ++n;
        }
        this.indent();
        this.closeResource();
        --this.level;
    }
}

