/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.event;

import org.w3c.tools.resources.event.Dispatcher;
import org.w3c.tools.resources.event.ResourceEvent;

public class ResourceEventQueue {
    protected boolean debug = false;
    private QueueCell queue = null;
    private QueueCell last = null;

    public ResourceEventQueue() {
        new Dispatcher("ResourceEventQueue Dispatcher", this).start();
    }

    public synchronized ResourceEvent getNextEvent() throws InterruptedException {
        while (this.queue == null) {
            this.wait();
        }
        QueueCell queueCell = this.queue;
        this.queue = this.queue.next;
        if (this.queue == null) {
            this.last = null;
        }
        return queueCell.event;
    }

    public synchronized void removeSourceEvents(Object object) {
        QueueCell queueCell = this.queue;
        QueueCell queueCell2 = null;
        while (queueCell != null) {
            if (queueCell.event.getSource() == object) {
                if (queueCell2 == null) {
                    this.queue = queueCell.next;
                } else {
                    queueCell2.next = queueCell.next;
                    if (queueCell2.next == null) {
                        this.last = queueCell2;
                    }
                }
            }
            queueCell2 = queueCell;
            queueCell = queueCell.next;
        }
    }

    public synchronized void sendEvent(ResourceEvent resourceEvent) {
        if (this.debug) {
            System.out.println("[QUEUE] : sendEvent " + resourceEvent.getID());
        }
        QueueCell queueCell = new QueueCell(resourceEvent);
        if (this.queue == null) {
            this.queue = queueCell;
            this.last = queueCell;
            this.notifyAll();
        } else if (queueCell.id == 1001 || queueCell.id == 2002) {
            if (this.debug) {
                System.out.println("[QUEUE] : remove old modified event");
            }
            QueueCell queueCell2 = this.queue;
            while (queueCell2 != null) {
                if (queueCell2.id == queueCell.id && queueCell2.event.getSource() == queueCell.event.getSource()) {
                    if (this.debug) {
                        System.out.println("[QUEUE] : Found one!");
                    }
                    queueCell2.event = queueCell.event;
                    break;
                }
                queueCell2 = queueCell2.next;
            }
            if (queueCell2 == null) {
                if (this.debug) {
                    System.out.println("[QUEUE] : add new event.");
                }
                this.last.next = queueCell;
                this.last = queueCell;
            }
        } else {
            this.last.next = queueCell;
            this.last = queueCell;
        }
    }

    class QueueCell {
        ResourceEvent event;
        QueueCell next;
        int id;

        QueueCell(ResourceEvent resourceEvent) {
            this.event = resourceEvent;
            this.next = null;
            this.id = resourceEvent.getID();
        }
    }
}

