/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources;

import java.net.URLEncoder;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.tools.resources.AbstractContainer;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceContext;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.ResourceSpace;
import org.w3c.tools.resources.SpaceEntry;
import org.w3c.tools.resources.SpaceEntryImpl;
import org.w3c.tools.resources.event.StructureChangedEvent;

public class ContainerResource
extends AbstractContainer {
    protected static int ATTR_KEY = -1;
    protected boolean acquired = false;

    static {
        IntegerAttribute integerAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.tools.resources.ContainerResource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        integerAttribute = new IntegerAttribute("key", null, 1);
        ATTR_KEY = AttributeRegistry.registerAttribute(clazz, integerAttribute);
    }

    protected synchronized void acquireChildren() {
        if (!this.acquired) {
            ResourceSpace resourceSpace = this.getSpace();
            resourceSpace.acquireChildren(this.getChildrenSpaceEntry());
            this.acquired = true;
        }
    }

    protected synchronized ResourceReference addResource(Resource resource, Hashtable hashtable) {
        this.acquireChildren();
        ResourceReference resourceReference = this.getSpace().addResource(this.getChildrenSpaceEntry(), resource, hashtable);
        resource.getContext().setResourceReference(resourceReference);
        if (resource instanceof FramedResource) {
            FramedResource framedResource = (FramedResource)resource;
            framedResource.addStructureChangedListener(this);
        }
        this.markModified();
        this.postStructureChangedEvent(resourceReference, 1002);
        return resourceReference;
    }

    public ResourceReference createDefaultResource(String string) {
        return null;
    }

    public synchronized void delete() throws MultipleLockException {
        this.disableEvent();
        ResourceSpace resourceSpace = this.getSpace();
        this.acquireChildren();
        this.deleteChildren();
        this.disableEvent();
        SpaceEntry spaceEntry = this.getChildrenSpaceEntry();
        super.delete();
        resourceSpace.deleteChildren(spaceEntry);
    }

    public void delete(String string) throws MultipleLockException {
        ResourceReference resourceReference = null;
        resourceReference = this.lookup(string);
        if (resourceReference != null) {
            try {
                try {
                    ResourceReference resourceReference2 = resourceReference;
                    synchronized (resourceReference2) {
                        Resource resource = resourceReference.lock();
                        if (resource instanceof FramedResource) {
                            ((FramedResource)resource).removeStructureChangedListener(this);
                        }
                        resource.delete();
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                }
                Object var4_5 = null;
                resourceReference.unlock();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                resourceReference.unlock();
                throw throwable;
            }
        }
    }

    protected synchronized void deleteChildren() throws MultipleLockException {
        this.disableEvent();
        this.acquireChildren();
        Enumeration enumeration = this.enumerateResourceIdentifiers();
        while (enumeration.hasMoreElements()) {
            this.delete((String)enumeration.nextElement());
        }
        this.enableEvent();
    }

    public synchronized Enumeration enumerateResourceIdentifiers(boolean bl) {
        ResourceSpace resourceSpace = this.getSpace();
        this.acquireChildren();
        return resourceSpace.enumerateResourceIdentifiers(this.getChildrenSpaceEntry());
    }

    protected SpaceEntry getChildrenSpaceEntry() {
        return new SpaceEntryImpl(this);
    }

    public Object getClone(Object[] objectArray) {
        objectArray[ContainerResource.ATTR_KEY] = null;
        return super.getClone(objectArray);
    }

    public Integer getKey() {
        Integer n = (Integer)this.getValue(ATTR_KEY, null);
        if (n == null) {
            n = new Integer(this.getIdentifier().hashCode() ^ new Date().hashCode());
            this.setValue(ATTR_KEY, (Object)n);
        }
        return n;
    }

    protected int getMatchingCharsCount(String string, String string2) {
        int n = -1;
        int n2 = 0;
        if (string == null || string2 == null || (n = string.length()) != string2.length()) {
            return -1;
        }
        int n3 = 0;
        while (n3 < n) {
            char c;
            char c2 = string.charAt(n3);
            if (c2 == (c = string2.charAt(n3))) {
                ++n2;
            } else if ((c2 = Character.toUpperCase(c2)) != (c = Character.toUpperCase(c))) {
                return -1;
            }
            ++n3;
        }
        return n2;
    }

    protected SpaceEntry getSpaceEntry() {
        ResourceReference resourceReference = this.getParent();
        if (resourceReference == null) {
            return new SpaceEntryImpl(this);
        }
        try {
            try {
                ContainerResource containerResource = (ContainerResource)resourceReference.lock();
                SpaceEntryImpl spaceEntryImpl = new SpaceEntryImpl(containerResource);
                Object var4_6 = null;
                resourceReference.unlock();
                return spaceEntryImpl;
            }
            catch (InvalidResourceException invalidResourceException) {
                System.out.println(invalidResourceException.getMessage());
                invalidResourceException.printStackTrace();
                SpaceEntry spaceEntry = null;
                Object var4_7 = null;
                resourceReference.unlock();
                return spaceEntry;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            resourceReference.unlock();
            throw throwable;
        }
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        this.disableEvent();
        String string = this.getURLPath();
        if (string != null && !string.endsWith("/")) {
            this.setValue(Resource.ATTR_URL, (Object)(String.valueOf(string) + "/"));
        }
        this.acquired = false;
        this.enableEvent();
    }

    protected ResourceReference internalLookup(String string, SpaceEntry spaceEntry, ResourceSpace resourceSpace) {
        ResourceReference resourceReference = resourceSpace.lookupResource(spaceEntry, string);
        if (resourceReference != null) {
            return resourceReference;
        }
        ContainerResource containerResource = this;
        synchronized (containerResource) {
            resourceReference = resourceSpace.lookupResource(spaceEntry, string);
            if (resourceReference != null) {
                ResourceReference resourceReference2 = resourceReference;
                Object var7_7 = null;
                return resourceReference2;
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>(5);
            hashtable.put("identifier", string);
            ResourceContext resourceContext = this.updateDefaultChildAttributes(hashtable);
            resourceReference = resourceSpace.loadResource(spaceEntry, string, hashtable);
            if (resourceReference != null) {
                resourceContext.setResourceReference(resourceReference);
                try {
                    try {
                        Resource resource = resourceReference.lock();
                        if (resource instanceof FramedResource) {
                            FramedResource framedResource = (FramedResource)resource;
                            framedResource.addStructureChangedListener(this);
                        }
                    }
                    catch (InvalidResourceException invalidResourceException) {
                    }
                    Object var11_12 = null;
                    resourceReference.unlock();
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    resourceReference.unlock();
                    throw throwable;
                }
            }
        }
        return resourceReference;
    }

    public ResourceReference lookup(String string) {
        this.acquireChildren();
        SpaceEntry spaceEntry = this.getChildrenSpaceEntry();
        ResourceSpace resourceSpace = this.getSpace();
        ResourceReference resourceReference = this.internalLookup(string, spaceEntry, resourceSpace);
        if (resourceReference == null && !this.getServer().checkFileSystemSensitivity()) {
            Enumeration enumeration = resourceSpace.enumerateResourceIdentifiers(spaceEntry);
            int n = -1;
            String string2 = null;
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                int n2 = this.getMatchingCharsCount(string, string3);
                if (n2 <= n) continue;
                n = n2;
                string2 = string3;
            }
            if (string2 != null) {
                resourceReference = this.internalLookup(string2, spaceEntry, resourceSpace);
            }
        }
        return resourceReference;
    }

    public boolean lookup(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        if (super.lookup(lookupState, lookupResult)) {
            return true;
        }
        String string = lookupState.getNextComponent();
        ResourceReference resourceReference = null;
        resourceReference = this.lookup(string);
        if (resourceReference == null) {
            lookupResult.setTarget(null);
            return false;
        }
        try {
            try {
                lookupResult.setTarget(resourceReference);
                FramedResource framedResource = (FramedResource)resourceReference.lock();
                boolean bl = framedResource != null ? framedResource.lookup(lookupState, lookupResult) : false;
                Object var7_8 = null;
                resourceReference.unlock();
                return bl;
            }
            catch (InvalidResourceException invalidResourceException) {
                boolean bl = false;
                Object var7_9 = null;
                resourceReference.unlock();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            resourceReference.unlock();
            throw throwable;
        }
    }

    public void notifyUnload() {
        super.notifyUnload();
    }

    public void registerResource(String string, Resource resource, Hashtable hashtable) throws InvalidResourceException {
        ResourceReference resourceReference;
        this.acquireChildren();
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>(11);
        }
        hashtable.put("identifier", string);
        ResourceContext resourceContext = this.updateDefaultChildAttributes(hashtable);
        if (resourceContext != null) {
            resource.initialize(hashtable);
            resourceReference = this.getSpace().addResource(this.getChildrenSpaceEntry(), resource, hashtable);
            resourceContext.setResourceReference(resourceReference);
            if (resource instanceof FramedResource) {
                FramedResource framedResource = (FramedResource)resource;
                framedResource.addStructureChangedListener(this);
            }
        } else {
            throw new InvalidResourceException(this.getIdentifier(), string, "unable to get context");
        }
        this.markModified();
        this.postStructureChangedEvent(resourceReference, 1002);
    }

    public synchronized void replace(DirectoryResource directoryResource) throws MultipleLockException {
        Enumeration enumeration = this.enumerateResourceIdentifiers();
        ResourceReference resourceReference = null;
        Resource resource = null;
        while (enumeration.hasMoreElements()) {
            Object var6_5;
            resourceReference = this.lookup((String)enumeration.nextElement());
            if (resourceReference == null) continue;
            try {
                try {
                    resource = resourceReference.lock();
                    ResourceContext resourceContext = new ResourceContext(directoryResource.getContext());
                    resource.setContext(resourceContext, true);
                    if (resource instanceof FramedResource) {
                        ((FramedResource)resource).removeStructureChangedListener(this);
                        ((FramedResource)resource).addStructureChangedListener(directoryResource);
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                }
                var6_5 = null;
                resourceReference.unlock();
            }
            catch (Throwable throwable) {
                var6_5 = null;
                resourceReference.unlock();
                throw throwable;
            }
        }
        super.delete();
    }

    public void resourceCreated(StructureChangedEvent structureChangedEvent) {
        if (!this.isUnloaded()) {
            super.resourceCreated(structureChangedEvent);
        }
    }

    public void resourceModified(StructureChangedEvent structureChangedEvent) {
        if (!this.isUnloaded()) {
            super.resourceModified(structureChangedEvent);
        }
    }

    public void resourceRemoved(StructureChangedEvent structureChangedEvent) {
        if (!this.isUnloaded()) {
            super.resourceRemoved(structureChangedEvent);
        }
    }

    protected ResourceContext updateDefaultChildAttributes(Hashtable hashtable) {
        String string;
        ResourceContext resourceContext = super.updateDefaultChildAttributes(hashtable);
        if (resourceContext == null) {
            resourceContext = new ResourceContext(this.getContext());
            hashtable.put("context", resourceContext);
        }
        if ((string = (String)hashtable.get("identifier")) != null) {
            hashtable.put("url", String.valueOf(this.getURLPath()) + URLEncoder.encode(string));
        }
        return resourceContext;
    }
}

