/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jpeg;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.w3c.tools.jpeg.Jpeg;
import org.w3c.tools.jpeg.JpegException;

public class JpegHeaders
implements Jpeg {
    protected File jpegfile = null;
    protected InputStream in = null;
    protected Vector vcom = null;
    protected Vector vacom = null;
    protected String[] comments = null;
    protected String[] appcomments = null;

    public JpegHeaders(File file) throws FileNotFoundException {
        this.jpegfile = file;
        this.in = new BufferedInputStream(new FileInputStream(file));
        try {
            this.scanHeaders();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JpegHeaders(InputStream inputStream) {
        this.in = inputStream;
        try {
            this.scanHeaders();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected int firstMarker() throws IOException, JpegException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n != 255 || n2 != 216) {
            throw new JpegException("Not a JPEG file");
        }
        return n2;
    }

    public String[] getAPP12Comments() {
        if (this.appcomments == null) {
            this.appcomments = new String[this.vacom.size()];
            this.vacom.copyInto(this.appcomments);
        }
        return this.appcomments;
    }

    public String[] getComments() {
        if (this.comments == null) {
            this.comments = new String[this.vcom.size()];
            this.vcom.copyInto(this.comments);
        }
        return this.comments;
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            JpegHeaders jpegHeaders = new JpegHeaders(new File(stringArray[0]));
            String[] stringArray2 = jpegHeaders.getComments();
            if (stringArray2 != null) {
                System.out.println("Comments: ");
                n = 0;
                while (n < stringArray2.length) {
                    System.out.println(stringArray2[n]);
                    ++n;
                }
            }
            if ((stringArray2 = jpegHeaders.getAPP12Comments()) != null) {
                System.out.println("APP12 Comments: ");
                n = 0;
                while (n < stringArray2.length) {
                    System.out.println(stringArray2[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected int nextMarker() throws IOException {
        boolean bl = false;
        int n = this.in.read();
        while (n != 255) {
            n = this.in.read();
        }
        while ((n = this.in.read()) == 255) {
        }
        return n;
    }

    protected String processComment() throws IOException, JpegException {
        int n = this.read2bytes();
        if (n < 2) {
            throw new JpegException("Erroneous JPEG marker length");
        }
        StringBuffer stringBuffer = new StringBuffer(n -= 2);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n > 0) {
            int n3 = this.in.read(byArray, n2, n);
            if (n3 < 0) {
                throw new JpegException("EOF while reading jpeg comment");
            }
            n2 += n3;
            n -= n3;
        }
        return new String(byArray, "UTF8");
    }

    protected int read2bytes() throws IOException, JpegException {
        int n = this.in.read();
        if (n == -1) {
            throw new JpegException("Premature EOF in JPEG file");
        }
        int n2 = this.in.read();
        if (n2 == -1) {
            throw new JpegException("Premature EOF in JPEG file");
        }
        return (n << 8) + n2;
    }

    protected int scanHeaders() throws IOException, JpegException {
        this.vcom = new Vector(1);
        this.vacom = new Vector(1);
        if (this.firstMarker() != 216) {
            throw new JpegException("Expected SOI marker first");
        }
        block7: while (true) {
            int n = this.nextMarker();
            switch (n) {
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 197: 
                case 198: 
                case 199: 
                case 201: 
                case 202: 
                case 203: 
                case 205: 
                case 206: 
                case 207: {
                    this.skipVariable();
                    continue block7;
                }
                case 218: {
                    return n;
                }
                case 217: {
                    return n;
                }
                case 254: {
                    this.vcom.addElement(this.processComment());
                    continue block7;
                }
                case 236: {
                    this.vacom.addElement(this.processComment());
                    continue block7;
                }
            }
            this.skipVariable();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void skipVariable() throws IOException, JpegException {
        var1_1 = (long)this.read2bytes() - 2L;
        if (var1_1 >= 0L) ** GOTO lbl8
        throw new JpegException("Erroneous JPEG marker length");
lbl-1000:
        // 1 sources

        {
            var3_2 = this.in.skip(var1_1);
            if (var3_2 < 0L) {
                throw new IOException("Error while reading jpeg stream");
            }
            var1_1 -= var3_2;
lbl8:
            // 2 sources

            ** while (var1_1 > 0L)
        }
lbl9:
        // 1 sources

    }
}

