/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.forms;

import java.awt.Frame;
import java.awt.Panel;
import java.util.Vector;
import org.w3c.tools.forms.BooleanField;
import org.w3c.tools.forms.FormField;
import org.w3c.tools.forms.FormPanel;
import org.w3c.tools.forms.IllegalFieldValueException;
import org.w3c.tools.forms.IntegerField;
import org.w3c.tools.forms.OptionField;
import org.w3c.tools.forms.RangedIntegerField;
import org.w3c.tools.forms.StringField;

public class FormManager {
    protected Vector vfields = null;
    protected FormField[] fields = null;
    protected int cursor = 0;
    protected boolean finished = false;
    protected String title = null;
    protected FormPanel panel = null;

    public FormManager(String string) {
        this.title = string;
        this.vfields = new Vector();
    }

    public void addField(FormField formField) {
        if (this.finished) {
            throw new RuntimeException("This form has been finished.");
        }
        this.vfields.addElement(formField);
    }

    protected FormPanel createPanel() {
        this.panel = new FormPanel(this);
        int n = 0;
        while (n < this.fields.length) {
            this.panel.addField(this.fields[n].getTitle(), this.fields[n].getEditor());
            ++n;
        }
        return this.panel;
    }

    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.fields = new FormField[this.vfields.size()];
        this.vfields.copyInto(this.fields);
        this.vfields = null;
    }

    public Panel getPanel() {
        if (!this.finished) {
            this.finish();
        }
        if (this.panel == null) {
            this.panel = this.createPanel();
        }
        return this.panel;
    }

    protected void gotFocus(FormField formField) {
        int n = 0;
        while (n < this.fields.length) {
            if (this.fields[n] == formField) {
                this.cursor = n;
                break;
            }
            ++n;
        }
    }

    public void gotoField(int n) {
        if (n < 0 || n >= this.fields.length) {
            throw new RuntimeException("invalid form cursor:" + this.cursor);
        }
        this.cursor = n;
        this.fields[this.cursor].getEditor().requestFocus();
    }

    public static void main(String[] stringArray) throws IllegalFieldValueException {
        FormManager formManager = new FormManager("test");
        FormField formField = null;
        formField = new StringField(formManager, "field-1", "title-1", "value-1");
        formManager.addField(formField);
        formField = new StringField(formManager, "field-2", "title-2", "value-2");
        formManager.addField(formField);
        formField = new IntegerField(formManager, "field-3", "title-3", 10);
        formManager.addField(formField);
        String[] stringArray2 = new String[]{"option-1", "option-2", "foo", "bar", "etc"};
        formField = new OptionField(formManager, "field-4", "title-4", stringArray2, 0);
        formManager.addField(formField);
        formField = new BooleanField(formManager, "field-5", "title-5", true);
        formManager.addField(formField);
        formField = new RangedIntegerField(formManager, "field-6", "title-6", 0, 10000, 5000);
        formManager.addField(formField);
        Panel panel = formManager.getPanel();
        Frame frame = new Frame("form test");
        frame.add("Center", panel);
        frame.pack();
        frame.resize(frame.preferredSize());
        frame.show();
    }

    public void nextField() {
        this.gotoField((this.cursor + 1) % this.fields.length);
    }

    public void notifyChange(FormField formField) {
    }
}

