/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.resources;

import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.resources.CheckpointResource;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ResourceException;

public class CheckpointFrame
extends HTTPFrame {
    public CheckpointResource getChekpointResource() {
        if (this.getResource() instanceof CheckpointResource) {
            return (CheckpointResource)this.getResource();
        }
        return null;
    }

    protected Reply getOtherResource(Request request) throws ProtocolException, ResourceException {
        CheckpointResource checkpointResource = this.getChekpointResource();
        if (checkpointResource == null) {
            throw new ResourceException("this frame is not attached to a CheckpointResource. (" + this.getResource().getIdentifier() + ")");
        }
        String string = request.getQueryString();
        if (string != null) {
            if (string.equals("start")) {
                checkpointResource.activate();
            } else if (string.equals("stop")) {
                checkpointResource.stop();
            }
        }
        HtmlGenerator htmlGenerator = new HtmlGenerator("CheckpointResource");
        this.addStyleSheet(htmlGenerator);
        htmlGenerator.append("<h1>CheckpointResource status</h1>");
        htmlGenerator.append("<p>Checkpoint is currently ", checkpointResource.thread == null ? " stopped " : "running", ".");
        htmlGenerator.append("<hr>You can:<p><dl>");
        htmlGenerator.append("<dt><a href=\"", checkpointResource.getURLPath(), "?start\">start</a><dd>Start the checkpointer.");
        htmlGenerator.append("<dt><a href=\"", checkpointResource.getURLPath(), "?stop\">stop</a><dd>Stop the checkpointer.");
        htmlGenerator.append("</dl><hr>Last checkpoint at <strong>", checkpointResource.checkpoint == null ? "no checkpoint run yet" : checkpointResource.checkpoint.toString(), "</strong>.");
        Reply reply = this.createDefaultReply(request, 200);
        reply.setStream(htmlGenerator);
        return reply;
    }

    public void registerResource(FramedResource framedResource) {
        super.registerOtherResource(framedResource);
    }
}

