/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http.socket;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.ClientException;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.http.socket.SocketClientFactory;
import org.w3c.jigsaw.http.socket.SocketClientState;
import org.w3c.jigsaw.http.socket.SocketOutputBuffer;

public class SocketClient
extends Client
implements Runnable {
    private static final boolean trace = false;
    private SocketClientFactory pool = null;
    protected Socket socket = null;
    protected boolean alive = false;
    SocketClientState state = null;
    protected int bindcount = 0;
    protected Thread thread = null;
    protected SocketOutputBuffer bufout = null;
    protected boolean idle = false;

    SocketClient(httpd httpd2, SocketClientFactory socketClientFactory, SocketClientState socketClientState) {
        this.initialize(httpd2, socketClientState.id);
        this.socket = null;
        this.pool = socketClientFactory;
        this.state = socketClientState;
        this.alive = true;
    }

    protected synchronized void bind(Socket socket) {
        httpd httpd2 = this.getServer();
        this.socket = socket;
        try {
            socket.setSoTimeout(httpd2.getRequestTimeOut());
        }
        catch (SocketException socketException) {
            httpd2.errlog("Unable to set socket timeout!");
        }
        this.idle = false;
        ++this.bindcount;
        this.pool.run(this);
    }

    public final int getBindCount() {
        return this.bindcount;
    }

    public InetAddress getInetAddress() {
        return this.socket != null ? this.socket.getInetAddress() : null;
    }

    protected Thread getThread() {
        return this.thread;
    }

    protected boolean idleConnection() {
        this.idle = true;
        return this.pool.notifyIdle(this) ^ true;
    }

    public void join() {
        if (this.thread != null) {
            while (true) {
                try {
                    while (true) {
                        this.thread.join();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    protected synchronized void kill(boolean bl) {
        this.alive = false;
        this.interruptConnection(bl);
    }

    public void run() {
        this.thread = Thread.currentThread();
        try {
            block14: {
                try {
                    if (this.bufout == null) {
                        int n = this.getServer().getClientBufferSize() - 1;
                        this.bufout = new SocketOutputBuffer(this.socket.getOutputStream(), n);
                    } else {
                        this.bufout.reuse(this.socket.getOutputStream());
                    }
                    this.startConnection(new BufferedInputStream(this.socket.getInputStream()), new DataOutputStream(this.bufout));
                }
                catch (IOException iOException) {
                    if (this.debug) {
                        iOException.printStackTrace();
                    }
                }
                catch (ClientException clientException) {
                    if (this.debug) {
                        clientException.printStackTrace();
                    }
                    if (this.debug) {
                        if (clientException.ex != null) {
                            clientException.ex.printStackTrace();
                        } else {
                            clientException.printStackTrace();
                        }
                    }
                    if (!this.alive || this.idle) break block14;
                    this.error("caught ClientException: [" + clientException.getClass().getName() + "] " + clientException.getMessage());
                }
            }
            Object var2_4 = null;
            this.thread = null;
            if (!this.pool.clientConnectionFinished(this)) {
                this.pool.clientFinished(this);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.thread = null;
            if (!this.pool.clientConnectionFinished(this)) {
                this.pool.clientFinished(this);
            }
            throw throwable;
        }
    }

    protected void stopConnection() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
            this.socket = null;
        }
    }

    public String toString() {
        if (this.thread != null) {
            return "client-" + this.state.id + "(" + this.thread.getName() + ")";
        }
        return "client-" + this.state.id;
    }

    protected synchronized void unbind() {
        this.interruptConnection(true);
    }

    protected void usedConnection() {
        this.idle = false;
        this.pool.notifyUse(this);
    }
}

