/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.jigsaw.http.ControlResourceEnumeration;
import org.w3c.jigsaw.http.httpd;
import org.w3c.tools.resources.AbstractContainer;
import org.w3c.tools.resources.DummyResourceReference;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.ServerInterface;
import org.w3c.util.ObservableProperties;

public class ControlResource
extends AbstractContainer {
    protected httpd server = null;
    protected ResourceReference self = null;

    public ControlResource(httpd httpd2) {
        this.server = httpd2;
    }

    private String computeHelpUrl() {
        try {
            URL uRL = new URL(this.getServer().getDocumentationURL());
            URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "/Doc/Overview.html");
            return uRL2.toExternalForm();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public ResourceReference createDefaultResource(String string) {
        throw new RuntimeException("static container");
    }

    public void delete(String string) {
        throw new RuntimeException("static container");
    }

    public Enumeration enumerateResourceIdentifiers(boolean bl) {
        return new ControlResourceEnumeration();
    }

    public ServerInterface getServer() {
        return this.server;
    }

    public synchronized Object getValue(int n, Object object) {
        if (n == Resource.ATTR_HELP_URL && this.values[Resource.ATTR_HELP_URL] == null) {
            this.values[Resource.ATTR_HELP_URL] = this.computeHelpUrl();
        }
        return super.getValue(n, object);
    }

    public ResourceReference lookup(String string) {
        if (string.equalsIgnoreCase("checkpoint")) {
            this.server.startCheckpoint();
        } else if (string.equalsIgnoreCase("save")) {
            this.saveProperties();
            this.server.checkpoint();
        } else if (string.equalsIgnoreCase("restart")) {
            this.server.restart();
        } else if (string.equalsIgnoreCase("stop")) {
            this.server.shutdown();
        }
        if (this.self == null) {
            this.self = new DummyResourceReference(this);
        }
        return this.self;
    }

    public void registerResource(String string, Resource resource, Hashtable hashtable) {
        throw new RuntimeException("static container");
    }

    protected void saveProperties() {
        ObservableProperties observableProperties = this.server.getProperties();
        File file = new File(observableProperties.getString("org.w3c.jigsaw.propfile", null));
        if (file == null) {
            throw new RuntimeException("Unable to save properties: property org.w3c.jigsaw.propfile undefined.");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.server.getProperties().save(fileOutputStream, "Jigsaw written");
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        this.server.errlog("Properties " + file + " have been saved.");
    }
}

