/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.acl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Date;
import org.w3c.jigsaw.acl.AclFilter;
import org.w3c.jigsaw.acl.BasicAuthPrincipal;
import org.w3c.jigsaw.acl.DigestAuthPrincipal;
import org.w3c.jigsaw.acl.HTTPPrincipal;
import org.w3c.jigsaw.acl.InvalidAuthException;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.FramedResource;
import org.w3c.util.StringUtils;
import org.w3c.www.http.HttpChallenge;
import org.w3c.www.http.HttpFactory;

public class SecurityLevel {
    private int level = -1;
    private long prev_date = 0L;
    private String nonce = null;
    private String old_nonce = null;
    private AclFilter filter = null;
    private HttpChallenge challenge = null;

    private SecurityLevel(AclFilter aclFilter) {
        this.level = aclFilter.getSecurityLevel();
        this.filter = aclFilter;
        switch (this.level) {
            case 0: {
                this.challenge = HttpFactory.makeChallenge("Basic");
                this.challenge.setAuthParameter("realm", "");
                break;
            }
            default: {
                this.challenge = HttpFactory.makeChallenge("Digest");
                this.challenge.setAuthParameter("realm", "");
                this.challenge.setAuthParameter("domain", aclFilter.getResource().getURLPath());
                this.challenge.setAuthParameter("algorithm", aclFilter.getAlgorithm());
                this.updateNonce();
            }
        }
    }

    public HttpChallenge getChallenge(String string, Principal principal) {
        switch (this.level) {
            case 0: {
                this.challenge.setAuthParameter("realm", string);
                return this.challenge;
            }
        }
        if (principal instanceof DigestAuthPrincipal) {
            HttpChallenge httpChallenge;
            DigestAuthPrincipal digestAuthPrincipal = (DigestAuthPrincipal)principal;
            if (digestAuthPrincipal != null && digestAuthPrincipal.isStale()) {
                httpChallenge = this.challenge.getClone();
                if (httpChallenge != null) {
                    httpChallenge.setAuthParameter("stale", "true");
                } else {
                    httpChallenge = this.challenge;
                }
            } else {
                httpChallenge = this.challenge;
            }
            httpChallenge.setAuthParameter("realm", string);
            return httpChallenge;
        }
        this.challenge.setAuthParameter("realm", string);
        return this.challenge;
    }

    public Principal getPrincipal(Request request, String string) {
        switch (this.level) {
            case 0: {
                try {
                    return new BasicAuthPrincipal(request);
                }
                catch (InvalidAuthException invalidAuthException) {
                    return new HTTPPrincipal(request);
                }
            }
        }
        Date date = new Date();
        if ((date.getTime() - this.prev_date) / 1000L > (long)this.filter.getNonceTTL()) {
            this.prev_date = date.getTime();
            this.updateNonce();
        }
        try {
            return new DigestAuthPrincipal(request, this.nonce, this.old_nonce, string);
        }
        catch (InvalidAuthException invalidAuthException) {
            return new HTTPPrincipal(request);
        }
    }

    public static SecurityLevel getSecurityLevel(AclFilter aclFilter) {
        return new SecurityLevel(aclFilter);
    }

    private synchronized void updateNonce() {
        block5: {
            FramedResource framedResource = this.filter.getResource();
            if (!(framedResource instanceof HTTPFrame)) break block5;
            HTTPFrame hTTPFrame = (HTTPFrame)framedResource;
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(this.filter.getAlgorithm());
                messageDigest.update(new Date().toString().getBytes());
                try {
                    messageDigest.update(hTTPFrame.getETag().getTag().getBytes());
                }
                catch (Exception exception) {
                    messageDigest.update(hTTPFrame.getURLPath().getBytes());
                }
                byte[] byArray = messageDigest.digest();
                if (this.nonce != null) {
                    this.old_nonce = this.nonce;
                }
                this.nonce = StringUtils.toHexString(byArray);
                this.challenge.setAuthParameter("nonce", this.nonce);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
    }

    public void updateReply(Reply reply, Request request) {
        switch (this.level) {
            default: {
                DigestAuthPrincipal digestAuthPrincipal;
                if (!request.hasState("org.w3c.jigsaw.auth.AuthFilter.context") || !(digestAuthPrincipal = (DigestAuthPrincipal)request.getState("org.w3c.jigsaw.auth.AuthFilter.context")).isStale()) break;
                reply.addAuthenticationInfo("nextnonce", this.nonce);
            }
            case 0: 
        }
    }

    public void updateRequestStates(Request request, Principal principal) {
        switch (this.level) {
            case 0: {
                request.setState("org.w3c.jigsaw.auth.AuthFilter.user", principal.getName());
                request.setState("org.w3c.jigsaw.auth.AuthFilter.type", "Basic");
                break;
            }
            default: {
                request.setState("org.w3c.jigsaw.auth.AuthFilter.user", principal.getName());
                request.setState("org.w3c.jigsaw.auth.AuthFilter.type", "Digest");
                request.setState("org.w3c.jigsaw.auth.AuthFilter.context", principal);
            }
        }
    }
}

