/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadm.editors;

import java.awt.Dimension;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.EditorFeeder;
import org.w3c.jigadm.editors.StringArrayEditor;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.widgets.IPTextField;
import org.w3c.tools.widgets.TextEditable;

public class IPTemplateArrayEditor
extends StringArrayEditor {
    protected short[][] oldshortarray = null;

    protected Dimension getPopupSize() {
        return new Dimension(350, 250);
    }

    protected TextEditable getTextEditor() {
        return new IPTextField();
    }

    public Object getValue() {
        StringTokenizer stringTokenizer = null;
        String[] stringArray = this.comp.getSelectedItems();
        short[][] sArray = new short[stringArray.length][4];
        int n = 0;
        while (n < stringArray.length) {
            stringTokenizer = new StringTokenizer(stringArray[n], ".");
            int n2 = 0;
            while (n2 < 4 && stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.equals("*")) {
                    sArray[n][n2] = 256;
                } else {
                    try {
                        sArray[n][n2] = Short.parseShort(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        sArray[n][n2] = 0;
                    }
                }
                ++n2;
            }
            ++n;
        }
        return sArray;
    }

    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Attribute attribute, Object object, Properties properties) throws RemoteAccessException {
        EditorFeeder editorFeeder = null;
        String string = null;
        string = (String)((Hashtable)properties).get("feeder.class");
        if (string == null) {
            throw new RuntimeException("StringArrayEditor mis-configuration: feeder.class property undefined.");
        }
        try {
            Class<?> clazz = Class.forName(string);
            editorFeeder = (EditorFeeder)clazz.newInstance();
            editorFeeder.initialize(remoteResourceWrapper, properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("StringArrayEditor mis-configured:  unable to instantiate " + string + ".");
        }
        this.oldshortarray = (short[][])object;
        this.createComponent(editorFeeder, this.toStringArray(this.oldshortarray));
    }

    public void resetChanges() {
        this.hasChanged = false;
        this.setSelectedItems(this.oldshortarray);
    }

    protected void setSelectedItems(short[][] sArray) {
        this.comp.setSelectedItems(this.toStringArray(sArray));
    }

    public void setValue(Object object) {
        this.oldshortarray = (short[][])object;
        this.setSelectedItems(this.oldshortarray);
    }

    private String shortsToIPString(short s, short s2, short s3, short s4) {
        return String.valueOf(s == 256 ? "*" : String.valueOf(s)) + "." + (s2 == 256 ? "*" : String.valueOf(s2)) + "." + (s3 == 256 ? "*" : String.valueOf(s3)) + "." + (s4 == 256 ? "*" : String.valueOf(s4));
    }

    protected String[] toStringArray(short[][] sArray) {
        if (sArray == null) {
            return null;
        }
        String[] stringArray = new String[sArray.length];
        int n = 0;
        while (n < sArray.length) {
            stringArray[n] = this.shortsToIPString(sArray[n][0], sArray[n][1], sArray[n][2], sArray[n][3]);
            ++n;
        }
        return stringArray;
    }
}

