
// FrameArrayAttribute.java
// $Id: FrameArrayAttribute.java,v 1.2 1999/09/07 13:57:06 ylafon Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.tools.resources.upgrade ;

import java.io.* ;
import java.util.* ;

import org.w3c.util.*;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.UnknownFrame;

public class FrameArrayAttribute extends Attribute {

    public boolean checkValue(Object value) {
	return value instanceof ResourceFrame[];
    }

    public int getPickleLength(Object value) {
	throw new RuntimeException("unused for upgrade");
    }

    public void pickle(DataOutputStream out, Object obj)
	throws IOException
    {
	throw new RuntimeException("unused for upgrade");
    }

    public Object unpickle(DataInputStream in) 
	throws IOException
    {
	int cnt = in.readInt();
	if ( cnt == 0 )
	    return null;
	ResourceFrame frames[] = new ResourceFrame[cnt];
 	for (int i = 0 ; i < cnt ; i++) {
	    try {
		frames[i] = (ResourceFrame) Upgrader.readResource(in);
	    } catch (UpgradeException ex) {
		frames[i] = new UnknownFrame();
	    }
	}
	return frames;
    }

    public FrameArrayAttribute(String name, ResourceFrame def[], int flags) {
	super(name, def, flags);
    }

}
