// XMLWriter.java
// $Id: XMLWriter.java,v 1.2 1999/09/07 13:28:53 ylafon Exp $
// (c) COPYRIGHT MIT, INRIA and Keio, 1999.
// Please first read the full copyright statement in file COPYRIGHT.html
package org.w3c.tools.resources.serialization.xml;

import java.io.Writer;
import java.io.Reader;
import java.io.IOException;

import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.ArrayAttribute;
import org.w3c.tools.resources.FrameArrayAttribute;

/**
 * @version $Revision: 1.2 $
 * @author  Benot Mah (bmahe@w3.org)
 */
public class XMLWriter implements JXML {
    
    protected Writer writer = null;
    protected int    level  = 0;

    protected void indent()
	throws IOException
    {
	for (int i = 0 ; i < level ; i++)
	    writer.write(" ");
    }

    protected void startDocument() 
	throws IOException
    {
	writer.write("<?xml version='1.0' encoding='UTF-8'?>\n");
	//writer.write("<!DOCTYPE jxml SYSTEM \""+dtd+"\">\n");
	writer.write("<"+JXML_TAG+" version=\""+version+"\" xmlns=\""+
		     ns+"\">\n");
    }

    protected void closeDocument() 
	throws IOException
    {
	writer.write("</"+JXML_TAG+">\n");
	writer.close();
    }

    protected void closeResource()
	throws IOException
    {
	writer.write("</"+RESOURCE_TAG+">\n");
    }

    public XMLWriter(Writer writer) {
	this.writer = writer;
    }

}
