// Serializer.java
// $Id: Serializer.java,v 1.2 1999/09/07 13:28:53 ylafon Exp $
// (c) COPYRIGHT MIT, INRIA and Keio, 1999.
// Please first read the full copyright statement in file COPYRIGHT.html
package org.w3c.tools.resources.serialization; 

import java.io.Reader;
import java.io.Writer;
import java.io.IOException;

import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.AttributeHolder;

/**
 * @version $Revision: 1.2 $
 * @author  Benot Mah (bmahe@w3.org)
 */
public abstract interface Serializer {
    
    /**
     * Write the resource descriptions using the given writer.
     * @param descr the resource descriptions array
     * @param writer the writer
     */
    public void writeResourceDescriptions(ResourceDescription descr[],
					  Writer writer)
	throws IOException, SerializationException;

    /**
     * Write the resource descriptions using the given writer.
     * @param descr the resource descriptions array
     * @param writer the writer
     */
    public void writeResourceDescriptions(Resource descr[],
					  Writer writer)
	throws IOException, SerializationException;

    /**
     * Write the resources using the given writer.
     * @param descr the resource array
     * @param writer the writer
     */
    public void writeResources(AttributeHolder holders[], Writer writer)
	throws IOException, SerializationException;

    /**
     * Read the resource descriptions using the given reader.
     * @param writer the reader
     * @return a ResourceDescription array
     */
    public ResourceDescription[] readResourceDescriptions(Reader reader) 
	throws IOException, SerializationException;

    /**
     * Read the resources using the given reader.
     * @param writer the reader
     * @return a Resources array
     */
    public Resource[] readResources(Reader reader)
	throws IOException, SerializationException;

    /**
     * Read the attribute holders using the given reader.
     * @param writer the reader
     * @return a Resources array
     */
    public AttributeHolder[] readAttributeHolders(Reader reader) 
	throws IOException, SerializationException;

}
