/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.icp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.URL;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.PropRequestFilterException;
import org.w3c.www.protocol.http.cache.CacheFilter;
import org.w3c.www.protocol.http.icp.ICP;
import org.w3c.www.protocol.http.icp.ICPFilter;
import org.w3c.www.protocol.http.icp.ICPMessage;
import org.w3c.www.protocol.http.icp.ICPProtocolException;
import org.w3c.www.protocol.http.icp.ICPQuery;
import org.w3c.www.protocol.http.icp.ICPReply;
import org.w3c.www.protocol.http.icp.ICPSender;
import org.w3c.www.protocol.http.icp.ICPWaiter;

class ICPReceiver
extends Thread
implements ICP {
    private static final boolean debug = false;
    public static final int DEFAULT_QUEUE_SIZE = 4;
    public static final int DEFAULT_PACKET_SIZE = 512;
    protected int port = -1;
    DatagramSocket socket = null;
    protected int nextid = 1;
    CacheFilter cache = null;
    ICPWaiter[] queue = null;
    protected ICPFilter filter = null;

    ICPReceiver(HttpManager httpManager, ICPFilter iCPFilter, int n) throws SocketException, PropRequestFilterException {
        this.setName("ICP-Receiver");
        this.setDaemon(true);
        this.port = n;
        this.filter = iCPFilter;
        this.socket = new DatagramSocket(n);
        try {
            Class<?> clazz = Class.forName("org.w3c.www.protocol.http.cache.CacheFilter");
            this.cache = (CacheFilter)httpManager.getGlobalFilter(clazz);
        }
        catch (Exception exception) {}
        if (this.cache == null) {
            throw new PropRequestFilterException("no cache filter.");
        }
        this.start();
    }

    protected synchronized void addReplyWaiter(ICPWaiter iCPWaiter) {
        if (this.queue != null) {
            int n = 0;
            while (n < this.queue.length) {
                if (this.queue[n] == null) {
                    this.queue[n] = iCPWaiter;
                    return;
                }
                ++n;
            }
            ICPWaiter[] iCPWaiterArray = new ICPWaiter[this.queue.length << 1];
            System.arraycopy(this.queue, 0, iCPWaiterArray, 0, this.queue.length);
            iCPWaiterArray[this.queue.length] = iCPWaiter;
            this.queue = iCPWaiterArray;
            return;
        }
        this.queue = new ICPWaiter[4];
        this.queue[0] = iCPWaiter;
    }

    protected ICPQuery createQuery(URL uRL) {
        int n = -1;
        ICPReceiver iCPReceiver = this;
        synchronized (iCPReceiver) {
            n = this.nextid++;
        }
        return new ICPQuery(n, uRL);
    }

    protected DatagramSocket getSocket() {
        return this.socket;
    }

    protected synchronized void handleQuery(ICPQuery iCPQuery) throws ICPProtocolException {
        boolean bl = this.cache.hasResource(iCPQuery.getURL().toExternalForm());
        ICPReply iCPReply = new ICPReply(iCPQuery.getIdentifier(), bl ? 2 : 3);
        ICPSender iCPSender = this.filter.getSender(iCPQuery.getSenderAddress(), iCPQuery.getSenderPort());
        if (iCPSender != null) {
            iCPSender.send(iCPReply);
        }
    }

    protected synchronized void handleReply(ICPReply iCPReply) throws ICPProtocolException {
        int n = iCPReply.getIdentifier();
        int n2 = 0;
        while (n2 < this.queue.length) {
            if (this.queue[n2] != null && this.queue[n2].getIdentifier() == n) {
                this.queue[n2].notifyReply(iCPReply);
                return;
            }
            ++n2;
        }
    }

    protected synchronized void removeReplyWaiter(ICPWaiter iCPWaiter) {
        if (this.queue != null) {
            int n = 0;
            while (n < this.queue.length) {
                if (this.queue[n] == iCPWaiter) {
                    this.queue[n] = null;
                    return;
                }
                ++n;
            }
        }
    }

    public void run() {
        byte[] byArray = new byte[512];
        while (true) {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            try {
                this.socket.receive(datagramPacket);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            try {
                ICPMessage iCPMessage = ICPMessage.parse(datagramPacket);
                if (iCPMessage instanceof ICPQuery) {
                    this.handleQuery((ICPQuery)iCPMessage);
                    continue;
                }
                this.handleReply((ICPReply)iCPMessage);
                continue;
            }
            catch (ICPProtocolException iCPProtocolException) {
                iCPProtocolException.printStackTrace();
                continue;
            }
            break;
        }
    }
}

