/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache;

import java.io.IOException;
import java.net.URL;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpEntityTag;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.cache.CacheFilter;
import org.w3c.www.protocol.http.cache.CachedResource;
import org.w3c.www.protocol.http.cache.CachedResourceFactory;

public class VaryResource
extends CachedResource {
    protected static int ATTR_VARIANT_LOCATIONS = -1;
    protected static int ATTR_VARY = -1;
    protected CachedResource[] variants = null;

    static {
        Class<?> clazz = null;
        StringArrayAttribute stringArrayAttribute = null;
        try {
            clazz = Class.forName("org.w3c.www.protocol.http.cache.VaryResource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        stringArrayAttribute = new StringArrayAttribute("variant-locations", null, 1);
        ATTR_VARIANT_LOCATIONS = AttributeRegistry.registerAttribute(clazz, stringArrayAttribute);
        stringArrayAttribute = new StringArrayAttribute("vary", null, 1);
        ATTR_VARY = AttributeRegistry.registerAttribute(clazz, stringArrayAttribute);
    }

    public VaryResource() {
    }

    VaryResource(CacheFilter cacheFilter, Request request, Reply reply) throws IOException {
        super.initialize(cacheFilter, request, reply);
    }

    public synchronized void addVariant(CachedResource cachedResource) {
        String string = cachedResource.getIdentifier();
        String[] stringArray = this.getVariantLocations();
        if (stringArray == null) {
            stringArray = new String[]{string};
        } else {
            int n = 0;
            while (n < stringArray.length) {
                if (string.equalsIgnoreCase(stringArray[n])) {
                    return;
                }
                ++n;
            }
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string;
            stringArray = stringArray2;
        }
        this.variants = null;
        this.etags = null;
        this.setValue(ATTR_VARIANT_LOCATIONS, stringArray);
    }

    public synchronized void delete() {
        CachedResource[] cachedResourceArray = this.getVariants();
        if (cachedResourceArray != null) {
            int n = 0;
            while (n < cachedResourceArray.length) {
                cachedResourceArray[n].delete();
                ++n;
            }
        }
        super.delete();
    }

    public synchronized CachedResource getVariant(HttpEntityTag httpEntityTag) {
        CachedResource[] cachedResourceArray = this.getVariants();
        if (cachedResourceArray != null) {
            int n = 0;
            while (n < cachedResourceArray.length) {
                if (httpEntityTag.getTag().equals(cachedResourceArray[n].getHETag().getTag())) {
                    return cachedResourceArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public synchronized String[] getVariantLocations() {
        return (String[])((Resource)((Object)this)).getValue(ATTR_VARIANT_LOCATIONS, null);
    }

    public synchronized CachedResource[] getVariants() {
        if (this.variants == null) {
            String[] stringArray = this.getVariantLocations();
            if (stringArray == null) {
                return null;
            }
            this.variants = new CachedResource[stringArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray.length) {
                try {
                    this.variants[n2] = this.filter.loadResource(stringArray[n2]);
                }
                catch (InvalidResourceException invalidResourceException) {
                    this.filter.removeResource(stringArray[n2]);
                }
                if (this.variants[n2] != null) {
                    ++n;
                }
                ++n2;
            }
            if (n != stringArray.length) {
                String[] stringArray2 = new String[n];
                CachedResource[] cachedResourceArray = new CachedResource[n];
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.variants.length) {
                    if (this.variants[n4] != null) {
                        stringArray2[n3] = stringArray[n4];
                        cachedResourceArray[n3] = this.variants[n4];
                        ++n3;
                    }
                    ++n4;
                }
                this.variants = cachedResourceArray;
                this.setValue(ATTR_VARIANT_LOCATIONS, stringArray2);
            }
        }
        return this.variants;
    }

    public synchronized HttpEntityTag[] getVariantsETag() {
        CachedResource[] cachedResourceArray;
        if (this.etags == null && (cachedResourceArray = this.getVariants()) != null) {
            this.etags = new HttpEntityTag[cachedResourceArray.length];
            int n = 0;
            while (n < cachedResourceArray.length) {
                String string = cachedResourceArray[n].getETag();
                if (string != null) {
                    this.etags[n] = HttpFactory.parseETag(string);
                }
                ++n;
            }
        }
        return this.etags;
    }

    public String[] getVary() {
        return (String[])((Resource)((Object)this)).getValue(ATTR_VARY, null);
    }

    public boolean isValid(Request request) {
        this.setRequestValidation(request);
        return false;
    }

    public void setRequestValidation(Request request) {
        request.setState("org.w3c.www.protocol.http.cache.resource", (Object)this);
        request.setIfNoneMatch(this.getVariantsETag());
    }

    public Reply updateVariant(Request request, Reply reply) throws IOException {
        CachedResource cachedResource;
        String string = reply.getContentLocation();
        if (string == null) {
            return reply;
        }
        URL uRL = null;
        try {
            uRL = new URL(request.getURL(), string);
        }
        catch (Exception exception) {
            return reply;
        }
        if (!reply.hasHeader(HttpEntityMessage.H_ETAG)) {
            this.delete();
            return null;
        }
        String[] stringArray = reply.getVary();
        if (stringArray != null) {
            cachedResource = this.getVary();
            if (cachedResource != null) {
                int n = 0;
                int n2 = 0;
                while (n2 < ((String[])cachedResource).length) {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (cachedResource[n2].equalsIgnoreCase(stringArray[n3])) {
                            ++n;
                            break;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                if (n != stringArray.length) {
                    this.delete();
                    return reply;
                }
            } else {
                this.setValue(ATTR_VARY, stringArray);
            }
        }
        reply.setVary(null);
        request.setURL(uRL);
        cachedResource = null;
        cachedResource = CachedResourceFactory.createResource(this.filter, request, reply);
        reply.setVary(stringArray);
        this.filter.store.addResource((Resource)cachedResource);
        this.addVariant(cachedResource);
        return reply;
    }

    public synchronized Reply validate(Request request, Reply reply) throws IOException {
        CachedResource cachedResource;
        if (reply.getStatus() != 304) {
            return this.updateVariant(request, reply);
        }
        HttpEntityTag httpEntityTag = reply.getETag();
        if (httpEntityTag != null && (cachedResource = this.getVariant(httpEntityTag)) != null) {
            return cachedResource.validate(request, reply);
        }
        return null;
    }
}

