/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache;

import java.util.Enumeration;
import org.w3c.tools.jdbm.jdbmResourceStore;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.Resource;
import org.w3c.www.protocol.http.cache.CacheFilter;
import org.w3c.www.protocol.http.cache.CacheState;
import org.w3c.www.protocol.http.cache.CachedResource;

public class CacheSweeper
extends Thread {
    private static final boolean debug = false;
    private static final int WAIT_MIN = 5000;
    private static final int WAIT_MAX = 60000;
    CacheFilter filter = null;
    CacheState state = null;
    boolean signal = false;
    int wait_time = 5000;
    int stdgensize = -1;

    public CacheSweeper(CacheFilter cacheFilter) {
        this.filter = cacheFilter;
        this.state = cacheFilter.state;
        this.stdgensize = cacheFilter.getCacheSize() / 10;
        this.setDaemon(true);
        this.setPriority(3);
        this.setName("CacheSweeper");
    }

    public boolean checkInvalid(CachedResource cachedResource, int n) {
        return cachedResource.getGeneration() < n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void garbageCollect() {
        jdbmResourceStore jdbmResourceStore2 = this.filter.store;
        int n = this.filter.getCacheSize() / 4;
        int n2 = this.state.computeCollectGeneration(n);
        int n3 = 0;
        while (true) {
            Enumeration enumeration = jdbmResourceStore2.enumerateResourceIdentifiers();
            try {
                while (enumeration.hasMoreElements()) {
                    CachedResource cachedResource;
                    String string = (String)enumeration.nextElement();
                    Resource resource = null;
                    try {
                        resource = jdbmResourceStore2.loadResource(string, this.filter.defdefs);
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        jdbmResourceStore2.removeResource(string);
                        continue;
                    }
                    if (!(resource instanceof CachedResource) || (cachedResource = (CachedResource)resource) == null || !this.checkInvalid(cachedResource, n2)) continue;
                    n3 += cachedResource.getContentLength();
                    cachedResource.delete();
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        if (this.filter.debug) {
            System.out.println("# Sweeper garbage collection results:");
            System.out.println("# Tried to collect " + n + " bytes.");
            System.out.println("# Target generation number was " + n2);
            System.out.println("# Collected " + n3 + " bytes.");
            System.out.println("# Current cache state:");
            this.state.print(System.out);
        }
        this.filter.sync();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.waitSignal();
                    this.garbageCollect();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public synchronized void signal() {
        this.signal = true;
        this.notifyAll();
    }

    protected void updateGeneration(CachedResource cachedResource, int n, int n2) {
        cachedResource.setGeneration(n2);
    }

    public synchronized void waitSignal() {
        long l = 0L;
        this.signal = false;
        this.wait_time = 5000;
        while (!this.signal) {
            try {
                this.wait(this.wait_time);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            if (this.signal) break;
            int n = this.state.getCurrentGenerationSize();
            if (n >= this.stdgensize) {
                int n2 = this.state.setNextGeneration();
                l = 0L;
                this.filter.sync();
            }
            if (n > 0) {
                this.wait_time = 5000 * (this.stdgensize / n);
                this.wait_time = Math.max(5000, Math.min(this.wait_time, 60000));
            } else {
                this.wait_time = 60000;
            }
            if ((l += (long)this.wait_time) < 60000L) continue;
            l = 0L;
            this.filter.sync();
            if (!this.filter.debug) continue;
            this.state.print(System.out);
        }
        this.signal = false;
    }
}

