/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache;

import java.io.File;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.tools.jdbm.jdbmResourceStore;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.www.protocol.http.cache.CacheFilter;
import org.w3c.www.protocol.http.cache.CachedResource;
import org.w3c.www.protocol.http.cache.Subdirectory;

public class CacheState {
    protected static final int GENERATIONS_HISTORY_SIZE = 10;
    protected int dirid = 0;
    protected int byteused = 0;
    protected int generation = 0;
    protected int[] gensizes = null;
    protected int basegen = 0;
    protected int curgen = 0;
    protected CacheFilter filter = null;
    protected Subdirectory[] subdirs = null;

    public CacheState(CacheFilter cacheFilter, jdbmResourceStore jdbmResourceStore2) {
        int n;
        Enumeration enumeration;
        Hashtable<File, Boolean> hashtable = new Hashtable<File, Boolean>(1023);
        this.subdirs = new Subdirectory[128];
        int n2 = 0;
        while (n2 < this.subdirs.length) {
            enumeration = cacheFilter.getSubdirectory(n2);
            this.subdirs[n2] = new Subdirectory((File)((Object)enumeration), 0);
            String[] stringArray = ((File)((Object)enumeration)).list();
            if (stringArray != null) {
                n = 0;
                while (n < stringArray.length) {
                    hashtable.put(new File((File)((Object)enumeration), stringArray[n]), Boolean.TRUE);
                    ++n;
                }
            }
            ++n2;
        }
        enumeration = jdbmResourceStore2.enumerateResourceIdentifiers();
        int n3 = 0;
        n = 0;
        int n4 = 0;
        int[] nArray = new int[10];
        while (enumeration.hasMoreElements()) {
            int n5;
            int n6;
            String string = (String)enumeration.nextElement();
            CachedResource cachedResource = null;
            try {
                cachedResource = (CachedResource)jdbmResourceStore2.loadResource(string, cacheFilter.defdefs);
            }
            catch (InvalidResourceException invalidResourceException) {
                cachedResource = null;
            }
            if (cachedResource == null) continue;
            File file = cachedResource.getFile();
            try {
                n6 = Integer.parseInt(file.getName());
                n5 = Integer.parseInt(new File(file.getParent()).getName());
                this.subdirs[n5].registerId(n6);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            hashtable.remove(cachedResource.getFile());
            n6 = cachedResource.getGeneration();
            n5 = cachedResource.getContentLength();
            if (n6 < n) {
                nArray[0] = nArray[0] + n5;
            } else if (n6 >= n3) {
                if (n6 - n < nArray.length) {
                    n3 = n6;
                } else {
                    int n7 = 1 + n6 - (n + nArray.length);
                    int n8 = 0;
                    n += n7;
                    int n9 = 0;
                    while (n9 < Math.min(n7, nArray.length)) {
                        n8 += nArray[n9];
                        ++n9;
                    }
                    if (n7 < nArray.length) {
                        System.arraycopy(nArray, n7, nArray, 0, nArray.length - n7);
                        int n10 = nArray.length - n7;
                        while (n10 < nArray.length) {
                            nArray[n10] = 0;
                            ++n10;
                        }
                    }
                    nArray[0] = nArray[0] + n8;
                }
                int n11 = n6 - n;
                nArray[n11] = nArray[n11] + n5;
            } else {
                int n12 = n6 - n;
                nArray[n12] = nArray[n12] + n5;
            }
            n4 += n5;
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ((File)enumeration.nextElement()).delete();
        }
        this.filter = cacheFilter;
        this.basegen = n;
        this.curgen = n3;
        this.gensizes = nArray;
        this.byteused = n4;
        this.dirid = (int)(Math.random() * 128.0);
    }

    protected synchronized int computeCollectGeneration(int n) {
        int n2;
        int[] nArray = this.getGenerationsSize();
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            n2 = nArray[n4];
            if (n2 > 0 && (n3 += n2) >= n) break;
            ++n4;
        }
        n2 = this.getBaseGeneration() + n4 + 1;
        return n2;
    }

    public final synchronized int getBaseGeneration() {
        return this.basegen;
    }

    public final synchronized int getCacheUsed() {
        return this.byteused;
    }

    protected synchronized int getCurrentGenerationSize() {
        int[] nArray = this.getGenerationsSize();
        int n = this.getGeneration();
        int n2 = this.getBaseGeneration();
        return nArray[n - n2];
    }

    public final synchronized int getGeneration() {
        return this.curgen;
    }

    public final synchronized int[] getGenerationsSize() {
        return this.gensizes;
    }

    protected File getNextFile() {
        CacheState cacheState = this;
        synchronized (cacheState) {
            this.dirid = (this.dirid + 1) % 128;
        }
        return this.subdirs[this.dirid].nextFile();
    }

    public void print(PrintStream printStream) {
        int n = this.getGeneration();
        int n2 = this.getBaseGeneration();
        printStream.println("# Number of bytes comsumed: " + this.getCacheUsed());
        printStream.println("# Current generation: " + n);
        printStream.println("# Generation base: " + n2);
        int[] nArray = this.getGenerationsSize();
        int n3 = 0;
        while (n3 < nArray.length) {
            printStream.println("#\tgeneration[" + (n2 + n3) + "]=" + nArray[n3] + " bytes.");
            ++n3;
        }
    }

    public final synchronized void setBaseGeneration(int n) {
        this.basegen = n;
    }

    public final synchronized void setGeneration(int n) {
        this.curgen = n;
    }

    public final synchronized void setGenerationsSize(int[] nArray) {
        this.gensizes = nArray;
    }

    public synchronized int setNextGeneration() {
        int n = this.getGeneration() + 1;
        this.setGeneration(n);
        int[] nArray = this.getGenerationsSize();
        int n2 = nArray.length;
        if (n >= n2) {
            this.setBaseGeneration(n - n2 + 1);
            System.arraycopy(nArray, 1, nArray, 0, n2 - 1);
            nArray[n2 - 1] = 0;
            this.setGenerationsSize(nArray);
        }
        return n;
    }

    public synchronized int updateCacheSpaceCounter(int n) {
        this.byteused += n;
        return this.byteused;
    }

    protected synchronized void updateGenerationSize(int n, int n2) {
        int[] nArray = this.getGenerationsSize();
        int n3 = this.getBaseGeneration();
        int n4 = -1;
        n4 = n - n3;
        if (n4 >= 0) {
            int n5 = n4;
            nArray[n5] = nArray[n5] + n2;
        }
    }
}

