/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.w3c.www.http.HeaderDescription;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.mime.MimeType;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    protected Request request = null;
    protected Reply reply = null;
    protected ByteArrayOutputStream output = null;

    HttpURLConnection(URL uRL) {
        super(uRL);
    }

    protected final void checkReply() {
        block3: {
            block2: {
                if (this.reply != null || !this.connected) break block2;
                this.error("Was connected but didn't get any reply !");
                break block3;
            }
            if (this.connected) break block3;
            try {
                this.connect();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.error("Error while silently connecting.");
            }
        }
    }

    protected final synchronized void checkRequest() {
        if (this.request == null) {
            this.request = HttpManager.getManager().createRequest();
            this.request.setMethod(this.method);
            if (this.ifModifiedSince > 0L) {
                this.request.setIfModifiedSince(this.ifModifiedSince * 1000L);
            }
            if (!this.useCaches) {
                this.request.addPragma("no-cache");
                this.request.setNoCache();
            }
            this.request.setURL(this.url);
        }
    }

    public void connect() throws IOException {
        Serializable serializable;
        Object object;
        this.debug("connect");
        if (this.connected) {
            return;
        }
        this.checkRequest();
        if (this.doOutput) {
            byte[] byArray = this.output.toByteArray();
            object = new ByteArrayInputStream(byArray);
            this.request.setOutputStream((InputStream)object);
            if (!this.request.hasHeader(HttpEntityMessage.H_CONTENT_LENGTH)) {
                this.request.setContentLength(byArray.length);
            }
            if (!this.request.hasHeader(HttpEntityMessage.H_CONTENT_TYPE)) {
                serializable = this.request.getMethod().equals("POST") ? MimeType.APPLICATION_X_WWW_FORM_URLENCODED : MimeType.TEXT_PLAIN;
                this.request.setContentType((MimeType)serializable);
            }
        }
        try {
            int n = 0;
            while (n < 5) {
                if (n == 1) {
                    this.request.setOutputStream(null);
                    this.request.setContentLength(-1);
                    this.request.setMethod("GET");
                }
                this.reply = this.request.getManager().runRequest(this.request);
                if (this.reply.getStatus() / 100 != 3 || (object = this.reply.getLocation()) == null) break;
                this.reply.getInputStream().close();
                serializable = this.request.getURL();
                try {
                    this.url = new URL((URL)serializable, (String)object);
                    this.request.setURL(this.url);
                }
                catch (MalformedURLException malformedURLException) {
                    break;
                }
                if (java.net.HttpURLConnection.getFollowRedirects()) {
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (HttpException httpException) {
            httpException.printStackTrace();
            throw new IOException(httpException.getMessage());
        }
        this.connected = true;
    }

    protected final void debug(String string) {
    }

    public synchronized void disconnect() {
        if (this.request != null) {
            this.request.interruptRequest();
        }
    }

    protected void error(String string) {
        this.debug("ERROR \"" + string + "\"");
        throw new RuntimeException(string);
    }

    public int getContentLength() {
        this.debug("getContentLength");
        this.checkReply();
        return this.reply.getContentLength();
    }

    public String getContentType() {
        this.debug("getContentType");
        this.checkReply();
        return this.reply.getContentType().toString();
    }

    public long getDate() {
        this.debug("getDate");
        this.checkReply();
        return this.reply.getDate();
    }

    public static String getDefaultRequestProperty(String string) {
        return HttpManager.getManager().getGlobalHeader(string);
    }

    public long getExpiration() {
        this.debug("getExpiration");
        this.checkReply();
        return this.reply.getExpires();
    }

    public String getHeaderField(int n) {
        String string = this.getHeaderFieldKey(n);
        if (string != null) {
            return this.reply.getValue(string);
        }
        return null;
    }

    public String getHeaderField(String string) {
        this.debug("getHeaderField");
        this.checkReply();
        return this.reply.getValue(string);
    }

    public String getHeaderFieldKey(int n) {
        Enumeration enumeration = this.reply.enumerateHeaderDescriptions(true);
        HeaderDescription headerDescription = null;
        if (--n >= 0) {
            if (enumeration.hasMoreElements()) {
                headerDescription = (HeaderDescription)enumeration.nextElement();
            }
            return null;
        }
        if (headerDescription != null) {
            return headerDescription.getName();
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        this.debug("getInputStream");
        this.checkReply();
        return this.reply.getInputStream();
    }

    public long getLastModified() {
        this.debug("getLastModified");
        this.checkReply();
        return this.reply.getLastModified();
    }

    public OutputStream getOutputStream() throws IOException {
        this.debug("getOutputStream");
        if (!this.connected && !this.doOutput) {
            this.setDoOutput(true);
        } else if (this.connected) {
            this.error("Already connected, too late for getOutputStream.");
        }
        this.output = new ByteArrayOutputStream();
        return this.output;
    }

    public String getRequestProperty(String string) {
        this.checkRequest();
        return this.request.getValue(string);
    }

    public int getResponseCode() throws IOException {
        this.debug("getResponseCode");
        this.checkReply();
        return this.reply.getStatus();
    }

    public void setDoOutput(boolean bl) {
        this.debug("DoOutput !!");
        super.setDoOutput(bl);
        this.checkRequest();
        if (this.request.getContentType() == null) {
            this.request.setContentType(MimeType.APPLICATION_X_WWW_FORM_URLENCODED);
        }
    }

    public static void setGlobalRequestProperty(String string, String string2) {
        HttpManager.getManager().setGlobalHeader(string, string2);
    }

    public void setRequestProperty(String string, String string2) {
        this.checkRequest();
        this.request.setValue(string, string2);
    }

    public boolean usingProxy() {
        return HttpManager.getManager().usingProxy();
    }
}

