/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import java.util.Vector;
import org.w3c.www.protocol.http.HttpConnection;
import org.w3c.www.protocol.http.HttpServer;

class HttpServerState {
    HttpServer server = null;
    Vector conns = null;
    private static final boolean debug = true;

    HttpServerState(HttpServer httpServer) {
        this.server = httpServer;
    }

    void deleteConnection(HttpConnection httpConnection) {
        if (this.conns != null) {
            this.conns.removeElement(httpConnection);
        }
    }

    synchronized HttpConnection getConnection() {
        if (this.conns != null && this.conns.size() > 0) {
            HttpConnection httpConnection = (HttpConnection)this.conns.elementAt(0);
            this.conns.removeElementAt(0);
            httpConnection.cached = true;
            return httpConnection;
        }
        return null;
    }

    final HttpServer getServer() {
        return this.server;
    }

    synchronized boolean hasConnection() {
        return this.conns != null && this.conns.size() > 0;
    }

    synchronized boolean notEnoughConnections() {
        return this.conns == null || this.conns.size() == 1;
    }

    void registerConnection(HttpConnection httpConnection) {
        if (this.conns == null) {
            this.conns = new Vector(4);
        }
        this.conns.addElement(httpConnection);
    }

    public String toString() {
        String string = "";
        if (this.conns == null) {
            string = "null";
        } else if (this.conns.size() == 0) {
            string = "empty";
        } else {
            int n = 0;
            while (n < this.conns.size()) {
                string = String.valueOf(string) + "[" + ((HttpConnection)this.conns.elementAt(n)).toString() + "]";
                ++n;
            }
        }
        return string;
    }

    void unregisterConnection(HttpConnection httpConnection) {
        if (this.conns != null) {
            this.conns.removeElement(httpConnection);
        }
    }
}

