/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.w3c.www.mime.MimeParser;
import org.w3c.www.mime.MimeParserException;
import org.w3c.www.protocol.http.ConnectedEvent;
import org.w3c.www.protocol.http.ContinueEvent;
import org.w3c.www.protocol.http.HttpBasicConnection;
import org.w3c.www.protocol.http.HttpConnection;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.HttpServer;
import org.w3c.www.protocol.http.HttpServerState;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.RequestEvent;
import org.w3c.www.protocol.http.RequestObserver;

public class HttpBasicServer
extends HttpServer {
    private static final String STATE_CONNECTION = "org.w3c.www.protocol.http.HttpBasicServer.connection";
    private static final String PROTOCOL = "http";
    private static final boolean debug = false;
    protected static final int RQ_HTTP11 = 1;
    protected static final int RQ_HTTP11_TS = 2;
    protected static final int RQ_HTTP10 = 3;
    protected static final int RQ_HTTP10_KA = 4;
    protected static final int RQ_UNKNOWN = 5;
    protected HttpManager manager = null;
    protected String host = null;
    protected int port = -1;
    protected int timeout = 300000;
    boolean contacted = false;
    short major = (short)-1;
    short minor = (short)-1;
    boolean keepalive = false;
    InetAddress[] addrs = null;
    int addrptr = 0;
    protected int connid = 0;

    HttpBasicServer() {
    }

    protected synchronized HttpBasicConnection allocateConnection() throws IOException {
        HttpBasicConnection httpBasicConnection = null;
        int n = 0;
        while (n < this.addrs.length) {
            InetAddress inetAddress = null;
            int n2 = this.addrptr;
            while ((inetAddress = this.addrs[n2]) == null && (n2 = (n2 + 1) % this.addrs.length) != this.addrptr) {
            }
            this.addrptr = (this.addrptr + 1) % this.addrs.length;
            try {
                httpBasicConnection = new HttpBasicConnection(this, this.connid++, inetAddress, this.port, this.timeout, this.manager.getReplyFactory());
                break;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                ++n;
            }
        }
        if (httpBasicConnection == null) {
            throw new IOException("Unable to connect to " + this.host);
        }
        this.manager.notifyConnection(httpBasicConnection);
        return httpBasicConnection;
    }

    public void deleteConnection(HttpConnection httpConnection) {
        this.manager.deleteConnection(httpConnection);
    }

    protected Reply doRequest(HttpBasicConnection httpBasicConnection, Request request) throws IOException, MimeParserException {
        if (request.isInterrupted()) {
            throw new IOException("Interrupted Request");
        }
        request.setState(STATE_CONNECTION, httpBasicConnection);
        switch (this.getRequestMode(request)) {
            case 1: {
                return this.http11_run(httpBasicConnection, request);
            }
            case 2: {
                return this.http11_ts_run(httpBasicConnection, request);
            }
            case 4: {
                return this.http10_ka_run(httpBasicConnection, request);
            }
            case 3: {
                return this.http10_run(httpBasicConnection, request);
            }
            case 5: {
                return this.http_unknown(httpBasicConnection, request);
            }
        }
        throw new RuntimeException("Implementation bug.");
    }

    protected HttpBasicConnection getConnection() throws IOException {
        while (true) {
            HttpBasicConnection httpBasicConnection = null;
            while ((httpBasicConnection = (HttpBasicConnection)this.manager.getConnection(this)) != null) {
                try {
                    httpBasicConnection.input.available();
                }
                catch (IOException iOException) {
                    break;
                }
                if (!httpBasicConnection.markUsed()) continue;
                return httpBasicConnection;
            }
            if (this.manager.negotiateConnection(this)) {
                httpBasicConnection = this.allocateConnection();
                if (httpBasicConnection.markUsed()) {
                    return httpBasicConnection;
                }
                return null;
            }
            try {
                this.manager.waitForConnection(this);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public short getMajorVersion() {
        return this.major;
    }

    public short getMinorVersion() {
        return this.minor;
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    protected int getRequestMode(Request request) {
        if (!this.contacted || this.major < 1) {
            return 5;
        }
        if (this.minor < 1) {
            return this.keepalive ? 4 : 3;
        }
        return this.isTwoStage_11(request) ? 2 : 1;
    }

    protected Reply http10_ka_run(HttpBasicConnection httpBasicConnection, Request request) throws IOException, MimeParserException {
        RequestObserver requestObserver = request.getObserver();
        OutputStream outputStream = httpBasicConnection.getOutputStream();
        MimeParser mimeParser = httpBasicConnection.getParser();
        Reply reply = null;
        if (request.hasProxy()) {
            request.addProxyConnection("Keep-Alive");
        } else {
            request.addConnection("Keep-Alive");
        }
        try {
            request.emit(outputStream, 1);
            outputStream.flush();
            if (requestObserver != null) {
                this.notifyObserver(requestObserver, new ConnectedEvent((HttpServer)this, request, outputStream));
            }
            if (this.isTwoStage_10(request)) {
                if (requestObserver != null) {
                    this.notifyObserver(requestObserver, new ContinueEvent(this, request));
                }
                request.emit(outputStream, 12);
                outputStream.flush();
            }
            reply = (Reply)mimeParser.parse();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (MimeParserException mimeParserException) {}
        return reply;
    }

    protected Reply http10_run(HttpBasicConnection httpBasicConnection, Request request) throws IOException, MimeParserException {
        RequestObserver requestObserver = request.getObserver();
        OutputStream outputStream = httpBasicConnection.getOutputStream();
        MimeParser mimeParser = httpBasicConnection.getParser();
        Reply reply = null;
        request.emit(outputStream, 1);
        if (requestObserver != null) {
            this.notifyObserver(requestObserver, new ConnectedEvent((HttpServer)this, request, outputStream));
            if (this.isTwoStage_10(request)) {
                this.notifyObserver(requestObserver, new ContinueEvent(this, request));
            }
        }
        request.emit(outputStream, 12);
        outputStream.flush();
        try {
            reply = (Reply)mimeParser.parse();
        }
        catch (MimeParserException mimeParserException) {}
        return reply;
    }

    protected Reply http11_run(HttpBasicConnection httpBasicConnection, Request request) throws IOException, MimeParserException {
        RequestObserver requestObserver = request.getObserver();
        OutputStream outputStream = httpBasicConnection.getOutputStream();
        MimeParser mimeParser = httpBasicConnection.getParser();
        Reply reply = null;
        try {
            request.emit(outputStream, 1);
            outputStream.flush();
            if (requestObserver != null) {
                this.notifyObserver(requestObserver, new ConnectedEvent((HttpServer)this, request, outputStream));
            }
            if (request.hasOutputStream()) {
                if (requestObserver != null) {
                    this.notifyObserver(requestObserver, new ContinueEvent(this, request));
                }
                request.emit(outputStream, 12);
                outputStream.flush();
            }
            reply = (Reply)mimeParser.parse();
            while (reply.getStatus() / 100 == 1) {
                reply = (Reply)mimeParser.parse();
            }
        }
        catch (IOException iOException) {
        }
        catch (MimeParserException mimeParserException) {}
        return reply;
    }

    /*
     * Unable to fully structure code
     */
    protected Reply http11_ts_run(HttpBasicConnection var1_1, Request var2_2) throws IOException, MimeParserException {
        var3_3 = var2_2.getObserver();
        var4_4 = var1_1.getOutputStream();
        var5_5 = var1_1.getParser();
        var6_6 = null;
        try {
            var2_2.emit(var4_4, 1);
            var4_4.flush();
            if (var3_3 != null) {
                this.notifyObserver(var3_3, new ConnectedEvent((HttpServer)this, var2_2, var4_4));
            }
            var6_6 = (Reply)var5_5.parse();
            if (true) ** GOTO lbl24
        }
        catch (IOException v0) {
            return null;
        }
        catch (MimeParserException v1) {
            return null;
        }
        do {
            if (var6_6.getStatus() == 417) {
                return var6_6;
            }
            if (var3_3 != null) {
                this.notifyObserver(var3_3, new ContinueEvent((HttpServer)this, var2_2, var6_6));
            }
            var2_2.emit(var4_4, 12);
            var4_4.flush();
            var6_6 = (Reply)var5_5.parse();
lbl24:
            // 2 sources

        } while (var6_6.getStatus() / 100 == 1 || var6_6.getStatus() == 417);
        return var6_6;
    }

    protected Reply http_unknown(HttpBasicConnection httpBasicConnection, Request request) throws IOException, MimeParserException {
        boolean bl = false;
        if (request.hasProxy()) {
            request.addProxyConnection("Keep-Alive");
        } else {
            request.addConnection("Keep-Alive");
        }
        RequestObserver requestObserver = request.getObserver();
        OutputStream outputStream = httpBasicConnection.getOutputStream();
        MimeParser mimeParser = httpBasicConnection.getParser();
        Reply reply = null;
        request.emit(outputStream, 1);
        if (requestObserver != null) {
            this.notifyObserver(requestObserver, new ConnectedEvent((HttpServer)this, request, outputStream));
            if (this.isTwoStage_10(request)) {
                bl = true;
                this.notifyObserver(requestObserver, new ContinueEvent(this, request));
            }
        }
        request.emit(outputStream, 12);
        outputStream.flush();
        try {
            reply = (Reply)mimeParser.parse();
            while (reply.getStatus() / 100 == 1) {
                if (bl) {
                    bl = false;
                    continue;
                }
                if (requestObserver != null) {
                    this.notifyObserver(requestObserver, new ContinueEvent((HttpServer)this, request, reply));
                }
                reply = (Reply)mimeParser.parse();
            }
            if (reply != null) {
                this.updateServerInfo(reply);
            }
        }
        catch (MimeParserException mimeParserException) {}
        return reply;
    }

    public void initialize(HttpManager httpManager, HttpServerState httpServerState, String string, int n, int n2) throws HttpException {
        this.manager = httpManager;
        this.state = httpServerState;
        this.host = string;
        this.port = n;
        this.timeout = n2;
        try {
            int n3 = string.length();
            boolean bl = true;
            int n4 = 0;
            while (n4 < n3) {
                char c = string.charAt(n4);
                bl = (c <= '9' && c >= '0' || c == '.') ^ true;
                if (bl) break;
                ++n4;
            }
            if (bl) {
                this.addrs = InetAddress.getAllByName(string);
            } else {
                this.addrs = new InetAddress[1];
                this.addrs[0] = InetAddress.getByName(string);
            }
        }
        catch (UnknownHostException unknownHostException) {
            String string2 = "The host name [" + string + "] couldn't be resolved. " + "Details: \"" + unknownHostException.getMessage() + "\"";
            throw new HttpException(unknownHostException, string2);
        }
    }

    protected void interruptRequest(Request request) {
        HttpBasicConnection httpBasicConnection = null;
        httpBasicConnection = (HttpBasicConnection)request.getState(STATE_CONNECTION);
        if (httpBasicConnection != null) {
            httpBasicConnection.markIdle(true);
        }
    }

    protected boolean isTwoStage_10(Request request) {
        return request.hasOutputStream();
    }

    protected boolean isTwoStage_11(Request request) {
        boolean bl = request.hasOutputStream();
        return bl && request.getExpect() != null;
    }

    protected void notifyObserver(RequestObserver requestObserver, Request request, int n) {
        RequestEvent requestEvent = new RequestEvent(this, request, n);
        requestObserver.notifyProgress(requestEvent);
    }

    protected void notifyObserver(RequestObserver requestObserver, RequestEvent requestEvent) {
        requestObserver.notifyProgress(requestEvent);
    }

    public void registerConnection(HttpConnection httpConnection) {
        this.manager.notifyIdle(httpConnection);
    }

    public Reply runRequest(Request request) throws HttpException {
        RequestObserver requestObserver = request.getObserver();
        HttpBasicConnection httpBasicConnection = null;
        Reply reply = null;
        try {
            if (requestObserver != null) {
                this.notifyObserver(requestObserver, request, RequestEvent.EVT_QUEUED);
            }
            int n = 3;
            int n2 = 0;
            while (reply == null && n2 < n) {
                httpBasicConnection = this.getConnection();
                if (httpBasicConnection != null) {
                    if (request.hasOutputStream()) {
                        int n3 = request.getContentLength();
                        if (n3 != -1) {
                            request.getOutputStream().mark(n3 + 1);
                        } else {
                            request.getOutputStream().mark(65536);
                        }
                    }
                    try {
                        reply = this.doRequest(httpBasicConnection, request);
                        if (reply == null) {
                            if (httpBasicConnection.cached) {
                                --n2;
                            }
                            if (request.hasOutputStream()) {
                                request.getOutputStream().reset();
                            }
                            httpBasicConnection.markIdle(true);
                        }
                    }
                    catch (IOException iOException) {
                        if (request.hasOutputStream()) {
                            request.getOutputStream().reset();
                        }
                        httpBasicConnection.markIdle(true);
                    }
                }
                ++n2;
            }
            if (reply == null) {
                String string = "Unable to contact target server " + this + " after " + n + " tries.";
                if (requestObserver != null) {
                    this.notifyObserver(requestObserver, request, RequestEvent.EVT_UNREACHABLE);
                }
                throw new HttpException(request, string);
            }
            reply.matchesRequest(request);
            if (requestObserver != null) {
                this.notifyObserver(requestObserver, request, RequestEvent.EVT_REPLIED);
            }
            if (reply.keepsAlive()) {
                reply.setStreamObserver(httpBasicConnection);
                if (!reply.hasInputStream()) {
                    httpBasicConnection.markIdle(false);
                }
            } else {
                this.deleteConnection(httpBasicConnection);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            if (httpBasicConnection != null) {
                httpBasicConnection.markIdle(true);
            }
            if (requestObserver != null) {
                this.notifyObserver(requestObserver, request, RequestEvent.EVT_CLOSED);
            }
            throw new HttpException(request, iOException);
        }
        catch (MimeParserException mimeParserException) {
            mimeParserException.printStackTrace();
            if (httpBasicConnection != null) {
                httpBasicConnection.markIdle(true);
            }
            if (requestObserver != null) {
                this.notifyObserver(requestObserver, request, RequestEvent.EVT_CLOSED);
            }
            throw new HttpException(request, mimeParserException);
        }
        return reply;
    }

    public synchronized void setTimeout(int n) {
        this.timeout = n;
    }

    public String toString() {
        return String.valueOf(this.host) + ":" + this.port;
    }

    public synchronized void unregisterConnection(HttpConnection httpConnection) {
        this.manager.notifyUse(httpConnection);
    }

    protected synchronized void updateServerInfo(Reply reply) {
        if (this.contacted) {
            return;
        }
        this.major = reply.getMajorVersion();
        this.minor = reply.getMinorVersion();
        this.keepalive = reply.keepsAlive();
        this.contacted = true;
    }
}

