/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.w3c.www.http.HttpStreamObserver;
import org.w3c.www.mime.MimeParser;
import org.w3c.www.mime.MimeParserFactory;
import org.w3c.www.protocol.http.HttpBasicServer;
import org.w3c.www.protocol.http.HttpConnection;
import org.w3c.www.protocol.http.HttpServer;

class HttpBasicConnection
extends HttpConnection
implements HttpStreamObserver {
    private static final boolean debug = false;
    Socket socket = null;
    MimeParser parser = null;
    OutputStream output = null;
    InputStream input = null;
    MimeParserFactory reply_factory = null;
    Thread th = null;
    InetAddress inetaddr = null;
    int port = -1;
    int timeout = 300000;
    protected int id = -1;

    HttpBasicConnection(HttpServer httpServer, int n, InetAddress inetAddress, int n2, int n3, MimeParserFactory mimeParserFactory) throws IOException {
        this.server = httpServer;
        this.inetaddr = inetAddress;
        this.port = n2;
        this.id = n;
        this.timeout = n3;
        this.reply_factory = mimeParserFactory;
    }

    public synchronized void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
            this.socket = null;
            this.output = null;
            this.input = null;
            this.parser = null;
            this.cached = false;
        }
    }

    public OutputStream getOutputStream() {
        if (this.output == null) {
            throw new RuntimeException("getOutputStream while disconnected.");
        }
        return this.output;
    }

    public MimeParser getParser() {
        if (this.parser == null) {
            throw new RuntimeException("getParser while disconnected.");
        }
        return this.parser;
    }

    public synchronized void markIdle(boolean bl) {
        if (this.th == null) {
            return;
        }
        this.th = null;
        if (bl) {
            this.close();
            ((HttpBasicServer)this.server).deleteConnection(this);
        } else {
            ((HttpBasicServer)this.server).registerConnection(this);
        }
    }

    public synchronized boolean markUsed() {
        this.cached = false;
        if (this.th != null) {
            throw new RuntimeException(String.valueOf(String.valueOf(this)) + " already used by " + this.th);
        }
        this.th = Thread.currentThread();
        if (this.socket != null) {
            this.cached = true;
        }
        if (this.socket == null) {
            try {
                this.socket = new Socket(this.inetaddr, this.port);
                this.socket.setSoTimeout(this.timeout);
                this.output = new BufferedOutputStream(this.socket.getOutputStream());
                this.input = new BufferedInputStream(this.socket.getInputStream());
                this.parser = new MimeParser(this.input, this.reply_factory);
            }
            catch (IOException iOException) {
                this.close();
                ((HttpBasicServer)this.server).unregisterConnection(this);
                ((HttpBasicServer)this.server).deleteConnection(this);
                return false;
            }
        }
        ((HttpBasicServer)this.server).unregisterConnection(this);
        return true;
    }

    public synchronized void notifyClose(InputStream inputStream) {
        try {
            byte[] byArray = new byte[1024];
            while (inputStream.read(byArray) > 0) {
            }
            this.markIdle(false);
        }
        catch (IOException iOException) {
            this.markIdle(true);
        }
    }

    public synchronized void notifyEOF(InputStream inputStream) {
        this.markIdle(false);
    }

    public synchronized void notifyFailure(InputStream inputStream) {
        this.markIdle(true);
    }

    public void notifyInputAvailable(InputStream inputStream) {
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.inetaddr)) + ":" + this.port + "[" + this.id + "]";
    }
}

