/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mime;

import java.util.Hashtable;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;

public class Utils {
    private static Hashtable extension_map = new Hashtable();

    static {
        Utils.setSuffix("", "content/unknown");
        Utils.setSuffix(".uu", "application/octet-stream");
        Utils.setSuffix(".saveme", "application/octet-stream");
        Utils.setSuffix(".dump", "application/octet-stream");
        Utils.setSuffix(".hqx", "application/octet-stream");
        Utils.setSuffix(".arc", "application/octet-stream");
        Utils.setSuffix(".o", "application/octet-stream");
        Utils.setSuffix(".a", "application/octet-stream");
        Utils.setSuffix(".bin", "application/octet-stream");
        Utils.setSuffix(".exe", "application/octet-stream");
        Utils.setSuffix(".z", "application/octet-stream");
        Utils.setSuffix(".gz", "application/octet-stream");
        Utils.setSuffix(".oda", "application/oda");
        Utils.setSuffix(".pdf", "application/pdf");
        Utils.setSuffix(".eps", "application/postscript");
        Utils.setSuffix(".ai", "application/postscript");
        Utils.setSuffix(".ps", "application/postscript");
        Utils.setSuffix(".rtf", "application/rtf");
        Utils.setSuffix(".dvi", "application/x-dvi");
        Utils.setSuffix(".hdf", "application/x-hdf");
        Utils.setSuffix(".latex", "application/x-latex");
        Utils.setSuffix(".cdf", "application/x-netcdf");
        Utils.setSuffix(".nc", "application/x-netcdf");
        Utils.setSuffix(".tex", "application/x-tex");
        Utils.setSuffix(".texinfo", "application/x-texinfo");
        Utils.setSuffix(".texi", "application/x-texinfo");
        Utils.setSuffix(".t", "application/x-troff");
        Utils.setSuffix(".tr", "application/x-troff");
        Utils.setSuffix(".roff", "application/x-troff");
        Utils.setSuffix(".man", "application/x-troff-man");
        Utils.setSuffix(".me", "application/x-troff-me");
        Utils.setSuffix(".ms", "application/x-troff-ms");
        Utils.setSuffix(".src", "application/x-wais-source");
        Utils.setSuffix(".wsrc", "application/x-wais-source");
        Utils.setSuffix(".zip", "application/zip");
        Utils.setSuffix(".bcpio", "application/x-bcpio");
        Utils.setSuffix(".cpio", "application/x-cpio");
        Utils.setSuffix(".gtar", "application/x-gtar");
        Utils.setSuffix(".shar", "application/x-shar");
        Utils.setSuffix(".sh", "application/x-shar");
        Utils.setSuffix(".sv4cpio", "application/x-sv4cpio");
        Utils.setSuffix(".sv4crc", "application/x-sv4crc");
        Utils.setSuffix(".tar", "application/x-tar");
        Utils.setSuffix(".ustar", "application/x-ustar");
        Utils.setSuffix(".snd", "audio/basic");
        Utils.setSuffix(".au", "audio/basic");
        Utils.setSuffix(".aifc", "audio/x-aiff");
        Utils.setSuffix(".aif", "audio/x-aiff");
        Utils.setSuffix(".aiff", "audio/x-aiff");
        Utils.setSuffix(".wav", "audio/x-wav");
        Utils.setSuffix(".gif", "image/gif");
        Utils.setSuffix(".ief", "image/ief");
        Utils.setSuffix(".jfif", "image/jpeg");
        Utils.setSuffix(".jfif-tbnl", "image/jpeg");
        Utils.setSuffix(".jpe", "image/jpeg");
        Utils.setSuffix(".jpg", "image/jpeg");
        Utils.setSuffix(".jpeg", "image/jpeg");
        Utils.setSuffix(".tif", "image/tiff");
        Utils.setSuffix(".tiff", "image/tiff");
        Utils.setSuffix(".ras", "image/x-cmu-rast");
        Utils.setSuffix(".pnm", "image/x-portable-anymap");
        Utils.setSuffix(".pbm", "image/x-portable-bitmap");
        Utils.setSuffix(".pgm", "image/x-portable-graymap");
        Utils.setSuffix(".ppm", "image/x-portable-pixmap");
        Utils.setSuffix(".rgb", "image/x-rgb");
        Utils.setSuffix(".xbm", "image/x-xbitmap");
        Utils.setSuffix(".xpm", "image/x-xpixmap");
        Utils.setSuffix(".xwd", "image/x-xwindowdump");
        Utils.setSuffix(".htm", "text/html");
        Utils.setSuffix(".html", "text/html");
        Utils.setSuffix(".text", "text/plain");
        Utils.setSuffix(".c", "text/plain");
        Utils.setSuffix(".cc", "text/plain");
        Utils.setSuffix(".c++", "text/plain");
        Utils.setSuffix(".h", "text/plain");
        Utils.setSuffix(".pl", "text/plain");
        Utils.setSuffix(".txt", "text/plain");
        Utils.setSuffix(".java", "text/plain");
        Utils.setSuffix(".rtx", "application/rtf");
        Utils.setSuffix(".tsv", "texyt/tab-separated-values");
        Utils.setSuffix(".etx", "text/x-setext");
        Utils.setSuffix(".mpg", "video/mpeg");
        Utils.setSuffix(".mpe", "video/mpeg");
        Utils.setSuffix(".mpeg", "video/mpeg");
        Utils.setSuffix(".mov", "video/quicktime");
        Utils.setSuffix(".qt", "video/quicktime");
        Utils.setSuffix(".avi", "application/x-troff-msvideo");
        Utils.setSuffix(".movie", "video/x-sgi-movie");
        Utils.setSuffix(".mv", "video/x-sgi-movie");
        Utils.setSuffix(".mime", "message/rfc822");
    }

    public static MimeType getMimeType(String string) {
        try {
            return new MimeType(Utils.guessContentTypeFromName(string));
        }
        catch (MimeTypeFormatException mimeTypeFormatException) {
            return null;
        }
    }

    public static String guessContentTypeFromName(String string) {
        String string2 = "";
        int n = string.lastIndexOf(35);
        if (n != -1) {
            string = string.substring(0, n - 1);
        }
        n = string.lastIndexOf(46);
        n = Math.max(n, string.lastIndexOf(47));
        if ((n = Math.max(n, string.lastIndexOf(63))) != -1 && string.charAt(n) == '.') {
            string2 = string.substring(n).toLowerCase();
        }
        return (String)extension_map.get(string2);
    }

    private static void setSuffix(String string, String string2) {
        extension_map.put(string, string2);
    }
}

