/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mime;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MultipartInputStream
extends InputStream {
    InputStream in = null;
    byte[] boundary = null;
    byte[] buffer = null;
    boolean partEnd = false;
    boolean fileEnd = false;

    public MultipartInputStream(InputStream inputStream, byte[] byArray) {
        this.in = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream, byArray.length + 4);
        this.boundary = byArray;
        this.buffer = new byte[byArray.length];
        this.partEnd = false;
        this.fileEnd = false;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public boolean nextInputStream() throws IOException {
        if (this.fileEnd) {
            return false;
        }
        if (!this.partEnd) {
            return this.skipToBoundary();
        }
        this.partEnd = false;
        return true;
    }

    public int read() throws IOException {
        if (this.partEnd) {
            return -1;
        }
        int n = this.in.read();
        switch (n) {
            case 13: {
                this.in.mark(this.boundary.length + 3);
                int n2 = this.in.read();
                int n3 = this.in.read();
                int n4 = this.in.read();
                if (n2 == 10 && n3 == 45 && n4 == 45) {
                    if (!this.readBoundaryBytes()) {
                        this.in.reset();
                        return n;
                    }
                    int n5 = 0;
                    while (n5 < this.boundary.length) {
                        if (this.buffer[n5] != this.boundary[n5]) {
                            this.in.reset();
                            return n;
                        }
                        ++n5;
                    }
                    this.partEnd = true;
                    n = this.in.read();
                    if (n == 13) {
                        this.in.read();
                    } else if (n == 45) {
                        if (this.in.read() == 45) {
                            this.fileEnd = true;
                        }
                    } else {
                        this.fileEnd = n == -1;
                    }
                    return -1;
                }
                this.in.reset();
                return n;
            }
            case -1: {
                this.fileEnd = true;
                return -1;
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 == -1) {
                return n3;
            }
            byArray[n + n3++] = (byte)(n4 & 0xFF);
        }
        return n3;
    }

    private final boolean readBoundaryBytes() throws IOException {
        int n = 0;
        while (n < this.buffer.length) {
            int n2 = this.in.read(this.buffer, n, this.buffer.length - n);
            if (n2 < 0) {
                return false;
            }
            n += n2;
        }
        return true;
    }

    public long skip(long l) throws IOException {
        while (--l >= 0L && this.read() != -1) {
        }
        return l;
    }

    protected boolean skipToBoundary() throws IOException {
        int n = this.in.read();
        block0: while (n != -1) {
            if (n != 45) {
                n = this.in.read();
                continue;
            }
            n = this.in.read();
            if (n != 45) continue;
            this.in.mark(this.boundary.length);
            if (!this.readBoundaryBytes()) {
                this.in.reset();
                n = this.in.read();
                continue;
            }
            int n2 = 0;
            while (n2 < this.boundary.length) {
                if (this.buffer[n2] != this.boundary[n2]) {
                    this.in.reset();
                    n = this.in.read();
                    continue block0;
                }
                ++n2;
            }
            n = this.in.read();
            if (n == 13) {
                n = this.in.read();
            }
            this.in.mark(3);
            if (this.in.read() == 45 && this.in.read() == 13 && this.in.read() == 10) {
                this.fileEnd = true;
                return false;
            }
            this.in.reset();
            return true;
        }
        this.fileEnd = true;
        return false;
    }
}

