/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mime;

import java.io.Serializable;
import java.util.Vector;
import org.w3c.www.mime.MimeTypeFormatException;

public class MimeType
implements Serializable,
Cloneable {
    public static MimeType TEXT_HTML = null;
    public static MimeType APPLICATION_POSTSCRIPT = null;
    public static MimeType TEXT_PLAIN = null;
    public static MimeType APPLICATION_X_WWW_FORM_URLENCODED = null;
    public static MimeType MULTIPART_FORM_DATA = null;
    public static MimeType APPLICATION_X_JAVA_AGENT = null;
    public static MimeType MESSAGE_HTTP = null;
    public static MimeType TEXT_CSS = null;
    public static MimeType TEXT = null;
    public static final int NO_MATCH = -1;
    public static final int MATCH_TYPE = 1;
    public static final int MATCH_SPECIFIC_TYPE = 2;
    public static final int MATCH_SUBTYPE = 3;
    public static final int MATCH_SPECIFIC_SUBTYPE = 4;
    protected String type;
    protected String subtype;
    protected String[] pnames;
    protected String[] pvalues;
    protected String external;

    static {
        try {
            TEXT_HTML = new MimeType("text/html");
            APPLICATION_POSTSCRIPT = new MimeType("application/postscript");
            TEXT_PLAIN = new MimeType("text/plain");
            APPLICATION_X_WWW_FORM_URLENCODED = new MimeType("application/x-www-form-urlencoded");
            MULTIPART_FORM_DATA = new MimeType("multipart/form-data");
            APPLICATION_X_JAVA_AGENT = new MimeType("application/x-java-agent");
            MESSAGE_HTTP = new MimeType("message/http");
            TEXT_CSS = new MimeType("text/css");
            TEXT = new MimeType("text/*");
        }
        catch (MimeTypeFormatException mimeTypeFormatException) {
            System.out.println("httpd.MimeType: invalid static init.");
            System.exit(1);
        }
    }

    /*
     * Unable to fully structure code
     */
    public MimeType(String var1_1) throws MimeTypeFormatException {
        block15: {
            super();
            this.type = null;
            this.subtype = null;
            this.pnames = null;
            this.pvalues = null;
            this.external = null;
            var2_2 = var1_1.length();
            var3_3 = 0;
            var4_4 = -1;
            while (var3_3 < var2_2 && var1_1.charAt(var3_3) <= ' ') {
                ++var3_3;
            }
            while (var2_2 > var3_3 && var1_1.charAt(var2_2 - 1) <= ' ') {
                --var2_2;
            }
            var5_5 = new StringBuffer();
            if (true) ** GOTO lbl22
            do {
                var5_5.append((char)var4_4);
                ++var3_3;
lbl22:
                // 2 sources

                if (var3_3 >= var2_2) break;
                v0 = var1_1.charAt(var3_3);
                var4_4 = v0;
            } while (v0 != '/');
            if (var4_4 != 47) {
                throw new MimeTypeFormatException(var1_1);
            }
            this.type = var5_5.toString();
            ++var3_3;
            var5_5.setLength(0);
            if (true) ** GOTO lbl36
            do {
                var5_5.append((char)var4_4);
                ++var3_3;
lbl36:
                // 2 sources

                if (var3_3 >= var2_2) break;
                v1 = var1_1.charAt(var3_3);
                var4_4 = v1;
            } while (v1 > ' ' && var4_4 != 59);
            this.subtype = var5_5.toString();
            if (true) ** GOTO lbl44
            do {
                ++var3_3;
lbl44:
                // 2 sources

                if (var3_3 >= var2_2) break;
                v2 = var1_1.charAt(var3_3);
                var4_4 = v2;
            } while (v2 <= ' ');
            if (var3_3 >= var2_2) break block15;
            if (var1_1.charAt(var3_3) != ';') {
                throw new MimeTypeFormatException(var1_1);
            }
            ++var3_3;
            var6_6 = new Vector<String>(4);
            var7_7 = new Vector<String>(4);
            ** GOTO lbl95
            {
                ++var3_3;
                do {
                    if (var3_3 < var2_2 && var1_1.charAt(var3_3) <= ' ') continue block5;
                    var5_5.setLength(0);
                    if (true) ** GOTO lbl64
                    do {
                        var5_5.append(Character.toLowerCase((char)var4_4));
                        ++var3_3;
lbl64:
                        // 2 sources

                        if (var3_3 >= var2_2) break;
                        v3 = var1_1.charAt(var3_3);
                        var4_4 = v3;
                    } while (v3 > ' ' && var4_4 != 61);
                    var8_8 = var5_5.toString();
                    while (var3_3 < var2_2 && var1_1.charAt(var3_3) <= ' ') {
                        ++var3_3;
                    }
                    if (var1_1.charAt(var3_3) != '=') {
                        throw new MimeTypeFormatException(var1_1);
                    }
                    ++var3_3;
                    while (var3_3 < var2_2 && (var1_1.charAt(var3_3) == '\"' || var1_1.charAt(var3_3) <= ' ')) {
                        ++var3_3;
                    }
                    var5_5.setLength(0);
                    if (true) ** GOTO lbl84
                    do {
                        var5_5.append((char)var4_4);
                        ++var3_3;
lbl84:
                        // 2 sources

                        if (var3_3 >= var2_2) break;
                        v4 = var1_1.charAt(var3_3);
                        var4_4 = v4;
                    } while (v4 > ' ' && var4_4 != 59 && var4_4 != 34);
                    while (var3_3 < var2_2 && var1_1.charAt(var3_3) != ';') {
                        ++var3_3;
                    }
                    ++var3_3;
                    var9_9 = var5_5.toString();
                    var6_6.addElement(var8_8);
                    var7_7.addElement(var9_9);
lbl95:
                    // 2 sources

                } while (var3_3 < var2_2);
            }
            this.pnames = new String[var6_6.size()];
            var6_6.copyInto(this.pnames);
            this.pvalues = new String[var7_7.size()];
            var7_7.copyInto(this.pvalues);
        }
    }

    public MimeType(String string, String string2) {
        this.type = null;
        this.subtype = null;
        this.pnames = null;
        this.pvalues = null;
        this.external = null;
        this.type = string;
        this.subtype = string2;
    }

    public MimeType(String string, String string2, String[] stringArray, String[] stringArray2) {
        this.type = null;
        this.subtype = null;
        this.pnames = null;
        this.pvalues = null;
        this.external = null;
        this.type = string;
        this.subtype = string2;
        this.pnames = stringArray;
        this.pvalues = stringArray2;
    }

    public String getParameterValue(String string) {
        if (this.pnames != null) {
            int n = 0;
            while (n < this.pnames.length) {
                if (this.pnames[n].equals(string)) {
                    return this.pvalues[n];
                }
                ++n;
            }
        }
        return null;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasParameter(String string) {
        if (this.pnames != null) {
            int n = 0;
            while (n < this.pnames.length) {
                if (this.pnames[n].equals(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            MimeType mimeType = null;
            try {
                mimeType = new MimeType(stringArray[0]);
            }
            catch (MimeTypeFormatException mimeTypeFormatException) {}
            if (mimeType != null) {
                System.out.println(mimeType);
            } else {
                System.out.println("Invalid mime type specification.");
            }
        } else {
            System.out.println("Usage: java MimeType <type-to-parse>");
        }
    }

    public int match(MimeType mimeType) {
        int n = -1;
        if (this.type.equals("*") || mimeType.type.equals("*")) {
            n = 1;
        } else {
            if (!this.type.equals(mimeType.type)) {
                return -1;
            }
            n = 2;
        }
        if (this.subtype.equals("*") || mimeType.subtype.equals("*")) {
            n = 3;
        } else {
            if (!this.subtype.equals(mimeType.subtype)) {
                return -1;
            }
            n = 4;
        }
        return n;
    }

    public String toString() {
        if (this.external == null) {
            StringBuffer stringBuffer = new StringBuffer(this.type);
            stringBuffer.append('/');
            stringBuffer.append(this.subtype);
            if (this.pnames != null) {
                int n = 0;
                while (n < this.pnames.length) {
                    stringBuffer.append(';');
                    stringBuffer.append(this.pnames[n]);
                    if (this.pvalues[n] != null) {
                        stringBuffer.append('=');
                        stringBuffer.append(this.pvalues[n]);
                    }
                    ++n;
                }
            }
            this.external = stringBuffer.toString();
        }
        return this.external;
    }
}

