/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.util.Vector;
import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpAcceptList;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpInvalidValueException;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.ParseState;
import org.w3c.www.mime.MimeType;

public class HttpAccept
extends BasicValue {
    protected String[] aparams = null;
    protected String[] avalues = null;
    protected MimeType type = null;
    HttpAcceptList list = null;

    public HttpAccept() {
        this.isValid = false;
    }

    HttpAccept(HttpAcceptList httpAcceptList, byte[] byArray, int n, int n2) {
        this.list = httpAcceptList;
        this.raw = byArray;
        this.roff = n;
        this.rlen = n2;
        this.isValid = false;
    }

    HttpAccept(boolean bl, MimeType mimeType, double d) {
        this.isValid = bl;
        this.setMimeType(mimeType);
    }

    public String getAcceptParameter(String string) {
        this.validate();
        int n = this.lookup(string);
        return n == -1 ? null : this.avalues[n];
    }

    public MimeType getMimeType() {
        this.validate();
        return this.type;
    }

    public double getQuality() {
        String string = this.getAcceptParameter("q");
        if (string == null) {
            String string2 = this.type.getType();
            String string3 = this.type.getSubtype();
            if (string2.equals("*")) {
                return string3.equals("*") ? 0.1 : 0.5;
            }
            return string3.equals("*") ? 0.5 : 1.0;
        }
        try {
            return Double.valueOf(string);
        }
        catch (Exception exception) {
            String string4 = "invalid quality value: " + string;
            throw new HttpInvalidValueException(string4);
        }
    }

    public Object getValue() {
        this.validate();
        return this;
    }

    protected void invalideByteValue() {
        super.invalidateByteValue();
        if (this.list != null) {
            this.list.invalidateByteValue();
        }
    }

    protected int lookup(String string) {
        if (this.aparams == null) {
            return -1;
        }
        int n = 0;
        while (n < this.aparams.length) {
            if (string.equalsIgnoreCase(this.aparams[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected void parse() throws HttpParserException {
        Object object;
        ParseState parseState = new ParseState(this.roff, this.rlen);
        parseState.separator = (byte)47;
        parseState.spaceIsSep = false;
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("Invalid Accept: has no type.");
        }
        String string = new String(this.raw, 0, parseState.start, parseState.end - parseState.start);
        parseState.prepare();
        parseState.separator = (byte)59;
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("Invalid accept: no subtype");
        }
        String string2 = new String(this.raw, 0, parseState.start, parseState.end - parseState.start);
        ParseState parseState2 = new ParseState();
        parseState2.separator = (byte)61;
        parseState2.spaceIsSep = false;
        parseState.prepare();
        Vector<String> vector = new Vector<String>(4);
        Vector<String> vector2 = new Vector<String>(4);
        boolean bl = false;
        while (HttpParser.nextItem(this.raw, parseState) >= 0) {
            parseState2.ioff = parseState.start;
            parseState2.bufend = parseState.end;
            if (HttpParser.nextItem(this.raw, parseState2) < 0) {
                this.error("Invalid parameter: no param name.");
            }
            if (((String)(object = new String(this.raw, 0, parseState2.start, parseState2.end - parseState2.start))).equalsIgnoreCase("q")) {
                bl = true;
                break;
            }
            vector.addElement(new String(this.raw, 0, parseState2.start, parseState2.end - parseState2.start));
            parseState2.prepare();
            if (HttpParser.nextItem(this.raw, parseState2) < 0) {
                this.error("Invalid parameter: no value.");
            }
            vector2.addElement(new String(this.raw, 0, parseState2.start, parseState2.end - parseState2.start));
            parseState.prepare();
        }
        if (vector.size() > 0) {
            object = new String[vector.size()];
            Object[] objectArray = new String[((String[])object).length];
            vector.copyInto((Object[])object);
            vector2.copyInto(objectArray);
            this.type = new MimeType(string, string2, (String[])object, (String[])objectArray);
        } else {
            this.type = new MimeType(string, string2);
        }
        if (bl) {
            vector.setSize(0);
            vector2.setSize(0);
            parseState2.prepare();
            if (HttpParser.nextItem(this.raw, parseState2) < 0) {
                this.error("Invalid accept parameter: no value.");
            }
            vector.addElement("q");
            vector2.addElement(new String(this.raw, 0, parseState2.start, parseState2.end - parseState2.start));
            parseState2.prepare();
            while (HttpParser.nextItem(this.raw, parseState) >= 0) {
                parseState2.ioff = parseState.start;
                parseState2.bufend = parseState.end;
                if (HttpParser.nextItem(this.raw, parseState2) < 0) {
                    this.error("Invalid accept parameter: no name.");
                }
                vector.addElement(new String(this.raw, 0, parseState2.start, parseState2.end - parseState2.start));
                parseState2.prepare();
                if (HttpParser.nextItem(this.raw, parseState2) < 0) {
                    this.error("Invalid accept parameter: no value.");
                }
                vector2.addElement(new String(this.raw, 0, parseState2.start, parseState2.end - parseState2.start));
                parseState.prepare();
            }
            this.aparams = new String[vector.size()];
            this.avalues = new String[this.aparams.length];
            vector.copyInto(this.aparams);
            vector2.copyInto(this.avalues);
        }
    }

    public void setAcceptParameter(String string, String string2) {
        this.validate();
        int n = this.lookup(string);
        if (n == -1) {
            int n2 = 0;
            while (n2 < this.aparams.length) {
                if (this.aparams[n2] == null) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n == -1) {
                n = this.aparams.length;
                String[] stringArray = new String[n << 1];
                String[] stringArray2 = new String[stringArray.length];
                System.arraycopy(this.aparams, 0, stringArray, 0, n);
                System.arraycopy(this.avalues, 0, stringArray2, 0, n);
                this.aparams = stringArray;
                this.avalues = stringArray2;
            }
        }
        this.invalidateByteValue();
        this.aparams[n] = string;
        this.avalues[n] = string2;
    }

    public void setMimeType(MimeType mimeType) {
        this.invalidateByteValue();
        this.type = mimeType;
    }

    protected void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        httpBuffer.append(this.type.toString());
        if (this.aparams != null) {
            int n = 0;
            while (n < this.aparams.length) {
                if (n > 0) {
                    httpBuffer.append(';');
                }
                httpBuffer.append(this.aparams[n], (byte)61, this.avalues[n]);
                ++n;
            }
        }
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }
}

