/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.io.DataOutputStream;
import java.io.IOException;

public class ChunkedOutputStream
extends DataOutputStream {
    private static final byte[] crlf = new byte[]{13, 10};
    private static final byte[] lastchunk;
    private static final int DEFAULT_CHUNK_SIZE = 512;
    protected byte[] buffer = null;
    protected int bufptr = 0;
    protected int chunksize = -1;
    protected byte[] bheader = new byte[32];

    static {
        byte[] byArray = new byte[3];
        byArray[1] = 13;
        byArray[2] = 10;
        lastchunk = byArray;
    }

    public ChunkedOutputStream(DataOutputStream dataOutputStream) {
        this(new byte[512], dataOutputStream);
    }

    public ChunkedOutputStream(byte[] byArray, DataOutputStream dataOutputStream) {
        super(dataOutputStream);
        this.buffer = byArray;
        this.chunksize = byArray.length;
    }

    protected final void append(int n) throws IOException {
        if (this.bufptr + 1 >= this.chunksize) {
            this.sendChunk();
        }
        this.buffer[this.bufptr++] = (byte)(n & 0xFF);
    }

    protected final void append(byte[] byArray, int n, int n2) throws IOException {
        if (this.bufptr + n2 >= this.chunksize) {
            this.sendChunk();
        }
        if (n2 < this.buffer.length) {
            System.arraycopy(byArray, n, this.buffer, this.bufptr, n2);
            this.bufptr += n2;
        } else {
            this.sendChunk(byArray, n, n2);
        }
    }

    public void close() throws IOException {
        this.sendChunk();
        super.close();
    }

    public void flush() throws IOException {
        this.sendChunk();
        super.flush();
    }

    protected void sendChunk() throws IOException {
        if (this.bufptr == 0) {
            return;
        }
        this.sendChunk(this.buffer, 0, this.bufptr);
        this.bufptr = 0;
    }

    protected void sendChunk(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        String string = String.valueOf(Integer.toString(n2, 16).toUpperCase()) + "\r\n";
        int n3 = string.length();
        string.getBytes(0, n3, this.bheader, 0);
        this.out.write(this.bheader, 0, n3);
        this.out.write(byArray, n, n2);
        this.out.write(crlf, 0, 2);
        this.out.flush();
    }

    protected void sendClose() throws IOException {
        this.sendChunk(lastchunk, 0, lastchunk.length);
    }

    public void write(int n) throws IOException {
        this.append(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.append(byArray, n, n2);
    }
}

