/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.upgrade;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import org.w3c.tools.resources.upgrade.Attribute;
import org.w3c.util.ArrayDictionary;

public class PropertiesAttribute
extends Attribute {
    public PropertiesAttribute(String string, String string2, int n) {
        super(string, string2, n);
        this.type = "java.lang.String";
    }

    public boolean checkValue(Object object) {
        return object == null || object instanceof ArrayDictionary;
    }

    public final int getPickleLength(Object object) {
        ArrayDictionary arrayDictionary = (ArrayDictionary)object;
        Enumeration enumeration = arrayDictionary.keys();
        int n = 4;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            n += this.getPickleLength(string);
            n += this.getPickleLength((String)arrayDictionary.get(string));
        }
        return n;
    }

    private int getPickleLength(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n3;
        }
        return n2 + 2;
    }

    public void pickle(DataOutputStream dataOutputStream, Object object) throws IOException {
        ArrayDictionary arrayDictionary = (ArrayDictionary)object;
        Enumeration enumeration = arrayDictionary.keys();
        int n = arrayDictionary.size();
        dataOutputStream.writeInt(n);
        while (--n >= 0) {
            String string = (String)enumeration.nextElement();
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeUTF((String)arrayDictionary.get(string));
        }
    }

    public Object unpickle(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        ArrayDictionary arrayDictionary = new ArrayDictionary(n, 5);
        while (--n >= 0) {
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            arrayDictionary.put(string, string2);
        }
        return arrayDictionary;
    }
}

