/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.store;

import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.store.Reference;
import org.w3c.tools.resources.store.ResourceStore;
import org.w3c.tools.resources.store.ResourceStoreImpl;
import org.w3c.tools.resources.store.ResourceStoreManager;
import org.w3c.util.LRUAble;

class StoreEntry
implements LRUAble,
Serializable {
    boolean istransient = false;
    Integer key = null;
    transient LRUAble next = null;
    transient LRUAble prev = null;
    transient ResourceStore store = null;
    transient Hashtable references = null;
    transient ResourceStoreManager manager = null;
    String repository = null;
    transient File rep = null;

    StoreEntry(ResourceStoreManager resourceStoreManager, File file, Integer n) {
        this.manager = resourceStoreManager;
        this.store = null;
        this.rep = file;
        this.key = n;
        this.references = new Hashtable();
    }

    StoreEntry(ResourceStoreManager resourceStoreManager, String string, Integer n) {
        this.manager = resourceStoreManager;
        this.store = null;
        this.repository = string;
        this.key = n;
        this.references = new Hashtable();
    }

    synchronized ResourceReference addResource(Resource resource, Hashtable hashtable) {
        this.getStore();
        this.store.addResource(resource);
        String string = resource.getIdentifier();
        Reference reference = new Reference(this, string, hashtable);
        this.references.put(string, reference);
        return reference;
    }

    synchronized void deleteStore() {
        Enumeration enumeration = this.references.elements();
        Reference reference = null;
        while (enumeration.hasMoreElements()) {
            reference = (Reference)enumeration.nextElement();
            reference.invalidate();
        }
        this.getRepository().delete();
        if (this.store != null) {
            this.store = null;
            this.manager.decrLoadedStore();
        }
        this.references = null;
    }

    public synchronized Enumeration enumerateResourceIdentifiers() {
        this.getStore();
        return this.store.enumerateResourceIdentifiers();
    }

    public LRUAble getNext() {
        return this.next;
    }

    public LRUAble getPrev() {
        return this.prev;
    }

    public File getRepository() {
        if (this.rep == null) {
            this.rep = new File(this.manager.storedir, this.repository);
        }
        return this.rep;
    }

    synchronized ResourceStore getStore() {
        if (this.store == null) {
            this.store = new ResourceStoreImpl();
            this.store.initialize(this.manager, this, this.getRepository(), this.manager.serializer);
            this.manager.incrLoadedStore();
        }
        return this.store;
    }

    void initialize(ResourceStoreManager resourceStoreManager) {
        this.manager = resourceStoreManager;
        this.references = new Hashtable();
    }

    public boolean isTransient() {
        return this.istransient;
    }

    synchronized ResourceReference loadResource(String string, Hashtable hashtable) {
        ResourceReference resourceReference = this.lookupResource(string);
        if (resourceReference != null) {
            return resourceReference;
        }
        resourceReference = new Reference(this, string, hashtable);
        try {
            try {
                Resource resource = resourceReference.lock();
                if (resource == null) {
                    ResourceReference resourceReference2 = null;
                    Object var6_7 = null;
                    resourceReference.unlock();
                    return resourceReference2;
                }
            }
            catch (InvalidResourceException invalidResourceException) {
                ResourceReference resourceReference3 = null;
                Object var6_8 = null;
                resourceReference.unlock();
                return resourceReference3;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            resourceReference.unlock();
            throw throwable;
        }
        Object var6_9 = null;
        resourceReference.unlock();
        this.references.put(string, resourceReference);
        return resourceReference;
    }

    public ResourceReference lookupResource(String string) {
        return (ResourceReference)this.references.get(string);
    }

    public synchronized void markModified(Resource resource) {
        this.getStore();
        this.store.markModified(resource);
    }

    public synchronized void removeResource(String string) {
        this.getStore();
        Reference reference = (Reference)this.references.get(string);
        if (reference != null) {
            this.references.remove(string);
            this.manager.getEventQueue().removeSourceEvents(reference);
            reference.invalidate();
        }
        this.store.removeResource(string);
    }

    public synchronized void renameResource(String string, String string2) {
        this.getStore();
        this.store.renameResource(string, string2);
        Reference reference = (Reference)this.lookupResource(string);
        if (reference != null) {
            reference.identifier = string2;
            this.references.remove(string);
            this.references.put(string2, reference);
        }
    }

    synchronized void saveResource(Resource resource) {
        this.getStore();
        this.store.saveResource(resource);
    }

    synchronized void saveStore() {
        if (this.store != null) {
            this.store.save();
        }
    }

    public void setNext(LRUAble lRUAble) {
        this.next = lRUAble;
    }

    public void setPrev(LRUAble lRUAble) {
        this.prev = lRUAble;
    }

    public void setTransient(boolean bl) {
        this.istransient = bl;
    }

    synchronized void shutdownStore() {
        if (this.store != null) {
            this.store.shutdown();
            this.store = null;
            this.manager.decrLoadedStore();
        }
    }

    synchronized boolean unloadStore() {
        if (this.store != null) {
            Enumeration enumeration = this.references.elements();
            ResourceReference resourceReference = null;
            while (enumeration.hasMoreElements()) {
                resourceReference = (ResourceReference)enumeration.nextElement();
                if (!resourceReference.isLocked()) continue;
                return false;
            }
            if (!this.store.acceptUnload()) {
                return false;
            }
            this.shutdownStore();
        }
        return true;
    }
}

