/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.dbm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.w3c.tools.dbm.jdbm;
import org.w3c.tools.dbm.jdbmBucketElement;

class jdbmBucket {
    private static final boolean debug = false;
    private static final int AVAIL_SIZE = 6;
    private static final int IGNORE_SIZE = 8;
    static final int fsize = 60;
    int bits = 0;
    int count = 0;
    jdbmBucketElement[] elements = null;
    int avail_count = 0;
    int[] avail_size = null;
    int[] avail_ptr = null;
    jdbm db = null;
    boolean modified = false;
    int fileptr = -1;

    jdbmBucket(jdbm jdbm2, int n, int n2) {
        this.db = jdbm2;
        this.fileptr = n;
        this.elements = new jdbmBucketElement[jdbm2.bucket_elems];
        int n3 = 0;
        while (n3 < this.elements.length) {
            this.elements[n3] = new jdbmBucketElement();
            ++n3;
        }
        this.avail_count = 0;
        this.avail_size = new int[6];
        this.avail_ptr = new int[6];
        if (n2 >= 0) {
            this.avail_count = 1;
            this.avail_size[0] = jdbm2.block_size;
            this.avail_ptr[0] = n2 * jdbm2.block_size;
        }
    }

    protected void add(int n, byte[] byArray, byte[] byArray2) throws IOException {
        if (this.count >= this.db.bucket_elems) {
            throw new RuntimeException("implementation error.");
        }
        int n2 = n % this.db.bucket_elems;
        while (true) {
            jdbmBucketElement jdbmBucketElement2 = this.elements[n2];
            if (jdbmBucketElement2.hashval == -1) {
                jdbmBucketElement2.hashval = n;
                System.arraycopy(byArray, 0, jdbmBucketElement2.keystart, 0, byArray.length <= 4 ? byArray.length : 4);
                jdbmBucketElement2.key_size = byArray.length;
                jdbmBucketElement2.data_size = byArray2.length;
                jdbmBucketElement2.fileptr = this.db.write(this, byArray, byArray2);
                this.modified = true;
                ++this.count;
                return;
            }
            n2 = (n2 + 1) % this.elements.length;
        }
    }

    protected int allocateSpace(int n) {
        int n2 = 0;
        while (n2 < this.avail_count) {
            if (this.avail_size[n2] >= n) {
                return this.fixAvailable(n2, n);
            }
            ++n2;
        }
        return -1;
    }

    private final boolean arrayEquals(byte[] byArray, byte[] byArray2) {
        if (byArray.length == byArray2.length) {
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (byArray[n2] != byArray2[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private final boolean arrayStartsWith(byte[] byArray, byte[] byArray2) {
        int n = Math.min(byArray.length, byArray2.length);
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void delete(jdbmBucketElement jdbmBucketElement2) {
        int n = jdbmBucketElement2.key_size + jdbmBucketElement2.data_size;
        if (n >= this.db.block_size || this.avail_count + 1 >= 6) {
            this.db.markAvailable(jdbmBucketElement2.fileptr, n);
        } else {
            this.markAvailable(jdbmBucketElement2.fileptr, jdbmBucketElement2.key_size + jdbmBucketElement2.data_size);
        }
        int n2 = jdbmBucketElement2.hashval % this.db.bucket_elems;
        while (this.elements[n2] != jdbmBucketElement2) {
            n2 = (n2 + 1) % this.db.bucket_elems;
        }
        jdbmBucketElement2.hashval = -1;
        --this.count;
        int n3 = n2;
        n2 = (n2 + 1) % this.db.bucket_elems;
        while (n2 != n3 && this.elements[n2].hashval != -1) {
            int n4 = this.elements[n2].hashval % this.db.bucket_elems;
            if (n3 < n2 && (n4 <= n3 || n4 > n2) || n3 > n2 && n4 <= n3 && n4 > n2) {
                this.elements[n3] = this.elements[n2];
                this.elements[n2] = new jdbmBucketElement();
                n3 = n2;
            }
            n2 = (n2 + 1) % this.db.bucket_elems;
        }
        this.modified = true;
    }

    private int fixAvailable(int n, int n2) {
        this.modified = true;
        int n3 = this.avail_ptr[n];
        int n4 = n;
        int n5 = this.avail_size[n4] - n2;
        this.avail_size[n4] = n5;
        int n6 = n5;
        int n7 = n;
        int n8 = this.avail_ptr[n7] + n2;
        this.avail_ptr[n7] = n8;
        int n9 = n8;
        this.removeAvailable(n);
        if (n6 <= 8) {
            return n3;
        }
        if (n6 >= this.db.block_size) {
            this.db.markAvailable(n9, n6);
        } else {
            this.markAvailable(n9, n6);
        }
        return n3;
    }

    protected jdbmBucketElement lookup(byte[] byArray, int n) throws IOException {
        int n2;
        int n3 = n2 = n % this.db.bucket_elems;
        do {
            byte[] byArray2;
            jdbmBucketElement jdbmBucketElement2 = this.elements[n2];
            if (jdbmBucketElement2.hashval == -1) {
                return null;
            }
            if (jdbmBucketElement2.hashval != n || !this.arrayStartsWith(byArray, jdbmBucketElement2.keystart) || !this.arrayEquals(byArray2 = this.db.readKey(jdbmBucketElement2), byArray)) continue;
            return jdbmBucketElement2;
        } while ((n2 = (n2 + 1) % this.elements.length) != n3);
        return null;
    }

    private void markAvailable(int n, int n2) {
        this.modified = true;
        int n3 = 0;
        while (n3 < this.avail_count) {
            if (this.avail_size[n3] >= n2) {
                System.arraycopy(this.avail_size, n3, this.avail_size, n3 + 1, this.avail_count - n3);
                System.arraycopy(this.avail_ptr, n3, this.avail_ptr, n3 + 1, this.avail_count - n3);
                ++this.avail_count;
                this.avail_size[n3] = n2;
                this.avail_ptr[n3] = n;
                return;
            }
            ++n3;
        }
        this.avail_size[this.avail_count] = n2;
        this.avail_ptr[this.avail_count] = n;
        ++this.avail_count;
    }

    private final void removeAvailable(int n) {
        this.modified = true;
        --this.avail_count;
        if (n == this.avail_count) {
            return;
        }
        System.arraycopy(this.avail_size, n + 1, this.avail_size, n, this.avail_count - n);
        System.arraycopy(this.avail_ptr, n + 1, this.avail_ptr, n, this.avail_count - n);
    }

    static jdbmBucket restore(DataInputStream dataInputStream, int n, jdbmBucket jdbmBucket2) throws IOException {
        jdbmBucket2.fileptr = n;
        jdbmBucket2.bits = dataInputStream.readInt();
        jdbmBucket2.count = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < jdbmBucket2.elements.length) {
            jdbmBucketElement.restore(dataInputStream, jdbmBucket2.elements[n2]);
            ++n2;
        }
        jdbmBucket2.avail_count = dataInputStream.readInt();
        int n3 = 0;
        while (n3 < jdbmBucket2.avail_size.length) {
            jdbmBucket2.avail_size[n3] = dataInputStream.readInt();
            jdbmBucket2.avail_ptr[n3] = dataInputStream.readInt();
            ++n3;
        }
        return jdbmBucket2;
    }

    void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.bits);
        dataOutputStream.writeInt(this.count);
        int n = 0;
        while (n < this.elements.length) {
            this.elements[n].save(dataOutputStream);
            ++n;
        }
        dataOutputStream.writeInt(this.avail_count);
        int n2 = 0;
        while (n2 < this.avail_size.length) {
            dataOutputStream.writeInt(this.avail_size[n2]);
            dataOutputStream.writeInt(this.avail_ptr[n2]);
            ++n2;
        }
        this.modified = false;
    }
}

