/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.dbm;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import org.w3c.tools.dbm.FastByteArrayOutputStream;
import org.w3c.tools.dbm.LRUEntry;
import org.w3c.tools.dbm.LRUList;
import org.w3c.tools.dbm.jdbmBucket;
import org.w3c.tools.dbm.jdbmBucketElement;
import org.w3c.tools.dbm.jdbmEnumerator;

public class jdbm {
    private static final int IGNORE_SIZE = 8;
    private static final boolean debug = false;
    public static final int STORE_REPLACE = 1;
    public static final int STORE_INSERT = 2;
    protected static final int BLOCK_SIZE = 1024;
    protected static final int DIR_BITS = 3;
    protected static final int CACHE_SIZE = 32;
    private static final int fsize = 36;
    int block_size = 1024;
    int dir_bits = 3;
    int dir_size = 0;
    int dir_adr = 0;
    int cache_size = 32;
    int bucket_elems = 0;
    int next_block = 0;
    int avail_count = 0;
    int avail_length = 0;
    int[] avail_size = null;
    int[] avail_ptr = null;
    File file = null;
    RandomAccessFile fd = null;
    int[] diridx = null;
    private byte[] buffer = null;
    private boolean dir_changed = false;
    private boolean header_changed = false;
    private LRUList list = null;
    private int loaded_buckets = 0;

    public jdbm(File file) throws IOException {
        boolean bl = file.exists();
        this.file = file;
        this.fd = new RandomAccessFile(file, "rw");
        this.buffer = new byte[this.block_size];
        this.list = new LRUList();
        if (bl) {
            this.fd.seek(0L);
            if (this.fd.read(this.buffer) != this.buffer.length) {
                throw new IOException("unable to restore DB header.");
            }
            this.restoreHeader(new DataInputStream(new ByteArrayInputStream(this.buffer)));
            this.fd.seek(this.dir_adr);
            byte[] byArray = new byte[this.dir_size * 4];
            this.fd.readFully(byArray);
            if (this.fd.read(this.buffer) != this.buffer.length) {
                throw new IOException("unable to restore DB directory.");
            }
            this.restoreDirectory(new DataInputStream(new ByteArrayInputStream(byArray)));
            int n = 1 << this.dir_bits;
            this.loaded_buckets = 0;
        } else {
            this.block_size = 1024;
            this.dir_bits = 3;
            this.dir_adr = this.block_size;
            this.bucket_elems = (this.block_size - 60) / 24 + 1;
            this.dir_size = 1 << this.dir_bits;
            while (this.dir_size * 4 < this.block_size) {
                this.dir_size <<= 1;
                ++this.dir_bits;
            }
            if (this.dir_size * 4 != this.block_size) {
                throw new RuntimeException("block_size can't match dir_size");
            }
            this.cache_size = 32;
            this.loaded_buckets = 1;
            this.diridx = new int[this.dir_size];
            int n = 2 * this.block_size;
            LRUEntry lRUEntry = this.list.addEntry(new jdbmBucket(this, n, 3));
            int n2 = 0;
            while (n2 < this.dir_size) {
                this.diridx[n2] = n;
                ++n2;
            }
            this.avail_length = (this.block_size - 36) / 8;
            this.avail_size = new int[this.avail_length];
            this.avail_ptr = new int[this.avail_length];
            this.avail_count = 0;
            this.next_block = 4;
            DataOutputStream dataOutputStream = null;
            dataOutputStream = new DataOutputStream(new FastByteArrayOutputStream(this.buffer));
            this.saveHeader(dataOutputStream);
            this.fd.seek(0L);
            this.fd.write(this.buffer);
            dataOutputStream = new DataOutputStream(new FastByteArrayOutputStream(this.buffer));
            this.saveDirectory(dataOutputStream);
            this.fd.seek(this.dir_adr);
            this.fd.write(this.buffer);
            dataOutputStream = new DataOutputStream(new FastByteArrayOutputStream(this.buffer));
            lRUEntry.bucket.save(dataOutputStream);
            this.fd.seek(2 * this.block_size);
            this.fd.write(this.buffer);
        }
    }

    protected int allocateSpace(int n) {
        int n2;
        this.header_changed = true;
        this.trace("allocateSpace: avail_count=" + this.avail_count);
        int n3 = 0;
        while (n3 < this.avail_count) {
            if (this.avail_size[n3] >= n) {
                return this.fixAvailable(n3, n);
            }
            ++n3;
        }
        int n4 = this.next_block++;
        int n5 = n4 * this.block_size;
        while ((n2 = (this.next_block - n4) * this.block_size) < n) {
            ++this.next_block;
        }
        int n6 = n2 - n;
        if (n6 >= 8) {
            this.markAvailable(n5 + n, n6);
        }
        return n5;
    }

    public void close() throws IOException {
        this.save();
        this.fd.close();
    }

    public boolean delete(String string) throws IOException {
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, byArray.length, byArray, 0);
        return this.delete(byArray);
    }

    public boolean delete(byte[] byArray) throws IOException {
        int n = jdbm.hash(byArray);
        jdbmBucket jdbmBucket2 = this.lookupBucket(n);
        jdbmBucketElement jdbmBucketElement2 = jdbmBucket2.lookup(byArray, n);
        if (jdbmBucketElement2 != null) {
            jdbmBucket2.delete(jdbmBucketElement2);
            return true;
        }
        return false;
    }

    public Enumeration elements() {
        return new jdbmEnumerator(this, false, -1);
    }

    int fixAvailable(int n, int n2) {
        this.header_changed = true;
        int n3 = this.avail_ptr[n];
        int n4 = n;
        int n5 = this.avail_size[n4] - n2;
        this.avail_size[n4] = n5;
        int n6 = n5;
        int n7 = n;
        int n8 = this.avail_ptr[n7] + n2;
        this.avail_ptr[n7] = n8;
        int n9 = n8;
        this.removeAvailable(n);
        if (n6 <= 8) {
            return n3;
        }
        this.markAvailable(n9, n6);
        return n3;
    }

    public static byte[] getBytes(String string) {
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, byArray.length, byArray, 0);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean getNextBucket(jdbmEnumerator jdbmEnumerator2) throws IOException {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        if (jdbmEnumerator2.didx < 0) {
            n3 = 0;
            n2 = -1;
            n = this.diridx[0];
        } else {
            if (jdbmEnumerator2.didx + 1 >= this.dir_size) {
                return false;
            }
            n3 = jdbmEnumerator2.didx;
            n2 = this.diridx[n3++];
            n = this.diridx[n3];
        }
        while (n == n2 && n3 < this.dir_size) {
            n = this.diridx[n3 + 1 == this.dir_size ? n3++ : ++n3];
        }
        if (n3 >= this.dir_size) {
            return false;
        }
        LRUEntry lRUEntry = this.list.lookupBucket(n);
        if (lRUEntry == null) {
            lRUEntry = this.loadBucket(n);
        }
        this.list.notifyUses(lRUEntry);
        jdbmEnumerator2.bucket = lRUEntry.bucket;
        jdbmEnumerator2.didx = n3;
        jdbmEnumerator2.bidx = 0;
        return true;
    }

    private static final int hash(byte[] byArray) {
        int n = 596579247 * byArray.length;
        int n2 = 0;
        while (n2 < byArray.length) {
            n = n + (byArray[n2] << n2 * 5 % 24) & Integer.MAX_VALUE;
            ++n2;
        }
        return 1103515243 * n + 12345 & Integer.MAX_VALUE;
    }

    public Enumeration keys() {
        return new jdbmEnumerator(this, true, -1);
    }

    protected synchronized LRUEntry loadBucket(int n) throws IOException {
        jdbmBucket jdbmBucket2 = null;
        if (this.loaded_buckets >= this.cache_size) {
            this.trace("*** removing bucket from cache !");
            jdbmBucket2 = this.unloadBucket();
        } else {
            this.trace("*** filling cache.");
            ++this.loaded_buckets;
            jdbmBucket2 = new jdbmBucket(this, n, -1);
        }
        this.fd.seek(n);
        if (this.fd.read(this.buffer, 0, this.buffer.length) != this.buffer.length) {
            throw new IOException("invalid read length.");
        }
        jdbmBucket.restore(new DataInputStream(new ByteArrayInputStream(this.buffer)), n, jdbmBucket2);
        return this.list.addEntry(jdbmBucket2);
    }

    public byte[] lookup(String string) throws IOException {
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, byArray.length, byArray, 0);
        return this.lookup(byArray);
    }

    public byte[] lookup(byte[] byArray) throws IOException {
        int n = jdbm.hash(byArray);
        jdbmBucket jdbmBucket2 = this.lookupBucket(n);
        jdbmBucketElement jdbmBucketElement2 = jdbmBucket2.lookup(byArray, n);
        return jdbmBucketElement2 != null ? this.readData(jdbmBucketElement2) : null;
    }

    private synchronized jdbmBucket lookupBucket(int n) throws IOException {
        int n2 = n >>> 31 - this.dir_bits;
        int n3 = this.diridx[n2];
        int n4 = n3 / this.block_size;
        LRUEntry lRUEntry = this.list.lookupBucket(n3);
        if (lRUEntry == null) {
            lRUEntry = this.loadBucket(n3);
        }
        this.list.notifyUses(lRUEntry);
        return lRUEntry.bucket;
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File(stringArray[0]);
        jdbm jdbm2 = new jdbm(file);
        int n = 1;
        while (n < stringArray.length) {
            Object object;
            String string;
            Object object2;
            if (stringArray[n].equals("-clean")) {
                jdbm2.reorganize(true);
            } else if (stringArray[n].equals("-stat")) {
                jdbm2.printHeader(System.out);
                jdbm2.printAvail(System.out);
            } else if (stringArray[n].equals("-add")) {
                byte[] byArray = jdbm.getBytes(stringArray[n + 1]);
                object2 = jdbm.getBytes(stringArray[n + 2]);
                jdbm2.store(byArray, (byte[])object2, 2);
                n += 3;
            } else if (stringArray[n].equals("-get")) {
                byte[] byArray = jdbm.getBytes(stringArray[n + 1]);
                object2 = jdbm2.lookup(byArray);
                if (object2 == null) {
                    System.out.println("not found.");
                } else {
                    System.out.println(new String((byte[])object2, 0, 0, ((byte[])object2).length));
                }
                n += 2;
            } else if (stringArray[n].equals("-nadd")) {
                int n2 = Integer.parseInt(stringArray[n + 1]);
                object2 = stringArray[n + 2];
                while (--n2 >= 0) {
                    string = String.valueOf(object2) + "-" + n2;
                    object = String.valueOf(object2) + "-value-for-" + n2;
                    System.out.println(String.valueOf(string) + "=" + (String)object);
                    jdbm2.store(jdbm.getBytes(string), jdbm.getBytes((String)object), 2);
                }
                n += 3;
            } else if (stringArray[n].equals("-nget")) {
                int n3 = Integer.parseInt(stringArray[n + 1]);
                object2 = stringArray[n + 2];
                while (--n3 >= 0) {
                    string = String.valueOf(object2) + "-" + n3;
                    object = jdbm2.lookup(jdbm.getBytes(string));
                    if (object == null) {
                        System.out.println("*** not found.");
                        continue;
                    }
                    System.out.println(String.valueOf(string) + "=" + new String((byte[])object, 0, 0, ((Object)object).length));
                }
                n += 3;
            } else if (stringArray[n].equals("-del")) {
                if (jdbm2.delete(jdbm.getBytes(stringArray[n + 1]))) {
                    System.out.println("deletion succesfull.");
                } else {
                    System.out.println("element not found.");
                }
                n += 2;
            } else {
                System.out.println("[-add <key> <val>] [-get <key>]");
                System.exit(1);
            }
            ++n;
        }
        jdbm2.save();
    }

    void markAvailable(int n, int n2) {
        if (this.avail_count + 1 >= this.avail_size.length) {
            return;
        }
        this.header_changed = true;
        int n3 = 0;
        while (n3 < this.avail_count) {
            if (this.avail_size[n3] >= n2) {
                System.arraycopy(this.avail_size, n3, this.avail_size, n3 + 1, this.avail_count - n3);
                System.arraycopy(this.avail_ptr, n3, this.avail_ptr, n3 + 1, this.avail_count - n3);
                ++this.avail_count;
                this.avail_size[n3] = n2;
                this.avail_ptr[n3] = n;
                return;
            }
            ++n3;
        }
        this.avail_size[this.avail_count] = n2;
        this.avail_ptr[this.avail_count] = n;
        ++this.avail_count;
    }

    public void printAvail(PrintStream printStream) {
        printStream.println("avail_count=" + this.avail_count + "/" + this.avail_size.length);
        int n = 0;
        while (n < this.avail_count) {
            printStream.println("\tsize=" + this.avail_size[n] + " ,ptr=" + this.avail_ptr[n]);
            ++n;
        }
    }

    public void printHeader(PrintStream printStream) {
        printStream.println("Options for " + this.file.getAbsolutePath() + ":");
        printStream.println("\tblock_size   = " + this.block_size);
        printStream.println("\tdir_bits     = " + this.dir_bits);
        printStream.println("\tdir_size     = " + this.dir_size);
        printStream.println("\tdir_adr      = " + this.dir_adr);
        printStream.println("\tcache_size   = " + this.cache_size);
        printStream.println("\tdir_size     = " + (1 << this.dir_bits));
        printStream.println("\tbucket_elems = " + this.bucket_elems);
        printStream.println("\tnext_block   = " + this.next_block);
        printStream.println("\tavail_count  = " + this.avail_count);
        printStream.println("\tavail_length = " + this.avail_length);
    }

    byte[] readData(jdbmBucketElement jdbmBucketElement2) throws IOException {
        byte[] byArray = new byte[jdbmBucketElement2.data_size];
        this.fd.seek(jdbmBucketElement2.fileptr + jdbmBucketElement2.key_size);
        if (this.fd.read(byArray) != jdbmBucketElement2.data_size) {
            throw new RuntimeException("invalid data read.");
        }
        return byArray;
    }

    byte[] readKey(jdbmBucketElement jdbmBucketElement2) throws IOException {
        this.trace("read: @" + jdbmBucketElement2.fileptr);
        byte[] byArray = new byte[jdbmBucketElement2.key_size];
        this.fd.seek(jdbmBucketElement2.fileptr);
        if (this.fd.read(byArray) != jdbmBucketElement2.key_size) {
            throw new RuntimeException("invalid key read.");
        }
        return byArray;
    }

    final void removeAvailable(int n) {
        this.header_changed = true;
        --this.avail_count;
        if (n == this.avail_count) {
            return;
        }
        System.arraycopy(this.avail_size, n + 1, this.avail_size, n, this.avail_count - n);
        System.arraycopy(this.avail_ptr, n + 1, this.avail_ptr, n, this.avail_count - n);
    }

    public jdbm reorganize(boolean bl) {
        jdbm jdbm2;
        block17: {
            Object object2;
            Enumeration enumeration = this.keys();
            int n = 0;
            File file = new File(this.file.getParent(), String.valueOf(this.file.getName()) + ".tmp");
            jdbm jdbm3 = null;
            jdbm2 = null;
            long l = -1L;
            try {
                try {
                    this.save();
                    jdbm3 = new jdbm(file);
                    if (bl) {
                        System.out.println("using temp file: " + file);
                        l = System.currentTimeMillis();
                    }
                    while (enumeration.hasMoreElements()) {
                        object2 = (byte[])enumeration.nextElement();
                        byte[] byArray = this.lookup((byte[])object2);
                        if (byArray != null) {
                            jdbm3.store((byte[])object2, byArray, 1);
                        } else if (bl) {
                            System.out.println("no value for [" + new String((byte[])object2) + "]");
                        }
                        if (!bl || ++n % 100 != 0) continue;
                        System.out.println(String.valueOf(n) + " elements reindexed.");
                    }
                    jdbm3.save();
                    if (bl) {
                        System.out.println("reorganization done (" + (System.currentTimeMillis() - l) + "ms)");
                    }
                }
                catch (Exception exception) {
                    file.delete();
                    file = null;
                    exception.printStackTrace();
                }
                Object var10_12 = null;
                if (file == null) break block17;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (file != null) {
                    try {
                        jdbm3.fd.close();
                        this.fd.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    this.file.delete();
                    file.renameTo(this.file);
                    try {
                        jdbm2 = new jdbm(this.file);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                throw throwable;
            }
            try {
                jdbm3.fd.close();
                this.fd.close();
            }
            catch (IOException iOException) {
                object2 = iOException;
                object2.printStackTrace();
            }
            this.file.delete();
            file.renameTo(this.file);
            try {
                jdbm2 = new jdbm(this.file);
            }
            catch (IOException object2) {
                object2.printStackTrace();
            }
        }
        return jdbm2;
    }

    private void restoreDirectory(DataInputStream dataInputStream) throws IOException {
        this.diridx = new int[this.dir_size];
        int n = 0;
        while (n < this.diridx.length) {
            this.diridx[n] = dataInputStream.readInt();
            ++n;
        }
    }

    private void restoreHeader(DataInputStream dataInputStream) throws IOException {
        this.block_size = dataInputStream.readInt();
        this.dir_bits = dataInputStream.readInt();
        this.dir_size = dataInputStream.readInt();
        this.dir_adr = dataInputStream.readInt();
        this.cache_size = dataInputStream.readInt();
        this.bucket_elems = dataInputStream.readInt();
        this.next_block = dataInputStream.readInt();
        this.avail_length = dataInputStream.readInt();
        this.avail_count = dataInputStream.readInt();
        this.avail_size = new int[this.avail_length];
        this.avail_ptr = new int[this.avail_length];
        int n = 0;
        while (n < this.avail_length) {
            this.avail_size[n] = dataInputStream.readInt();
            this.avail_ptr[n] = dataInputStream.readInt();
            ++n;
        }
    }

    public void save() throws IOException {
        Object object;
        if (this.header_changed) {
            this.trace("saving header.");
            object = new DataOutputStream(new FastByteArrayOutputStream(this.buffer));
            this.saveHeader((DataOutputStream)object);
            this.fd.seek(0L);
            this.fd.write(this.buffer);
            this.header_changed = false;
        }
        if (this.dir_changed) {
            this.trace("saving directory.");
            object = new byte[this.dir_size * 4];
            DataOutputStream dataOutputStream = new DataOutputStream(new FastByteArrayOutputStream((byte[])object));
            this.saveDirectory(dataOutputStream);
            this.fd.seek(this.dir_adr);
            this.fd.write((byte[])object);
            this.dir_changed = false;
        }
        this.list.saveModified(this);
    }

    void saveBucket(jdbmBucket jdbmBucket2) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new FastByteArrayOutputStream(this.buffer));
        jdbmBucket2.save(dataOutputStream);
        this.fd.seek(jdbmBucket2.fileptr);
        this.fd.write(this.buffer);
    }

    private void saveDirectory(DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        while (n < this.diridx.length) {
            dataOutputStream.writeInt(this.diridx[n]);
            ++n;
        }
    }

    private void saveHeader(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.block_size);
        dataOutputStream.writeInt(this.dir_bits);
        dataOutputStream.writeInt(this.dir_size);
        dataOutputStream.writeInt(this.dir_adr);
        dataOutputStream.writeInt(this.cache_size);
        dataOutputStream.writeInt(this.bucket_elems);
        dataOutputStream.writeInt(this.next_block);
        dataOutputStream.writeInt(this.avail_length);
        dataOutputStream.writeInt(this.avail_count);
        int n = 0;
        while (n < this.avail_length) {
            dataOutputStream.writeInt(this.avail_size[n]);
            dataOutputStream.writeInt(this.avail_ptr[n]);
            ++n;
        }
    }

    private void splitBucket(int n, jdbmBucket jdbmBucket2) throws IOException {
        jdbmBucket jdbmBucket3 = null;
        this.trace("split bucket: " + jdbmBucket2.fileptr);
        while (jdbmBucket2.count == this.bucket_elems) {
            int n2;
            int n3;
            int n4;
            int n5;
            this.list.removeBucket(jdbmBucket2);
            --this.loaded_buckets;
            this.markAvailable(jdbmBucket2.fileptr, this.block_size);
            int n6 = this.allocateSpace(this.block_size);
            int n7 = this.allocateSpace(this.block_size);
            jdbmBucket jdbmBucket4 = new jdbmBucket(this, n6, -1);
            jdbmBucket jdbmBucket5 = new jdbmBucket(this, n7, -1);
            LRUEntry lRUEntry = this.list.addEntry(jdbmBucket4);
            LRUEntry lRUEntry2 = this.list.addEntry(jdbmBucket5);
            this.trace("splited b0=" + n6);
            this.trace("splited b1=" + n7);
            this.loaded_buckets += 2;
            jdbmBucket4.bits = n5 = jdbmBucket2.bits + 1;
            jdbmBucket5.bits = n5;
            if (this.dir_bits == jdbmBucket2.bits) {
                this.dir_size <<= 1;
                this.dir_adr = this.allocateSpace(this.dir_size * 4);
                int[] nArray = new int[this.dir_size];
                n4 = 0;
                while (n4 < this.dir_size / 2) {
                    nArray[2 * n4] = this.diridx[n4];
                    nArray[2 * n4 + 1] = this.diridx[n4];
                    ++n4;
                }
                this.diridx = nArray;
                this.dir_bits = n5;
                this.dir_changed = true;
            }
            int n8 = 0;
            while (n8 < this.bucket_elems) {
                jdbmBucketElement jdbmBucketElement2 = jdbmBucket2.elements[n8];
                n3 = jdbmBucketElement2.hashval >> 31 - n5 & 1;
                n2 = jdbmBucketElement2.hashval % this.bucket_elems;
                jdbmBucket3 = n3 == 0 ? jdbmBucket4 : jdbmBucket5;
                while (jdbmBucket3.elements[n2].hashval != -1) {
                    n2 = (n2 + 1) % this.bucket_elems;
                }
                jdbmBucket3.elements[n2] = jdbmBucketElement2;
                ++jdbmBucket3.count;
                ++n8;
            }
            jdbmBucket5.avail_count = jdbmBucket2.avail_count;
            jdbmBucket5.avail_size = jdbmBucket2.avail_size;
            jdbmBucket5.avail_ptr = jdbmBucket2.avail_ptr;
            n4 = n >>> 31 - this.dir_bits;
            n3 = n4 >> this.dir_bits - n5 | 1;
            n2 = n3 + 1 << this.dir_bits - n5;
            int n9 = (n3 <<= this.dir_bits - n5) - (n2 - n3);
            this.trace("updating dir from " + n9 + " to " + n3);
            int n10 = n9;
            while (n10 < n3) {
                this.diridx[n10] = n6;
                ++n10;
            }
            this.trace("updating dir from " + n3 + " to " + n2);
            int n11 = n3;
            while (n11 < n2) {
                this.diridx[n11] = n7;
                ++n11;
            }
            jdbmBucket4.modified = true;
            jdbmBucket5.modified = true;
            this.dir_changed = true;
            this.saveBucket(jdbmBucket4);
            this.saveBucket(jdbmBucket5);
            jdbmBucket2 = this.lookupBucket(n);
        }
    }

    public void store(byte[] byArray, byte[] byArray2, int n) throws IOException {
        int n2 = jdbm.hash(byArray);
        jdbmBucket jdbmBucket2 = this.lookupBucket(n2);
        jdbmBucketElement jdbmBucketElement2 = jdbmBucket2.lookup(byArray, n2);
        if (jdbmBucketElement2 != null) {
            if (n == 1) {
                jdbmBucket2.delete(jdbmBucketElement2);
            } else {
                return;
            }
        }
        if (jdbmBucket2.count >= this.bucket_elems) {
            this.splitBucket(n2, jdbmBucket2);
            jdbmBucket2 = this.lookupBucket(n2);
        }
        jdbmBucket2.add(n2, byArray, byArray2);
    }

    protected final void trace(String string) {
    }

    protected synchronized jdbmBucket unloadBucket() throws IOException {
        LRUEntry lRUEntry = this.list.getLRU();
        if (lRUEntry == null) {
            return null;
        }
        jdbmBucket jdbmBucket2 = lRUEntry.bucket;
        if (jdbmBucket2.modified) {
            this.saveBucket(jdbmBucket2);
        }
        --this.loaded_buckets;
        return jdbmBucket2;
    }

    protected int write(jdbmBucket jdbmBucket2, byte[] byArray, byte[] byArray2) throws IOException {
        int n = byArray.length + byArray2.length;
        int n2 = jdbmBucket2.allocateSpace(n);
        if (n2 < 0) {
            n2 = this.allocateSpace(n);
        }
        this.trace("write: @" + n2);
        this.fd.seek(n2);
        this.fd.write(byArray);
        this.fd.write(byArray2);
        return n2;
    }
}

