/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.dbm;

import java.io.IOException;
import org.w3c.tools.dbm.LRUEntry;
import org.w3c.tools.dbm.jdbm;
import org.w3c.tools.dbm.jdbmBucket;

class LRUList {
    LRUEntry head = null;
    LRUEntry tail = null;

    LRUList() {
    }

    protected synchronized LRUEntry addEntry(jdbmBucket jdbmBucket2) {
        LRUEntry lRUEntry = new LRUEntry(jdbmBucket2);
        lRUEntry.next = this.head;
        if (this.head != null) {
            this.head.prev = lRUEntry;
        }
        lRUEntry.prev = null;
        this.head = lRUEntry;
        if (this.tail == null) {
            this.tail = this.head;
        }
        return lRUEntry;
    }

    private final synchronized void atTop(LRUEntry lRUEntry) {
        if (lRUEntry == this.head) {
            return;
        }
        this.removeEntry(lRUEntry);
        lRUEntry.next = this.head;
        lRUEntry.prev = null;
        this.head.prev = lRUEntry;
        this.head = lRUEntry;
    }

    protected LRUEntry getLRU() {
        LRUEntry lRUEntry = this.tail;
        if (lRUEntry != null) {
            this.removeEntry(lRUEntry);
        }
        return lRUEntry;
    }

    protected synchronized LRUEntry lookupBucket(int n) {
        LRUEntry lRUEntry = this.head;
        while (lRUEntry != null) {
            if (lRUEntry.bucket.fileptr == n) {
                return lRUEntry;
            }
            lRUEntry = lRUEntry.next;
        }
        return null;
    }

    protected final void notifyUses(LRUEntry lRUEntry) {
        this.atTop(lRUEntry);
    }

    protected synchronized void removeBucket(jdbmBucket jdbmBucket2) {
        LRUEntry lRUEntry = this.head;
        while (lRUEntry != null) {
            if (lRUEntry.bucket == jdbmBucket2) {
                this.removeEntry(lRUEntry);
                return;
            }
            lRUEntry = lRUEntry.next;
        }
    }

    synchronized void removeEntry(LRUEntry lRUEntry) {
        if (lRUEntry == this.head) {
            this.head = lRUEntry.next;
            lRUEntry.next = null;
            lRUEntry.prev = null;
            if (this.tail == lRUEntry) {
                this.tail = null;
            }
        } else if (lRUEntry == this.tail) {
            this.tail = lRUEntry.prev;
            this.tail.next = null;
            lRUEntry.next = null;
            lRUEntry.prev = null;
        } else {
            lRUEntry.prev.next = lRUEntry.next;
            lRUEntry.next.prev = lRUEntry.prev;
            lRUEntry.next = null;
            lRUEntry.prev = null;
        }
    }

    protected synchronized void saveModified(jdbm jdbm2) throws IOException {
        LRUEntry lRUEntry = this.head;
        while (lRUEntry != null) {
            if (lRUEntry.bucket.modified) {
                jdbm2.saveBucket(lRUEntry.bucket);
            }
            lRUEntry = lRUEntry.next;
        }
    }
}

