/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.status;

import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;

public class ThreadStatFrame
extends HTTPFrame {
    protected static Integer REFRESH_DEFAULT = new Integer(5);
    protected static int ATTR_REFRESH = -1;
    Runtime runtime = null;

    static {
        IntegerAttribute integerAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.status.ThreadStatFrame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        integerAttribute = new IntegerAttribute("refresh", new Integer(5), 2);
        ATTR_REFRESH = AttributeRegistry.registerAttribute(clazz, integerAttribute);
    }

    protected Reply dumpThread(Request request) throws HTTPException {
        int n = Thread.activeCount();
        Thread[] threadArray = new Thread[n];
        Thread.enumerate(threadArray);
        String string = request.getQueryString();
        Thread thread = null;
        int n2 = 0;
        while (n2 < n) {
            if (threadArray[n2].getName().equals(string)) {
                thread = threadArray[n2];
                break;
            }
            ++n2;
        }
        if (thread == null) {
            Reply reply = request.makeReply(404);
            reply.setContent("Thread " + string + " not found.");
            return reply;
        }
        thread.stop();
        return this.listThreads(request);
    }

    public Reply get(Request request) throws HTTPException {
        if (request.hasQueryString()) {
            return this.dumpThread(request);
        }
        return this.listThreads(request);
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        this.runtime = Runtime.getRuntime();
    }

    public Reply listThreads(Request request) {
        Object object;
        int n = Thread.activeCount();
        HtmlGenerator htmlGenerator = new HtmlGenerator("Thread status");
        htmlGenerator.meta("Refresh", this.getValue(ATTR_REFRESH, (Object)REFRESH_DEFAULT).toString());
        this.addStyleSheet(htmlGenerator);
        Thread[] threadArray = new Thread[n];
        Thread.enumerate(threadArray);
        htmlGenerator.append("<h1>Thread dump</h1>");
        htmlGenerator.append("<ul>");
        String string = this.getResource().getIdentifier();
        int n2 = 0;
        while (n2 < n) {
            object = threadArray[n2].getName();
            htmlGenerator.append("<li><a href=\"" + string + "?" + (String)object + "\">" + (String)object + "</a>" + (threadArray[n2].isDaemon() ? "D " : "  ") + (threadArray[n2].isAlive() ? "R " : "  "));
            ++n2;
        }
        htmlGenerator.append("</ul>");
        htmlGenerator.append("<p>To kill a thread, add a <b>?</b><em>thread-name</em> to the current URL.</p>");
        htmlGenerator.append("<h2>Misc informations</h2>");
        htmlGenerator.append("<p>Total free memory: " + this.runtime.freeMemory());
        htmlGenerator.append("<p>Toal memory      : " + this.runtime.totalMemory());
        htmlGenerator.close();
        object = request.makeReply(200);
        ((Reply)object).setStream(htmlGenerator);
        return object;
    }

    public void registerResource(FramedResource framedResource) {
        super.registerOtherResource(framedResource);
    }
}

