/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.status;

import java.util.Date;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.http.httpdStatistics;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;

public class StatisticsFrame
extends HTTPFrame {
    protected static Integer REFRESH_DEFAULT = new Integer(5);
    protected static int ATTR_REFRESH = -1;
    static String time_tbl;
    static String thread_tbl;

    static {
        IntegerAttribute integerAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.status.StatisticsFrame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        integerAttribute = new IntegerAttribute("refresh", new Integer(5), 2);
        ATTR_REFRESH = AttributeRegistry.registerAttribute(clazz, integerAttribute);
        time_tbl = "<p>Request processing times:<table border width=50%><tr><th align=\"center\">min<th align=\"center\">avg<th align=\"center\">max</tr><tr>";
        thread_tbl = "<p>Thread counts:<table border width=50%><tr><th align=\"center\">free<th align=\"center\">idle<th align=\"center\">total</tr><tr>";
    }

    public Reply get(Request request) {
        HtmlGenerator htmlGenerator = new HtmlGenerator("Statistics");
        htmlGenerator.meta("Refresh", this.getValue(ATTR_REFRESH, (Object)REFRESH_DEFAULT).toString());
        this.addStyleSheet(htmlGenerator);
        httpdStatistics httpdStatistics2 = ((httpd)this.getServer()).getStatistics();
        htmlGenerator.append("<h1>Server statistics</h1>");
        long l = httpdStatistics2.getStartTime();
        long l2 = (System.currentTimeMillis() - l) / 1000L;
        htmlGenerator.append("<p>Your server was started on ");
        htmlGenerator.append(new Date(l).toString());
        long l3 = l2 / 86400L;
        long l4 = l2 % 86400L;
        long l5 = l4 / 3600L;
        long l6 = l4 % 3600L;
        long l7 = l6 / 60L;
        long l8 = l6 % 60L;
        htmlGenerator.append("<p>It has now been running for " + l3 + " days, " + l5 + " hours, " + l7 + " minutes and " + l8 + " seconds.");
        htmlGenerator.append("<ul><li>hits:", Long.toString(httpdStatistics2.getHitCount()));
        htmlGenerator.append("<li>bytes:", Long.toString(httpdStatistics2.getEmittedBytes()));
        htmlGenerator.append("</ul>");
        htmlGenerator.append(time_tbl);
        htmlGenerator.append("<th align=\"center\">", Long.toString(httpdStatistics2.getMinRequestTime()), " ms");
        htmlGenerator.append("<th align=\"center\">", Long.toString(httpdStatistics2.getMeanRequestTime()), " ms");
        htmlGenerator.append("<th align=\"center\">", Long.toString(httpdStatistics2.getMaxRequestTime()), " ms");
        htmlGenerator.append("</table>");
        htmlGenerator.append(thread_tbl);
        htmlGenerator.append("<th align=\"center\">", Integer.toString(httpdStatistics2.getFreeThreadCount()));
        htmlGenerator.append("<th align=\"center\">", Integer.toString(httpdStatistics2.getIdleThreadCount()));
        htmlGenerator.append("<th align=\"center\">", Integer.toString(httpdStatistics2.getTotalThreadCount()));
        htmlGenerator.append("</table>");
        htmlGenerator.append("<p>Current load:" + httpdStatistics2.getServerLoad());
        Reply reply = request.makeReply(200);
        reply.setStream(htmlGenerator);
        return reply;
    }

    public void registerResource(FramedResource framedResource) {
        super.registerOtherResource(framedResource);
    }
}

