/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.ssi;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Dictionary;
import java.util.Vector;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.ssi.DateMaximizer;
import org.w3c.jigsaw.ssi.DateMinimizer;
import org.w3c.jigsaw.ssi.IntAdder;
import org.w3c.jigsaw.ssi.IntMaximizer;
import org.w3c.jigsaw.ssi.Merger;
import org.w3c.jigsaw.ssi.SSIException;
import org.w3c.jigsaw.ssi.SSIStream;
import org.w3c.jigsaw.ssi.Segment;
import org.w3c.jigsaw.ssi.SegmentArrayAttribute;
import org.w3c.jigsaw.ssi.commands.CommandRegistry;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.ClassAttribute;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.event.AttributeChangedEvent;
import org.w3c.util.ArrayDictionary;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpReplyMessage;

public class SSIFrame
extends HTTPFrame {
    public static final boolean debug = false;
    private static int ATTR_SEGMENTS = -1;
    private static int ATTR_UNPARSED_SIZE = -1;
    private static int ATTR_REGISTRY_CLASS = -1;
    private static int ATTR_MAX_DEPTH = -1;
    private static int ATTR_SECURE = -1;
    private CommandRegistry commReg = null;
    private Class regClass = null;
    private static Dictionary regs = new ArrayDictionary(5);
    private static byte[] startIncrements = new byte[128];
    private static byte[] endIncrements = new byte[128];
    private static byte[] startPat = new byte[]{60, 33, 45, 45, 35};
    private static byte[] endPat = new byte[]{45, 45, 62};
    private static final String emptyString = "";
    protected Dictionary vars = null;
    public static final String STATE_DEPTH = "org.w3c.jigsaw.ssi.SSIResource.depth";
    public static final String STATE_VARIABLES = "org.w3c.jigsaw.ssi.SSIResource.variables";
    private boolean cacheReplies = true;
    private static final int[] mergeHeaders = new int[]{HttpReplyMessage.H_AGE, HttpEntityMessage.H_CONTENT_LENGTH, HttpEntityMessage.H_EXPIRES, HttpEntityMessage.H_LAST_MODIFIED};
    private static final Merger[] mergers = new Merger[]{new IntMaximizer(), new IntAdder(), new DateMinimizer(), new DateMaximizer()};

    static {
        int n = 0;
        while (n < 128) {
            SSIFrame.startIncrements[n] = 5;
            SSIFrame.endIncrements[n] = 3;
            ++n;
        }
        SSIFrame.startIncrements[60] = 4;
        SSIFrame.startIncrements[33] = 3;
        SSIFrame.startIncrements[45] = 1;
        SSIFrame.endIncrements[45] = 1;
        Attribute attribute = null;
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.ssi.SSIFrame");
            clazz2 = Class.forName("org.w3c.jigsaw.ssi.commands.DefaultCommandRegistry");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        attribute = new IntegerAttribute("maxDepth", new Integer(10), 2);
        ATTR_MAX_DEPTH = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new BooleanAttribute("secure", Boolean.TRUE, 2);
        ATTR_SECURE = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new SegmentArrayAttribute("segments", null, 1);
        ATTR_SEGMENTS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new IntegerAttribute("unparsedSize", null, 1);
        ATTR_UNPARSED_SIZE = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new ClassAttribute("registryClass", clazz2, 2);
        ATTR_REGISTRY_CLASS = AttributeRegistry.registerAttribute(clazz, attribute);
    }

    public void attributeChanged(AttributeChangedEvent attributeChangedEvent) {
        super.attributeChanged(attributeChangedEvent);
        String string = attributeChangedEvent.getAttribute().getName();
        if (string.equals("file-stamp") || string.equals("file-length")) {
            this.setValue(ATTR_SEGMENTS, null);
        }
    }

    public static final boolean byteArrayNEquals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n2 - n;
        int n5 = n3 + n;
        int n6 = n;
        while (n6 < n5) {
            if (byArray[n6] != byArray2[n6 + n4]) {
                return false;
            }
            ++n6;
        }
        return true;
    }

    protected boolean cacheReplies() {
        return this.cacheReplies;
    }

    public final Reply createCommandReply(Request request, int n) {
        return this.createDefaultReply(request, n);
    }

    public final Reply createDefaultReply(Request request, int n) {
        Reply reply = super.createDefaultReply(request, n);
        reply.setHeaderValue(HttpEntityMessage.H_LAST_MODIFIED, null);
        reply.setKeepConnection(false);
        return reply;
    }

    protected void doNotCacheReply() {
        this.cacheReplies = false;
    }

    private CommandRegistry fetchRegistry(Class clazz) throws SSIException {
        try {
            CommandRegistry commandRegistry = (CommandRegistry)regs.get(clazz);
            if (commandRegistry != null) {
                return commandRegistry;
            }
            commandRegistry = (CommandRegistry)clazz.newInstance();
            regs.put(clazz, commandRegistry);
            return commandRegistry;
        }
        catch (Exception exception) {
            throw new SSIException("Cannot fetch command registry: " + exception.getMessage());
        }
    }

    protected Reply getFileResource(Request request) throws ProtocolException, ResourceException {
        Reply reply = this.handle(request);
        return reply != null ? reply : super.getFileResource(request);
    }

    public long getLastModified() {
        long l = super.getLastModified();
        return l - l % 1000L;
    }

    private final Segment[] getSegments() {
        return (Segment[])this.getValue(ATTR_SEGMENTS, null);
    }

    private final int getUnparsedSize() {
        return this.getInt(ATTR_UNPARSED_SIZE, -1);
    }

    public Reply handle(Request request) throws ProtocolException {
        if (this.fresource == null) {
            return null;
        }
        this.fresource.checkContent();
        Integer n = (Integer)request.getState(STATE_DEPTH);
        if (n == null) {
            n = new Integer(0);
        }
        boolean bl = false;
        Segment[] segmentArray = this.getSegments();
        if (segmentArray == null) {
            this.parseFirstTime();
            segmentArray = this.getSegments();
            if (segmentArray == null) {
                return null;
            }
        }
        Reply reply = null;
        try {
            this.updateRegistry();
            this.vars = (Dictionary)request.getState(STATE_VARIABLES);
            this.vars = this.commReg.initVariables(this, request, this.vars);
            this.vars.put("secure", this.getValue(ATTR_SECURE, (Object)Boolean.TRUE));
            this.vars.put("maxDepth", this.getValue(ATTR_MAX_DEPTH, (Object)new Integer(10)));
            this.vars.put("depth", n);
            this.vars.put("registry", this.commReg);
            reply = this.createDefaultReply(request, 200);
            Reply reply2 = this.createDefaultReply(request, 200);
            int n2 = this.getUnparsedSize();
            if (n2 == -1) {
                reply.setHeaderValue(HttpEntityMessage.H_CONTENT_LENGTH, null);
            } else {
                reply.setContentLength(n2);
            }
            reply2.setHeaderValue(HttpEntityMessage.H_CONTENT_LENGTH, null);
            long l = request.getIfModifiedSince();
            long l2 = this.fresource.getFileStamp();
            if (l != -1L && l2 != -1L && l2 <= l) {
                reply.setStatus(304);
                reply2.setStatus(304);
            }
            if (l2 != -1L) {
                reply2.setLastModified(l2);
            }
            Reply[] replyArray = new Reply[segmentArray.length];
            int n3 = 0;
            while (n3 < segmentArray.length) {
                if (!segmentArray[n3].isUnparsed()) {
                    replyArray[n3] = segmentArray[n3].init(this, request, this.vars, this.commReg, n3);
                    this.merge(reply, replyArray[n3] != null ? replyArray[n3] : reply2);
                }
                ++n3;
            }
            switch (reply.getStatus()) {
                default: {
                    reply.setStream(new SSIStream(this.cacheReplies(), segmentArray, replyArray, new RandomAccessFile(this.fresource.getFile(), "r")));
                }
                case 204: 
                case 304: 
            }
            reply.setDate(System.currentTimeMillis());
            return reply;
        }
        catch (SSIException sSIException) {
            reply = this.createDefaultReply(request, 500);
            reply.setContent("SSIFrame is misconfigured: " + sSIException.getMessage());
            throw new HTTPException(reply);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private final boolean isSpace(byte by) {
        return by == 32 || by == 9 || by == 10 || by == 13;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void merge(Reply var1_1, Reply var2_2) {
        var3_3 = var2_2.getStatus();
        var4_4 = var1_1.getStatus();
        if (var3_3 != 304) ** GOTO lbl8
        switch (var4_4) {
            default: {
                var1_1.setStatus(200);
                break;
            }
lbl8:
            // 1 sources

            if (var4_4 != 304) break;
            var1_1.setStatus(200);
            break;
            case 304: 
        }
        var5_5 = 0;
        while (var5_5 < SSIFrame.mergeHeaders.length) {
            var1_1.setHeaderValue(SSIFrame.mergeHeaders[var5_5], SSIFrame.mergers[var5_5].merge(var1_1.getHeaderValue(SSIFrame.mergeHeaders[var5_5]), var2_2.getHeaderValue(SSIFrame.mergeHeaders[var5_5])));
            ++var5_5;
        }
        if (this.getMaxAge() != -1L && (var6_6 = var2_2.getMaxAge()) != -1) {
            var7_7 = var1_1.getMaxAge();
            if (var7_7 != -1) {
                var6_6 = Math.min(var7_7, var6_6);
            }
            var1_1.setMaxAge(var6_6);
        }
    }

    private final String parseCmdName(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(80);
        int n3 = 0;
        while (n3 < n2) {
            char c = (char)byArray[n + n3];
            if (Character.isSpace(c)) break;
            stringBuffer.append(c);
            ++n3;
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    private final void parseCmdParams(byte[] byArray, int n, int n2, Vector vector, Vector vector2) {
        String string = null;
        String string2 = null;
        int n3 = -1;
        int n4 = n;
        while (n4 < n2) {
            while (this.isSpace(byArray[n4++])) {
            }
            if (n4 >= n2) break;
            byte by = byArray[--n4];
            n3 = n4;
            while (n4 < n2 && !this.isSpace(by) && by != 61) {
                by = byArray[++n4];
            }
            int n5 = n4 - n3;
            if (n5 <= 0) break;
            string = new String(byArray, 0, n3, n5);
            string2 = emptyString;
            boolean bl = false;
            while (this.isSpace(by) || by == 61) {
                if (by == 61) {
                    bl = true;
                }
                by = byArray[++n4];
            }
            if (n4 >= n2) {
                bl = false;
            }
            if (bl) {
                if (by == 34 || by == 39) {
                    byte by2 = by;
                    by = byArray[++n4];
                    n3 = n4;
                    while (n4 < n2 && by != by2) {
                        by = byArray[++n4];
                    }
                    n5 = n4 - n3;
                    string2 = new String(byArray, 0, n3, n5);
                    ++n4;
                } else {
                    n3 = n4;
                    while (n4 < n2 && !this.isSpace(by)) {
                        by = byArray[++n4];
                    }
                    n5 = n4 - n3;
                    string2 = new String(byArray, 0, n3, n5);
                }
            }
            vector.addElement(string);
            vector2.addElement(string2);
        }
    }

    private void parseFirstTime() {
        this.cacheReplies = true;
        byte[] byArray = null;
        try {
            byArray = this.readUnparsed();
        }
        catch (IOException iOException) {
            this.setValue(ATTR_SEGMENTS, null);
            return;
        }
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        Vector<Segment> vector = new Vector<Segment>(20);
        Object var16_6 = null;
        String string = null;
        Vector vector2 = null;
        Vector vector3 = null;
        Object var20_10 = null;
        Object var21_11 = null;
        int n3 = 0;
        do {
            int n4;
            byte by;
            n += 4;
            while (n < byArray.length) {
                by = byArray[n];
                if (by == 35 && SSIFrame.byteArrayNEquals(byArray, n - 4, startPat, 0, 4)) break;
                n += startIncrements[by >= 0 ? by : (byte)0];
            }
            if (++n >= byArray.length) break;
            int n5 = n4 = n;
            int n6 = n4 - 5;
            if (n6 > n3) {
                vector.addElement(new Segment(n3, n6));
                n2 += n6 - n3;
                n3 = n6;
            }
            n += 2;
            while (n < byArray.length) {
                by = byArray[n];
                if (by == 62 && byArray[n - 2] == 45 && byArray[n - 1] == 45) break;
                n += endIncrements[by >= 0 ? by : (byte)0];
            }
            if (++n >= byArray.length) break;
            int n7 = n - 3;
            int n8 = n;
            while (n4 < n7 && this.isSpace(byArray[n4])) {
                ++n4;
            }
            if (n4 >= n7) continue;
            int n9 = n7 - n4;
            string = this.parseCmdName(byArray, n4, n9);
            if (string == null) {
                vector.addElement(new Segment(n6, n8));
                n2 += n8 - n6;
                n3 = n8;
                continue;
            }
            vector2 = new Vector(5);
            vector3 = new Vector(5);
            this.parseCmdParams(byArray, n4 + string.length(), n7, vector2, vector3);
            vector.addElement(new Segment(this, string, new ArrayDictionary(vector2, vector3), n3, n8));
            n3 = n8;
        } while (n < byArray.length);
        vector.addElement(new Segment(n3, byArray.length));
        this.setUnparsedSize(n2 += byArray.length - n3);
        Object[] objectArray = new Segment[vector.size()];
        vector.copyInto(objectArray);
        this.setValue(ATTR_SEGMENTS, (Object)objectArray);
    }

    public ReplyInterface perform(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        if (!this.checkRequest(requestInterface)) {
            return this.performFrames(requestInterface);
        }
        if (this.fresource != null) {
            this.fresource.checkContent();
        }
        return super.perform(requestInterface);
    }

    public Reply post(Request request) throws ProtocolException, ResourceException {
        Reply reply = this.handle(request);
        return reply != null ? reply : super.post(request);
    }

    private byte[] readUnparsed() throws IOException {
        File file = this.fresource.getFile();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)file.length());
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[4096];
        int n = 0;
        while ((n = fileInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        byteArrayOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    private final void setUnparsedSize(int n) {
        this.setValue(ATTR_UNPARSED_SIZE, (Object)new Integer(n));
    }

    private void updateRegistry() throws SSIException {
        try {
            Class<?> clazz = (Class<?>)this.getValue(ATTR_REGISTRY_CLASS, null);
            if (clazz == null) {
                clazz = Class.forName("org.w3c.jigsaw.ssi.commands.DefaultCommandRegistry");
            }
            if (this.regClass == null || !clazz.equals(this.regClass)) {
                this.regClass = clazz;
                this.commReg = this.fetchRegistry(this.regClass);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SSIException("Cannot make registry: " + classNotFoundException.getMessage());
        }
    }
}

