/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.servlet.AutoReloadServletLoader;
import org.w3c.jigsaw.servlet.JigsawHttpServletRequest;
import org.w3c.jigsaw.servlet.JigsawHttpServletResponse;
import org.w3c.jigsaw.servlet.JigsawHttpSessionContext;
import org.w3c.jigsaw.servlet.JigsawServletContext;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LongAttribute;
import org.w3c.tools.resources.ObjectAttribute;
import org.w3c.tools.resources.PropertiesAttribute;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.tools.timers.EventHandler;
import org.w3c.util.ArrayDictionary;
import org.w3c.util.EmptyEnumeration;

public class ServletWrapper
extends FramedResource
implements ServletConfig {
    protected TimeoutManager timeoutManager = null;
    protected int connections = 0;
    protected static final boolean debug = false;
    protected static int ATTR_SERVLET_CLASS = -1;
    protected static int ATTR_SERVLET_TIMEOUT = -1;
    protected static int ATTR_PARAMETERS = 1;
    protected static int ATTR_SERVLET_CONTEXT = -1;
    protected static int ATTR_SESSION_CONTEXT = -1;
    protected Servlet servlet = null;
    protected boolean inited = false;

    static {
        Attribute attribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.servlet.ServletWrapper");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        attribute = new StringAttribute("servlet-class", null, 6);
        ATTR_SERVLET_CLASS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new PropertiesAttribute("servlet-parameters", null, 2);
        ATTR_PARAMETERS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new ObjectAttribute("servlet-context", "org.w3c.jigsaw.servlet.JigsawServletContext", null, 8);
        ATTR_SERVLET_CONTEXT = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new ObjectAttribute("session-context", "org.w3c.jigsaw.servlet.JigsawHttpSessionContext", null, 8);
        ATTR_SESSION_CONTEXT = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new LongAttribute("servlet-timeout", null, 2);
        ATTR_SERVLET_TIMEOUT = AttributeRegistry.registerAttribute(clazz, attribute);
    }

    public boolean acceptUnload() {
        return this.servlet == null;
    }

    protected void checkServlet() throws ClassNotFoundException, ServletException {
        boolean bl = this.getLocalServletLoader().classChanged(this.getServletClass());
        if (bl || this.servlet == null || this.servlet.getClass() != this.getLocalServletLoader().loadClass(this.getServletClass())) {
            this.inited = this.launchServlet();
        }
    }

    protected AutoReloadServletLoader createNewLocalServletLoader(boolean bl) {
        JigsawServletContext jigsawServletContext = (JigsawServletContext)this.getServletContext();
        return jigsawServletContext.createNewLocalServletLoader(bl);
    }

    protected synchronized void destroyServlet() {
        if (this.servlet != null && this.connections < 1) {
            this.servlet.destroy();
            this.servlet = null;
        }
    }

    public synchronized String getInitParameter(String string) {
        ArrayDictionary arrayDictionary = this.getServletParameters();
        String string2 = arrayDictionary != null ? (String)arrayDictionary.get(string) : null;
        return string2;
    }

    public synchronized Enumeration getInitParameterNames() {
        ArrayDictionary arrayDictionary = this.getServletParameters();
        return arrayDictionary != null ? arrayDictionary.keys() : new EmptyEnumeration();
    }

    protected synchronized AutoReloadServletLoader getLocalServletLoader() {
        JigsawServletContext jigsawServletContext = (JigsawServletContext)this.getServletContext();
        return jigsawServletContext.getLocalServletLoader();
    }

    public synchronized Servlet getServlet() {
        try {
            this.checkServlet();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.servlet;
    }

    public String getServletClass() {
        String string;
        String string2 = this.getString(ATTR_SERVLET_CLASS, null);
        if (string2 == null && (string = this.getIdentifier()).endsWith(".class")) {
            string2 = string;
        }
        return string2;
    }

    public ServletContext getServletContext() {
        return (ServletContext)this.getValue(ATTR_SERVLET_CONTEXT, null);
    }

    public File getServletDirectory() {
        ResourceReference resourceReference = this.getParent();
        if (resourceReference != null) {
            try {
                try {
                    Resource resource = resourceReference.lock();
                    if (resource.definesAttribute("directory")) {
                        File file = (File)resource.getValue("directory", null);
                        Object var4_5 = null;
                        resourceReference.unlock();
                        return file;
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                    invalidResourceException.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                resourceReference.unlock();
                throw throwable;
            }
            Object var4_6 = null;
            resourceReference.unlock();
        }
        return null;
    }

    public ArrayDictionary getServletParameters() {
        return (ArrayDictionary)this.getValue(ATTR_PARAMETERS, null);
    }

    protected long getServletTimeout() {
        long l = this.getLong(ATTR_SERVLET_TIMEOUT, 0L);
        if (l == 0L) {
            JigsawServletContext jigsawServletContext = (JigsawServletContext)this.getServletContext();
            l = jigsawServletContext.getServletTimeout();
        }
        return l;
    }

    public JigsawHttpSessionContext getSessionContext() {
        return (JigsawHttpSessionContext)this.getValue(ATTR_SESSION_CONTEXT, null);
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        this.connections = 0;
        if (this.getServletContext() != null) {
            this.timeoutManager = new TimeoutManager((httpd)this.getServer());
            this.timeoutManager.start();
        }
        if (this.getServletClass() != null) {
            try {
                this.inited = this.launchServlet();
            }
            catch (ServletException servletException) {
                System.err.println(servletException.toString());
            }
            catch (Exception exception) {}
        }
        try {
            this.registerFrameIfNone("org.w3c.jigsaw.servlet.ServletWrapperFrame", "servlet-wrapper-frame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void invalidateAllSession() {
        JigsawHttpSessionContext jigsawHttpSessionContext = this.getSessionContext();
        Enumeration enumeration = jigsawHttpSessionContext.getIds();
        while (enumeration.hasMoreElements()) {
            jigsawHttpSessionContext.getSession((String)enumeration.nextElement()).invalidate();
        }
    }

    protected boolean isInited() {
        return this.inited;
    }

    protected boolean isWrappingAServlet() {
        String string = this.getServletClass();
        if (string == null) {
            return false;
        }
        Class clazz = null;
        try {
            clazz = this.getLocalServletLoader().loadClass(string, true);
            Object t = clazz.newInstance();
            return t instanceof Servlet;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean launchServlet() throws ClassNotFoundException, ServletException {
        String string;
        if (this.servlet != null) {
            this.destroyServlet();
        }
        if ((string = this.getServletClass()) == null) {
            this.getServer().errlog(this, "no servlet class attribute defined.");
            return false;
        }
        Class clazz = null;
        try {
            if (this.getLocalServletLoader().classChanged(string)) {
                this.createNewLocalServletLoader(true);
                this.invalidateAllSession();
            }
            clazz = this.getLocalServletLoader().loadClass(string, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = "unable to find servlet class \"" + this.getServletClass() + "\"";
            this.getServer().errlog(string2);
            throw classNotFoundException;
        }
        return clazz != null ? this.launchServlet(clazz) : false;
    }

    protected boolean launchServlet(Class clazz) throws ServletException {
        try {
            this.servlet = (Servlet)clazz.newInstance();
            this.servlet.init((ServletConfig)this);
            this.timeoutManager.restart();
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "Illegal access during servlet instantiation, " + illegalAccessException.getClass().getName() + ": " + illegalAccessException.getMessage();
            this.getServer().errlog(this, string);
            return false;
        }
        catch (InstantiationException instantiationException) {
            String string = "unable to instantiate servlet, " + instantiationException.getClass().getName() + ": " + instantiationException.getMessage();
            this.getServer().errlog(this, string);
            return false;
        }
        return this.servlet != null;
    }

    public void notifyUnload() {
        if (this.timeoutManager != null) {
            this.timeoutManager.stop();
        }
        this.destroyServlet();
    }

    protected void service(Request request, Reply reply) throws ServletException, IOException {
        JigsawHttpServletResponse jigsawHttpServletResponse = null;
        JigsawHttpServletRequest jigsawHttpServletRequest = null;
        if (this.servlet instanceof SingleThreadModel) {
            ServletWrapper servletWrapper = this;
            synchronized (servletWrapper) {
                jigsawHttpServletResponse = new JigsawHttpServletResponse(request, reply);
                jigsawHttpServletRequest = new JigsawHttpServletRequest(this.servlet, request, jigsawHttpServletResponse, this.getSessionContext());
                jigsawHttpServletResponse.setServletRequest(jigsawHttpServletRequest);
                try {
                    ++this.connections;
                    this.servlet.service((ServletRequest)jigsawHttpServletRequest, (ServletResponse)jigsawHttpServletResponse);
                }
                finally {
                    Object var8_7 = null;
                    --this.connections;
                }
                jigsawHttpServletResponse.flushStream(true);
            }
        }
        jigsawHttpServletResponse = new JigsawHttpServletResponse(request, reply);
        jigsawHttpServletRequest = new JigsawHttpServletRequest(this.servlet, request, jigsawHttpServletResponse, this.getSessionContext());
        jigsawHttpServletResponse.setServletRequest(jigsawHttpServletRequest);
        try {
            ++this.connections;
            this.servlet.service((ServletRequest)jigsawHttpServletRequest, (ServletResponse)jigsawHttpServletResponse);
        }
        finally {
            Object var6_10 = null;
            --this.connections;
        }
        jigsawHttpServletResponse.flushStream(true);
        this.timeoutManager.restart();
    }

    public void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_SERVLET_CLASS && object != null || n == ATTR_PARAMETERS) {
            try {
                this.inited = this.launchServlet();
            }
            catch (Exception exception) {
                String string = "unable to set servlet class \"" + this.getServletClass() + "\" : " + exception.getMessage();
                this.getServer().errlog(string);
            }
        }
        if (n == ATTR_SERVLET_TIMEOUT) {
            this.timeoutManager.restart();
        }
    }

    protected void setValueOfSuperClass(int n, Object object) {
        super.setValue(n, object);
    }

    protected class TimeoutManager
    implements EventHandler {
        private Object timer = null;
        private httpd server = null;

        TimeoutManager(httpd httpd2) {
            this.server = httpd2;
        }

        public synchronized void handleTimerEvent(Object object, long l) {
            this.timer = null;
            ServletWrapper.this.destroyServlet();
        }

        protected void restart() {
            this.start();
        }

        private synchronized void setTimer(long l) {
            if (this.timer != null) {
                this.server.timer.recallTimer(this.timer);
                this.timer = null;
            }
            this.timer = this.server.timer.registerTimer(l, this, null);
        }

        protected void start() {
            long l = ServletWrapper.this.getServletTimeout();
            if (l != -1L) {
                this.setTimer(ServletWrapper.this.getServletTimeout());
            }
        }

        protected synchronized void stop() {
            if (this.timer != null) {
                this.server.timer.recallTimer(this.timer);
                this.timer = null;
            }
        }
    }
}

