/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.io.DataOutputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.servlet.JigsawHttpServletResponse;

class JigsawServletOutputStream
extends ServletOutputStream {
    DataOutputStream out = null;
    JigsawHttpServletResponse resp = null;
    Reply reply = null;

    JigsawServletOutputStream(JigsawHttpServletResponse jigsawHttpServletResponse, DataOutputStream dataOutputStream) {
        this.out = dataOutputStream;
        this.resp = jigsawHttpServletResponse;
    }

    JigsawServletOutputStream(JigsawHttpServletResponse jigsawHttpServletResponse, Reply reply) {
        this.resp = jigsawHttpServletResponse;
        this.reply = reply;
    }

    private void check() throws IOException {
        if (this.out == null && this.reply != null) {
            this.out = new DataOutputStream(this.reply.getOutputStream());
        }
    }

    public void close() throws IOException {
        this.check();
        this.out.close();
    }

    public void flush() throws IOException {
        this.check();
        this.out.flush();
    }

    public void print(double d) throws IOException {
        this.check();
        this.out.writeBytes(Double.toString(d));
    }

    public void print(int n) throws IOException {
        this.check();
        this.out.writeBytes(Integer.toString(n));
    }

    public void print(long l) throws IOException {
        this.check();
        this.out.writeBytes(Long.toString(l));
    }

    public void print(String string) throws IOException {
        this.check();
        this.out.writeBytes(string);
    }

    public void println() throws IOException {
        this.check();
        this.out.writeBytes("\r\n");
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.println();
    }

    public void println(int n) throws IOException {
        this.print(n);
        this.println();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.println();
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.println();
    }

    public void write(int n) throws IOException {
        this.check();
        this.out.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.check();
        this.out.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.check();
        this.out.write(byArray, n, n2);
    }
}

