/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import org.w3c.jigsaw.servlet.JigsawHttpSessionContext;

public class JigsawHttpSession
implements HttpSession {
    private JigsawHttpSessionContext sc = null;
    private String id = null;
    private long creationTime = -1L;
    private long lastAccessedTime = -1L;
    private boolean isValid = false;
    private boolean isNew = false;
    private Cookie cookie = null;
    private Hashtable values = new Hashtable();
    private int maxidle = -1;

    public JigsawHttpSession(JigsawHttpSessionContext jigsawHttpSessionContext, Cookie cookie) {
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.sc = jigsawHttpSessionContext;
        this.id = jigsawHttpSessionContext.addSession(this);
        this.cookie = cookie;
        cookie.setValue(this.id);
        this.isValid = true;
        this.isNew = true;
    }

    protected Cookie getCookie() {
        return this.cookie;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxidle;
    }

    public HttpSessionContext getSessionContext() {
        return this.sc;
    }

    public Object getValue(String string) {
        if (!this.isValid) {
            throw new IllegalStateException("Invalid session");
        }
        return this.values.get(string);
    }

    public String[] getValueNames() {
        if (!this.isValid) {
            throw new IllegalStateException("Invalid session");
        }
        String[] stringArray = new String[this.values.size()];
        Enumeration enumeration = this.values.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public void invalidate() {
        this.isValid = false;
        this.sc.removeSession(this.id);
    }

    public boolean isNew() {
        return this.isNew;
    }

    protected boolean isValid() {
        return this.isValid;
    }

    public void putValue(String string, Object object) {
        if (!this.isValid) {
            throw new IllegalStateException("Invalid session");
        }
        this.removeValue(string);
        this.values.put(string, object);
        if (object instanceof HttpSessionBindingListener) {
            this.valueBound((HttpSessionBindingListener)object, string);
        }
    }

    public void removeValue(String string) {
        if (!this.isValid) {
            throw new IllegalStateException("Invalid session");
        }
        Object v = this.values.get(string);
        if (v != null) {
            this.values.remove(string);
            if (v instanceof HttpSessionBindingListener) {
                this.valueUnbound((HttpSessionBindingListener)v, string);
            }
        }
    }

    protected void setLastAccessedTime() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public void setMaxInactiveInterval(int n) {
        this.maxidle = n;
    }

    protected void setNoMoreNew() {
        this.isNew = false;
    }

    protected void valueBound(HttpSessionBindingListener httpSessionBindingListener, String string) {
        httpSessionBindingListener.valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
    }

    protected void valueUnbound(HttpSessionBindingListener httpSessionBindingListener, String string) {
        httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
    }
}

