/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.servlet.JigsawHttpServletRequest;
import org.w3c.jigsaw.servlet.JigsawServletOutputStream;
import org.w3c.www.http.HttpSetCookie;
import org.w3c.www.http.HttpSetCookieList;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;

public class JigsawHttpServletResponse
implements HttpServletResponse {
    private static final int STATE_INITIAL = 0;
    private static final int STATE_HEADERS_DONE = 1;
    private static final int STATE_ALL_DONE = 2;
    private static final int STREAM_STATE_INITIAL = 0;
    private static final int STREAM_WRITER_USED = 1;
    private static final int OUTPUT_STREAM_USED = 2;
    private int stream_state = 0;
    private JigsawServletOutputStream output = null;
    private PrintWriter writer = null;
    private MimeTypeFormatException setContentTypeException = null;
    private static final int CALC_CONTENT_LENGTH = -1;
    private int fixedContentLength = -1;
    protected ByteArrayOutputStream out = null;
    protected JigsawHttpServletRequest jrequest = null;
    public static final String INCLUDED = "org.w3c.jigsaw.servlet.included";
    int state = 0;
    Reply reply = null;
    Request request = null;

    JigsawHttpServletResponse(Request request, Reply reply) {
        this.request = request;
        this.reply = reply;
    }

    public void addCookie(Cookie cookie) {
        HttpSetCookieList httpSetCookieList = this.reply.getSetCookie();
        if (httpSetCookieList == null) {
            HttpSetCookie[] httpSetCookieArray = new HttpSetCookie[]{this.convertCookie(cookie)};
            httpSetCookieList = new HttpSetCookieList(httpSetCookieArray);
        } else {
            httpSetCookieList.addSetCookie(this.convertCookie(cookie));
        }
        this.reply.setSetCookie(httpSetCookieList);
    }

    public boolean containsHeader(String string) {
        return this.reply.hasHeader(string);
    }

    private HttpSetCookie convertCookie(Cookie cookie) {
        HttpSetCookie httpSetCookie = new HttpSetCookie(true, cookie.getName(), cookie.getValue());
        httpSetCookie.setComment(cookie.getComment());
        httpSetCookie.setDomain(cookie.getDomain());
        httpSetCookie.setMaxAge(cookie.getMaxAge());
        httpSetCookie.setPath(cookie.getPath());
        httpSetCookie.setSecurity(cookie.getSecure());
        httpSetCookie.setVersion(cookie.getVersion());
        return httpSetCookie;
    }

    public String encodeRedirectURL(String string) {
        return this.encodeRedirectUrl(string);
    }

    public String encodeRedirectUrl(String string) {
        try {
            URL uRL = new URL(string);
            URL uRL2 = new URL(this.jrequest.getRequestURI());
            if (uRL.getHost().equals(uRL2.getHost()) && uRL.getPort() == uRL2.getPort()) {
                return this.encodeUrl(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
        return string;
    }

    public String encodeURL(String string) {
        return this.encodeUrl(string);
    }

    public String encodeUrl(String string) {
        if (!this.jrequest.isRequestedSessionIdFromCookie()) {
            string = String.valueOf(string) + (string.indexOf("?") != -1 ? "&" : "?") + this.jrequest.getCookieName() + "=" + this.jrequest.getSession(true).getId();
        }
        return string;
    }

    protected synchronized void flushStream(boolean bl) throws IOException {
        if (this.stream_state == 2) {
            this.output.flush();
        } else if (this.stream_state == 1) {
            this.writer.flush();
        }
        if (this.request.hasState(INCLUDED)) {
            if (this.out == null) {
                return;
            }
            int n = this.fixedContentLength != -1 ? (this.out.size() < this.fixedContentLength ? this.out.size() : this.fixedContentLength) : this.out.size();
            this.reply.setContentLength(n);
            OutputStream outputStream = this.reply.getOutputStream(false);
            byte[] byArray = this.out.toByteArray();
            if (bl) {
                this.out.close();
            } else {
                this.out.reset();
            }
            outputStream.write(byArray);
            outputStream.flush();
        }
    }

    public String getCharacterEncoding() {
        MimeType mimeType = this.reply.getContentType();
        if (mimeType != null && mimeType.hasParameter("charset")) {
            return mimeType.getParameterValue("charset");
        }
        return System.getProperty("file.encoding");
    }

    protected ServletOutputStream getJigsawOutputStream() throws IOException {
        if (this.output != null) {
            return this.output;
        }
        if (this.setContentTypeException != null) {
            throw new IOException("Illegal Contenttype: " + this.setContentTypeException.toString());
        }
        if (this.request.hasState(INCLUDED)) {
            this.out = new ByteArrayOutputStream();
            this.output = new JigsawServletOutputStream(this, new DataOutputStream(this.out));
        } else {
            this.output = new JigsawServletOutputStream(this, this.reply);
        }
        return this.output;
    }

    public synchronized ServletOutputStream getOutputStream() throws IOException {
        if (this.stream_state == 1) {
            throw new IllegalStateException("Writer used");
        }
        this.stream_state = 2;
        return this.getJigsawOutputStream();
    }

    protected Reply getReply() {
        return this.reply;
    }

    public synchronized PrintWriter getWriter() throws IOException, UnsupportedEncodingException {
        if (this.stream_state == 2) {
            throw new IllegalStateException("Output stream used");
        }
        this.stream_state = 1;
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.getJigsawOutputStream(), this.getCharacterEncoding()));
        }
        return this.writer;
    }

    protected boolean isStreamObtained() {
        return this.stream_state != 0;
    }

    public void sendError(int n) throws IOException {
        this.setStatus(n);
        this.reply.setContent(this.reply.getStandardReason(n));
        this.state = 2;
    }

    public void sendError(int n, String string) throws IOException {
        this.setStatus(n);
        this.reply.setContent(string);
        this.state = 2;
    }

    public void sendRedirect(String string) throws IOException {
        URL uRL = null;
        try {
            uRL = new URL(this.request.getURL(), string);
            this.setStatus(302);
            this.reply.setLocation(uRL);
            this.state = 2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setContentLength(int n) {
        this.fixedContentLength = n;
        this.reply.setContentLength(n);
    }

    public void setContentType(String string) {
        try {
            MimeType mimeType = new MimeType(string);
            this.reply.setContentType(mimeType);
            this.setContentTypeException = null;
        }
        catch (MimeTypeFormatException mimeTypeFormatException) {
            this.setContentTypeException = mimeTypeFormatException;
        }
    }

    public void setDateHeader(String string, long l) {
        this.setHeader(string, String.valueOf(l));
    }

    public void setHeader(String string, String string2) {
        this.reply.setValue(string, string2);
    }

    public void setIntHeader(String string, int n) {
        this.setHeader(string, String.valueOf(n));
    }

    protected void setServletRequest(JigsawHttpServletRequest jigsawHttpServletRequest) {
        this.jrequest = jigsawHttpServletRequest;
    }

    public void setStatus(int n) {
        this.setStatus(n, this.reply.getStandardReason(n));
    }

    public void setStatus(int n, String string) {
        this.reply.setStatus(n);
        this.reply.setReason(string);
    }

    public void unsetHeader(String string) {
        this.setHeader(string, null);
    }
}

