/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.jigsaw.forms.URLDecoder;
import org.w3c.jigsaw.forms.URLDecoderException;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.resources.VirtualHostResource;
import org.w3c.jigsaw.servlet.HeaderNames;
import org.w3c.jigsaw.servlet.JigsawHttpServletResponse;
import org.w3c.jigsaw.servlet.JigsawHttpSession;
import org.w3c.jigsaw.servlet.JigsawHttpSessionContext;
import org.w3c.jigsaw.servlet.JigsawServletInputStream;
import org.w3c.jigsaw.servlet.ServletProps;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.util.EmptyEnumeration;
import org.w3c.util.ObservableProperties;
import org.w3c.www.http.ContentLengthInputStream;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpCookie;
import org.w3c.www.http.HttpCookieList;
import org.w3c.www.mime.MimeType;

public class JigsawHttpServletRequest
implements HttpServletRequest {
    private static final int STREAM_STATE_INITIAL = 0;
    private static final int STREAM_READER_USED = 1;
    private static final int INPUT_STREAM_USED = 2;
    private int stream_state = 0;
    public static final String STATE_PARAMETERS = "org.w3c.jigsaw.servlet.stateParam";
    private static MimeType type = MimeType.APPLICATION_X_WWW_FORM_URLENCODED;
    private Request request = null;
    private Servlet servlet = null;
    private Hashtable queryParameters = null;
    protected JigsawHttpServletResponse response = null;
    protected JigsawHttpSession httpSession = null;
    protected JigsawHttpSessionContext sessionContext = null;
    protected String requestedSessionID = null;
    protected ServletInputStream is = null;
    protected BufferedReader reader = null;

    JigsawHttpServletRequest(Servlet servlet, Request request, JigsawHttpServletResponse jigsawHttpServletResponse, JigsawHttpSessionContext jigsawHttpSessionContext) {
        this.servlet = servlet;
        this.request = request;
        this.response = jigsawHttpServletResponse;
        this.sessionContext = jigsawHttpSessionContext;
    }

    protected Cookie convertCookie(HttpCookie httpCookie) {
        Cookie cookie = new Cookie(httpCookie.getName(), httpCookie.getValue());
        String string = null;
        string = httpCookie.getDomain();
        if (string != null) {
            cookie.setDomain(string);
        }
        if ((string = httpCookie.getPath()) != null) {
            cookie.setPath(string);
        }
        cookie.setVersion(httpCookie.getVersion());
        return cookie;
    }

    protected Cookie createCookie() {
        ObservableProperties observableProperties = this.request.getClient().getServer().getProperties();
        String string = observableProperties.getString(ServletProps.SERVLET_COOKIE_NAME, ServletProps.DEFAULT_COOKIE_NAME);
        String string2 = observableProperties.getString(ServletProps.SERVLET_COOKIE_PATH, "/");
        String string3 = observableProperties.getString(ServletProps.SERVLET_COOKIE_DOMAIN, null);
        String string4 = observableProperties.getString(ServletProps.SERVLET_COOKIE_COMMENT, null);
        int n = observableProperties.getInteger(ServletProps.SERVLET_COOKIE_MAXAGE, 86400);
        boolean bl = observableProperties.getBoolean(ServletProps.SERVLET_COOKIE_SECURE, false);
        Cookie cookie = new Cookie(string, null);
        cookie.setPath(string2);
        cookie.setMaxAge(n);
        if (string4 != null && string4.length() > 0) {
            cookie.setComment(string4);
        }
        if (string3 != null && string3.length() > 0) {
            cookie.setDomain(string3);
        }
        cookie.setSecure(bl);
        return cookie;
    }

    public Object getAttribute(String string) {
        return this.request.getState(string);
    }

    public Enumeration getAttributeNames() {
        return this.request.getStateNames();
    }

    public String getAuthType() {
        return (String)this.request.getState("org.w3c.jigsaw.auth.AuthFilter.type");
    }

    public String getCharacterEncoding() {
        MimeType mimeType = this.request.getContentType();
        if (mimeType != null && mimeType.hasParameter("charset")) {
            return mimeType.getParameterValue("charset");
        }
        return "ISO-8859-1";
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        MimeType mimeType = this.request.getContentType();
        return mimeType == null ? null : mimeType.toString();
    }

    protected String getCookieName() {
        ObservableProperties observableProperties = this.request.getClient().getServer().getProperties();
        return observableProperties.getString(ServletProps.SERVLET_COOKIE_NAME, ServletProps.DEFAULT_COOKIE_NAME);
    }

    public Cookie[] getCookies() {
        HttpCookieList httpCookieList = this.request.getCookie();
        Cookie[] cookieArray = null;
        if (httpCookieList != null) {
            HttpCookie[] httpCookieArray = httpCookieList.getCookies();
            cookieArray = new Cookie[httpCookieArray.length];
            int n = 0;
            while (n < httpCookieArray.length) {
                cookieArray[n] = this.convertCookie(httpCookieArray[n]);
                ++n;
            }
        }
        return cookieArray;
    }

    public long getDateHeader(String string) {
        Object object;
        HeaderValue headerValue = this.request.getHeaderValue(string, null);
        if (headerValue != null && (object = headerValue.getValue()) != null && object instanceof Long) {
            return (Long)object;
        }
        return -1L;
    }

    public String getHeader(String string) {
        return this.request.getValue(string);
    }

    public Enumeration getHeaderNames() {
        return new HeaderNames(this.request.enumerateHeaderDescriptions());
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.stream_state == 1) {
            throw new IllegalStateException("Reader used");
        }
        this.stream_state = 2;
        return this.getJigsawInputStream();
    }

    public int getIntHeader(String string) {
        Object object;
        HeaderValue headerValue = this.request.getHeaderValue(string);
        if (headerValue != null && (object = headerValue.getValue()) != null && object instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    protected ServletInputStream getJigsawInputStream() throws IOException {
        if (this.is != null) {
            return this.is;
        }
        InputStream inputStream = null;
        inputStream = this.request.getInputStream();
        if (inputStream == null) {
            inputStream = new ContentLengthInputStream(null, 0);
        }
        this.is = new JigsawServletInputStream(inputStream);
        return this.is;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getParameter(String string) {
        this.prepareQueryParameters();
        if (this.queryParameters != null) {
            Object v = this.queryParameters.get(string);
            if (v instanceof String[]) {
                return ((String[])v)[0];
            }
            return (String)v;
        }
        return null;
    }

    public Enumeration getParameterNames() {
        this.prepareQueryParameters();
        return this.queryParameters == null ? new EmptyEnumeration() : this.queryParameters.keys();
    }

    public String[] getParameterValues(String string) {
        Vector vector = new Vector(23);
        this.prepareQueryParameters();
        if (this.queryParameters == null) {
            return null;
        }
        Object v = this.queryParameters.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof String[]) {
            return (String[])v;
        }
        String[] stringArray = new String[]{(String)v};
        return stringArray;
    }

    public String getPathInfo() {
        return (String)this.request.getState("org.w3c.jigsaw.servlet.extraPath");
    }

    public String getPathTranslated() {
        String string = this.getPathInfo();
        if (string != null) {
            return this.getRealPath(string);
        }
        return null;
    }

    public String getProtocol() {
        return this.request.getVersion();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public BufferedReader getReader() throws IOException {
        if (this.stream_state == 2) {
            throw new IllegalStateException("Input Stream used");
        }
        this.stream_state = 1;
        if (this.reader == null) {
            String[] stringArray = this.request.getContentEncoding();
            ServletInputStream servletInputStream = this.getJigsawInputStream();
            if (stringArray != null) {
                InputStreamReader inputStreamReader = null;
                int n = 0;
                while (n < stringArray.length) {
                    try {
                        inputStreamReader = new InputStreamReader((InputStream)servletInputStream, stringArray[n]);
                        break;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        inputStreamReader = null;
                        ++n;
                    }
                }
                this.reader = inputStreamReader != null ? new BufferedReader(inputStreamReader) : new BufferedReader(new InputStreamReader((InputStream)servletInputStream));
            } else {
                this.reader = new BufferedReader(new InputStreamReader((InputStream)servletInputStream));
            }
        }
        return this.reader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRealPath(String string) {
        String string2;
        ResourceReference resourceReference;
        block16: {
            String string3;
            block15: {
                httpd httpd2 = this.request.getClient().getServer();
                resourceReference = httpd2.getRootReference();
                try {
                    try {
                        File file;
                        FramedResource framedResource = (FramedResource)resourceReference.lock();
                        if (framedResource instanceof VirtualHostResource) {
                            ResourceReference resourceReference2 = this.request.getTargetResource();
                            ResourceReference resourceReference3 = null;
                            while (true) {
                                Object var11_8;
                                block12: {
                                    String string4;
                                    block14: {
                                        String string5;
                                        block13: {
                                            try {
                                                try {
                                                    File file2;
                                                    FramedResource framedResource2 = (FramedResource)resourceReference2.lock();
                                                    resourceReference3 = framedResource2.getParent();
                                                    if (resourceReference3 != resourceReference && resourceReference3 != null) break block12;
                                                    if (framedResource2.definesAttribute("directory") && (file2 = (File)framedResource2.getValue("directory", null)) != null) {
                                                        string5 = new File(file2, string).getAbsolutePath();
                                                        var11_8 = null;
                                                        resourceReference2.unlock();
                                                        break block13;
                                                    }
                                                    string4 = null;
                                                    break block14;
                                                }
                                                catch (InvalidResourceException invalidResourceException) {
                                                    String string6 = null;
                                                    var11_8 = null;
                                                    resourceReference2.unlock();
                                                    Object var6_19 = null;
                                                    resourceReference.unlock();
                                                    return string6;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                var11_8 = null;
                                                resourceReference2.unlock();
                                                throw throwable;
                                            }
                                        }
                                        Object var6_17 = null;
                                        resourceReference.unlock();
                                        return string5;
                                    }
                                    var11_8 = null;
                                    resourceReference2.unlock();
                                    Object var6_18 = null;
                                    resourceReference.unlock();
                                    return string4;
                                }
                                var11_8 = null;
                                resourceReference2.unlock();
                                resourceReference2 = resourceReference3;
                            }
                        }
                        if (framedResource.definesAttribute("directory") && (file = (File)framedResource.getValue("directory", null)) != null) {
                            string3 = new File(file, string).getAbsolutePath();
                            break block15;
                        }
                        string2 = null;
                        break block16;
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        String string7 = null;
                        Object var6_22 = null;
                        resourceReference.unlock();
                        return string7;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_23 = null;
                    resourceReference.unlock();
                    throw throwable;
                }
            }
            Object var6_20 = null;
            resourceReference.unlock();
            return string3;
        }
        Object var6_21 = null;
        resourceReference.unlock();
        return string2;
    }

    public String getRemoteAddr() {
        return this.request.getClient().getInetAddress().getHostAddress();
    }

    public String getRemoteHost() {
        return this.request.getClient().getInetAddress().getHostName();
    }

    public String getRemoteUser() {
        return (String)this.request.getState("org.w3c.jigsaw.auth.AuthFilter.user");
    }

    protected Request getRequest() {
        return this.request;
    }

    public String getRequestURI() {
        String string = null;
        string = this.request.isProxy() ? this.request.getURL().toExternalForm() : this.request.getURLPath();
        if (this.request.hasQueryString()) {
            String string2 = this.request.getQueryString();
            int n = string.lastIndexOf(string2);
            string = string.substring(0, n - 1);
        }
        return string;
    }

    public String getRequestedSessionId() {
        if (this.requestedSessionID == null) {
            this.requestedSessionID = this.getRequestedSessionIdFromCookie();
            if (this.requestedSessionID == null) {
                this.requestedSessionID = this.getRequestedSessionIdFromURL();
            }
        }
        return this.requestedSessionID;
    }

    protected String getRequestedSessionIdFromCookie() {
        HttpCookie httpCookie;
        HttpCookieList httpCookieList = this.request.getCookie();
        if (httpCookieList != null && (httpCookie = this.request.getCookie().getCookie(this.getCookieName())) != null) {
            return httpCookie.getValue();
        }
        return null;
    }

    protected String getRequestedSessionIdFromURL() {
        return this.getURLParameter(this.getCookieName());
    }

    public String getScheme() {
        return this.request.getURL().getProtocol();
    }

    public String getServerName() {
        String string;
        if (this.request.isProxy() && (string = this.request.getHost()) != null) {
            return string.substring(0, string.lastIndexOf(58));
        }
        return this.request.getClient().getServer().getHost();
    }

    public int getServerPort() {
        String string;
        if (this.request.isProxy() && (string = this.request.getHost()) != null) {
            int n = string.lastIndexOf(58);
            if (n == -1) {
                return 80;
            }
            return Integer.parseInt(string.substring(n + 1));
        }
        return this.request.getClient().getServer().getLocalPort();
    }

    public String getServletPath() {
        ResourceReference resourceReference = this.request.getTargetResource();
        try {
            try {
                String string = resourceReference.lock().getURLPath();
                Object var4_4 = null;
                resourceReference.unlock();
                return string;
            }
            catch (InvalidResourceException invalidResourceException) {
                String string = null;
                Object var4_5 = null;
                resourceReference.unlock();
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            resourceReference.unlock();
            throw throwable;
        }
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    protected HttpSession getSession(String string) {
        if (string != null) {
            return this.getSessionContext().getSession(string);
        }
        return null;
    }

    public HttpSession getSession(boolean bl) {
        if (this.httpSession == null) {
            this.httpSession = (JigsawHttpSession)this.getSession(this.getRequestedSessionId());
            if (this.httpSession != null) {
                this.httpSession.setNoMoreNew();
            }
        }
        if (this.httpSession == null & bl) {
            this.httpSession = new JigsawHttpSession(this.getSessionContext(), this.createCookie());
            this.response.addCookie(this.httpSession.getCookie());
        } else if (this.httpSession != null) {
            this.httpSession.setLastAccessedTime();
            if (!this.httpSession.isValid()) {
                this.httpSession = new JigsawHttpSession(this.getSessionContext(), this.createCookie());
                this.response.addCookie(this.httpSession.getCookie());
            }
        }
        return this.httpSession;
    }

    protected synchronized JigsawHttpSessionContext getSessionContext() {
        return this.sessionContext;
    }

    protected String getURLParameter(String string) {
        Hashtable hashtable = null;
        String string2 = this.request.getQueryString();
        if (string2 != null) {
            StringReader stringReader = new StringReader(string2);
            try {
                hashtable = new URLDecoder(stringReader, false).parse();
                return (String)hashtable.get(string);
            }
            catch (Exception exception) {
                throw new RuntimeException("Java implementation bug.");
            }
        }
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.getRequestedSessionIdFromCookie() != null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.getRequestedSessionIdFromURL() != null;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.getRequestedSessionIdFromURL() != null;
    }

    public boolean isRequestedSessionIdValid() {
        JigsawHttpSession jigsawHttpSession = (JigsawHttpSession)this.getSession(this.getRequestedSessionId());
        if (jigsawHttpSession == null) {
            return false;
        }
        return jigsawHttpSession.isValid();
    }

    private Hashtable mergeParameters(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable == null) {
            return hashtable2;
        }
        if (hashtable2 != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String[] stringArray;
                String string = (String)enumeration.nextElement();
                Object v = hashtable2.get(string);
                if (v == null) {
                    hashtable2.put(string, hashtable.get(string));
                    continue;
                }
                if (v instanceof String[]) {
                    stringArray = (String[])v;
                    String[] stringArray2 = new String[stringArray.length + 1];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    stringArray2[stringArray.length] = (String)hashtable.get(string);
                    hashtable2.put(string, stringArray2);
                    continue;
                }
                stringArray = new String[]{(String)hashtable.get(string), (String)v};
                hashtable2.put(string, stringArray);
            }
            return hashtable2;
        }
        return hashtable;
    }

    private synchronized void prepareQueryParameters() {
        Object object;
        Object object2;
        if (this.queryParameters != null) {
            return;
        }
        Hashtable hashtable = null;
        if (this.request.getMethod().equals("POST")) {
            hashtable = new Hashtable(2);
            if (!this.request.hasContentType() || type.match(this.request.getContentType()) < 0) {
                return;
            }
            object2 = null;
            try {
                object = this.request.getInputStream();
                Client client = this.request.getClient();
                if (client != null) {
                    client.sendContinue();
                }
                object2 = new URLDecoder((InputStream)object, false);
                hashtable = ((URLDecoder)object2).parse();
            }
            catch (URLDecoderException uRLDecoderException) {
                hashtable = null;
            }
            catch (IOException iOException) {
                hashtable = null;
            }
        }
        if ((object2 = this.request.getQueryString()) != null) {
            object = new StringReader((String)object2);
            try {
                this.queryParameters = new URLDecoder((Reader)object, false).parse();
            }
            catch (Exception exception) {
                throw new RuntimeException("Java implementation bug.");
            }
        }
        this.queryParameters = this.mergeParameters(hashtable, this.queryParameters);
        object = (Hashtable)this.request.getState(STATE_PARAMETERS);
        this.queryParameters = this.mergeParameters((Hashtable)object, this.queryParameters);
    }

    public void setAttribute(String string, Object object) {
        this.request.setState(string, object);
    }
}

