/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.pics;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.LineNumberInputStream;
import java.io.StringBufferInputStream;
import org.w3c.jigsaw.pics.InvalidLabelException;
import org.w3c.jigsaw.pics.InvalidLabelFileException;
import org.w3c.jigsaw.pics.SampleLabel;

class LabelParser {
    File file = null;
    LineNumberInputStream in = null;
    int ch = -1;
    byte[] buffer = null;
    int bufptr = 0;

    LabelParser(File file) throws InvalidLabelFileException {
        this.file = file;
        try {
            this.in = new LineNumberInputStream(new BufferedInputStream(new FileInputStream(file)));
            this.buffer = new byte[32];
            this.ch = this.in.read();
        }
        catch (IOException iOException) {
            throw new InvalidLabelFileException(String.valueOf(file.getAbsolutePath()) + ": IO exception.");
        }
    }

    LabelParser(String string) throws InvalidLabelException {
        try {
            this.in = new LineNumberInputStream(new BufferedInputStream(new StringBufferInputStream(string)));
            this.buffer = new byte[32];
            this.ch = this.in.read();
        }
        catch (IOException iOException) {
            throw new InvalidLabelException("IO exception.");
        }
    }

    public void append(int n) {
        if (this.bufptr + 1 >= this.buffer.length) {
            byte[] byArray = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, byArray, 0, this.bufptr);
            this.buffer = byArray;
        }
        this.buffer[this.bufptr++] = (byte)n;
    }

    void expect(int n) throws InvalidLabelException {
        if (this.ch == n) {
            return;
        }
        String string = "expected " + new Character((char)n).toString() + "[" + n + "]" + " got " + new Character((char)this.ch).toString() + "[" + this.ch + "]";
        if (this.file == null) {
            throw new InvalidLabelException(this.in.getLineNumber(), string);
        }
        throw new InvalidLabelFileException(this.file, this.in.getLineNumber(), string);
    }

    public String getToken(boolean bl) {
        String string = new String(this.buffer, 0, 0, this.bufptr);
        if (bl) {
            this.bufptr = 0;
        }
        return string;
    }

    SampleLabel parse(SampleLabel sampleLabel) throws InvalidLabelException, InvalidLabelFileException {
        try {
            block7: while (true) {
                switch (this.ch) {
                    case -1: {
                        return sampleLabel;
                    }
                    case 9: 
                    case 10: 
                    case 32: {
                        this.ch = this.in.read();
                        continue block7;
                    }
                    case 35: {
                        while ((this.ch = this.in.read()) != 10 && this.ch != -1) {
                        }
                        continue block7;
                    }
                }
                String string = this.parseVariableName();
                this.expect(61);
                this.ch = this.in.read();
                String string2 = this.parseVariableValue();
                if (this.ch != -1) {
                    this.expect(10);
                    this.ch = this.in.read();
                }
                sampleLabel.addBinding(string, string2);
            }
        }
        catch (IOException iOException) {
            if (this.file == null) {
                throw new InvalidLabelException("IO exception.");
            }
            throw new InvalidLabelFileException(String.valueOf(this.file.getAbsolutePath()) + ": IO exception.");
        }
    }

    String parseVariableName() throws IOException {
        while (this.ch != 61 && this.ch != 10 && this.ch != -1) {
            this.append(Character.toLowerCase((char)this.ch));
            this.ch = this.in.read();
        }
        return this.getToken(true);
    }

    String parseVariableValue() throws IOException {
        while (this.ch != -1 && this.ch != 10) {
            this.append(this.ch);
            this.ch = this.in.read();
        }
        return this.getToken(true);
    }
}

