/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.html;

import java.io.InputStream;
import java.io.StringBufferInputStream;
import org.w3c.jigsaw.html.HtmlHead;
import org.w3c.jigsaw.html.HtmlLink;
import org.w3c.www.mime.MimeType;

public class HtmlGenerator {
    private static MimeType type = MimeType.TEXT_HTML;
    HtmlHead head = null;
    StringBuffer body = null;
    String content = null;
    boolean bodytag = true;

    public HtmlGenerator(String string) {
        this.head = new HtmlHead(string);
        this.body = new StringBuffer();
    }

    public void addBase(String string) {
        this.head.addBase(string);
    }

    public void addLink(HtmlLink htmlLink) {
        this.head.addLink(htmlLink);
    }

    public void addMeta(String string, String string2) {
        this.head.addMeta(string, string2);
    }

    public void addScript(String string) {
        this.head.addScript(string);
    }

    public void addScript(String string, String string2) {
        this.head.addScript(string, string2);
    }

    public void addStyle(String string) {
        this.head.addStyle(string);
    }

    public void addStyle(MimeType mimeType, String string) {
        this.head.addStyle(mimeType, string);
    }

    public void append(String string) {
        this.body.append(string);
    }

    public void append(String string, String string2) {
        this.body.append(string);
        this.body.append(string2);
    }

    public void append(String string, String string2, String string3) {
        this.body.append(string);
        this.body.append(string2);
        this.body.append(string3);
    }

    public void appendAndEscape(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '<': {
                    this.body.append("&lt;");
                    break;
                }
                case '>': {
                    this.body.append("&gt;");
                    break;
                }
                default: {
                    this.body.append(c);
                    break;
                }
            }
            ++n;
        }
    }

    public void close() {
        if (this.content != null) {
            return;
        }
        this.content = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Draft//EN\">\n<HTML>" + this.head.toString() + "\n" + (this.bodytag ? "<BODY>" + this.body.toString() + "</BODY>\n" : this.body.toString()) + "</HTML>";
    }

    public void emitBODYTag(boolean bl) {
        this.bodytag = bl;
    }

    public InputStream getInputStream() {
        this.close();
        return new StringBufferInputStream(this.content);
    }

    public MimeType getMimeType() {
        return type;
    }

    public int length() {
        if (this.content == null) {
            this.close();
        }
        return this.content.length();
    }

    public void meta(String string, String string2) {
        this.addMeta(string, string2);
    }
}

