/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.frames;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import org.w3c.jigsaw.forms.URLDecoder;
import org.w3c.jigsaw.forms.URLDecoderException;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.ClientException;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ResourceException;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpTokenList;
import org.w3c.www.mime.MimeType;

public class PostableFrame
extends HTTPFrame {
    private static HttpTokenList _post_allowed = null;
    private static HttpTokenList _put_allowed = null;
    private static MimeType type;
    protected static int ATTR_OVERIDE;
    protected static int ATTR_CONVERT_GET;

    static {
        Object object = new String[]{"GET", "HEAD", "OPTIONS", "POST", "TRACE"};
        _post_allowed = HttpFactory.makeStringList(object);
        Object object2 = new String[]{"GET", "HEAD", "OPTIONS", "PUT", "POST", "TRACE"};
        _put_allowed = HttpFactory.makeStringList(object2);
        type = MimeType.APPLICATION_X_WWW_FORM_URLENCODED;
        ATTR_OVERIDE = -1;
        ATTR_CONVERT_GET = -1;
        object = null;
        object2 = null;
        try {
            object2 = Class.forName("org.w3c.jigsaw.frames.PostableFrame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        object = new BooleanAttribute("override", Boolean.FALSE, 2);
        ATTR_OVERIDE = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
        object = new BooleanAttribute("convert-get", Boolean.TRUE, 2);
        ATTR_CONVERT_GET = AttributeRegistry.registerAttribute((Class)object2, (Attribute)object);
    }

    public Reply get(Request request) throws ProtocolException, ResourceException {
        if (!this.getConvertGetFlag() || !request.hasState("query")) {
            return super.get(request);
        }
        String string = request.getQueryString();
        StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
        URLDecoder uRLDecoder = new URLDecoder(stringBufferInputStream, this.getOverrideFlag());
        try {
            uRLDecoder.parse();
        }
        catch (URLDecoderException uRLDecoderException) {
            Reply reply = request.makeReply(400);
            reply.setContent("Invalid request:unable to decode form data.");
            throw new HTTPException(reply);
        }
        catch (IOException iOException) {
            Reply reply = request.makeReply(400);
            reply.setContent("Invalid request: unable to read form data.");
            throw new HTTPException(reply);
        }
        return this.handle(request, uRLDecoder);
    }

    public boolean getConvertGetFlag() {
        return this.getBoolean(ATTR_CONVERT_GET, false);
    }

    public boolean getOverrideFlag() {
        return this.getBoolean(ATTR_OVERIDE, true);
    }

    public Reply handle(Request request, URLDecoder uRLDecoder) throws ProtocolException {
        Object object;
        Enumeration enumeration = uRLDecoder.keys();
        HtmlGenerator htmlGenerator = new HtmlGenerator("Form decoded values");
        htmlGenerator.append("<p>List of variables and values:</p><ul>");
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            htmlGenerator.append("<li><em>" + (String)object + "</em> = <b>" + uRLDecoder.getValue((String)object) + "</b></li>");
        }
        htmlGenerator.append("</ul>");
        object = request.makeReply(200);
        ((Reply)object).setStream(htmlGenerator);
        return object;
    }

    public Reply post(Request request) throws ProtocolException, ResourceException {
        if (!request.hasContentType() || type.match(request.getContentType()) < 0) {
            Reply reply = request.makeReply(415);
            reply.setContent("Invalid request content type.");
            throw new HTTPException(reply);
        }
        URLDecoder uRLDecoder = null;
        try {
            InputStream inputStream = request.getInputStream();
            Client client = request.getClient();
            if (client != null) {
                client.sendContinue();
            }
            uRLDecoder = new URLDecoder(inputStream, this.getOverrideFlag());
            uRLDecoder.parse();
        }
        catch (URLDecoderException uRLDecoderException) {
            Reply reply = request.makeReply(400);
            reply.setContent("Invalid request: unable to decode form data.");
            throw new HTTPException(reply);
        }
        catch (IOException iOException) {
            Reply reply = request.makeReply(400);
            reply.setContent("Invalid request: unable to read form data.");
            throw new ClientException(request.getClient(), iOException);
        }
        return this.handle(request, uRLDecoder);
    }

    public synchronized void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == HTTPFrame.ATTR_PUTABLE) {
            this.allowed = object == Boolean.TRUE ? _put_allowed : _post_allowed;
        }
    }
}

