/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.daemon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.w3c.jigsaw.daemon.DaemonProperties;
import org.w3c.jigsaw.daemon.ServerHandler;
import org.w3c.jigsaw.daemon.ServerHandlerInitException;
import org.w3c.util.ObservableProperties;
import org.w3c.util.Unix;
import org.w3c.util.UnixException;

public class ServerHandlerManager {
    protected static final String HANDLERS_P = "org.w3c.jigsaw.daemon.handlers";
    public static final String CLASS_P = "org.w3c.jigsaw.daemon.class";
    public static final String CLONES_P = "org.w3c.jigsaw.daemon.clones";
    public static final String SERVER_USER_P = "org.w3c.jigsaw.daemon.user";
    public static final String SERVER_GROUP_P = "org.w3c.jigsaw.daemon.group";
    protected static ServerHandlerManager manager = null;
    protected Hashtable handlers = null;
    protected DaemonProperties props = null;
    protected String[] commandLine = null;

    public ServerHandlerManager(String[] stringArray, File file, Properties properties) {
        this.commandLine = stringArray;
        this.handlers = new Hashtable(7);
        this.props = new DaemonProperties(file, properties);
        String string = this.props.getProperty(HANDLERS_P);
        if (string == null || string.equals("")) {
            this.fatal("The property [org.w3c.jigsaw.daemon.handlers] is  undefined.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.launchServerHandler(string2, this.props);
        }
        if (this.handlers.size() <= 0) {
            this.fatal("No servers launched !");
        }
        this.unixStuff();
    }

    public Enumeration enumerateServerHandlers() {
        return this.handlers.keys();
    }

    protected void error(String string) {
        System.err.println(string);
    }

    protected void fatal(String string) {
        System.out.println("*** FATAL Error:");
        System.out.println(string);
        System.exit(1);
    }

    protected void fixProperties(Properties properties) {
    }

    public String[] getCommandLine() {
        if (this.commandLine == null) {
            this.commandLine = new String[0];
        }
        return this.commandLine;
    }

    protected void launchServerHandler(String string, DaemonProperties daemonProperties) {
        ServerHandler serverHandler = null;
        String string2 = daemonProperties.getString(String.valueOf(string) + "." + CLASS_P, null);
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                serverHandler = (ServerHandler)clazz.newInstance();
                ObservableProperties observableProperties = daemonProperties.loadPropertySpace(string);
                this.fixProperties(observableProperties);
                serverHandler.initialize(this, string, observableProperties);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Unable to launch " + string + ", no properties found:" + fileNotFoundException.getMessage());
                return;
            }
            catch (IOException iOException) {
                this.error("Unable to launch " + string + ", IO error in reading props.");
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.error("Unable to launch " + string + ": class " + string2 + " not found.");
                return;
            }
            catch (InstantiationException instantiationException) {
                this.error("Unable to launch " + string + ": unable to instanciate " + string2);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.error("Unable to launch " + string + ": illegal access to " + string2);
                return;
            }
            catch (ServerHandlerInitException serverHandlerInitException) {
                this.error("Unable to launch " + string + ": " + serverHandlerInitException.getMessage());
                return;
            }
        }
        String string3 = daemonProperties.getString(String.valueOf(string) + "." + CLONES_P, null);
        if (string3 == null) {
            this.error("Unable to launch " + string + ": no class or clones defined.");
            return;
        }
        serverHandler = this.lookupServerHandler(string3);
        if (serverHandler == null) {
            this.error("Unable to launch " + string + ": " + string3 + " doesn't exit.");
            return;
        }
        try {
            serverHandler = serverHandler.clone(this, string, daemonProperties.loadPropertySpace(string));
        }
        catch (Exception exception) {
            this.error("Unable to launch " + string + ": clone failed on " + serverHandler + "\r\n" + exception.getMessage());
            return;
        }
        this.handlers.put(string, serverHandler);
    }

    public ServerHandler lookupServerHandler(String string) {
        return (ServerHandler)this.handlers.get(string);
    }

    public static void main(String[] stringArray) {
        Object object;
        Integer n = null;
        Object v = null;
        String string = null;
        String string2 = "server.props";
        String string3 = null;
        Boolean bl = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-maxstores") && n2 + 1 < stringArray.length) {
                string7 = stringArray[++n2];
            } else if (stringArray[n2].equals("-root") && n2 + 1 < stringArray.length) {
                string = stringArray[++n2];
            } else if (stringArray[n2].equals("-p") && n2 + 1 < stringArray.length) {
                string2 = stringArray[++n2];
            } else if (stringArray[n2].equals("-trace")) {
                bl = Boolean.TRUE;
            } else if (stringArray[n2].equals("-chroot") && n2 + 1 < stringArray.length) {
                string3 = stringArray[++n2];
            } else if (stringArray[n2].equals("-group") && n2 + 1 < stringArray.length) {
                string6 = stringArray[++n2];
            } else if (stringArray[n2].equals("-user") && n2 + 1 < stringArray.length) {
                string5 = stringArray[++n2];
            } else if (stringArray[n2].equals("-config") && n2 + 1 < stringArray.length) {
                string4 = stringArray[++n2];
            } else if (stringArray[n2].equals("?") || stringArray[n2].equals("-help")) {
                ServerHandlerManager.usage();
            } else {
                System.out.println("unknown option: [" + stringArray[n2] + "]");
                System.exit(1);
            }
            ++n2;
        }
        if (string3 != null) {
            object = Unix.getUnix();
            if (!((Unix)object).isResolved()) {
                System.out.println("You cannot chroot Jigsaw if the libUnix  native extension is not available. Check the documentation, or remove  this argument from command line.");
                System.exit(1);
            }
            try {
                ((Unix)object).chroot(string3);
            }
            catch (Exception exception) {
                System.out.println("The chroot system call failed, details:");
                exception.printStackTrace();
                System.exit(1);
            }
        }
        object = System.getProperties();
        if (string == null) {
            string = ((Properties)object).getProperty("user.dir", null);
        }
        File file = new File(string, string4 == null ? "config" : string4);
        File file2 = new File(file, string2);
        System.out.println("loading properties from: " + file2.getAbsolutePath());
        try {
            ((Properties)object).load(new FileInputStream(file2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Unable to load properties: " + string2);
            System.out.println("\t" + fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.out.println("Unable to load properties: " + string2);
            System.out.println("\t" + iOException.getMessage());
            System.exit(1);
        }
        if (string4 != null) {
            ((Hashtable)object).put("org.w3c.jigsaw.config", new File(string, string4).getAbsolutePath());
        }
        if (n != null) {
            ((Hashtable)object).put("org.w3c.jigsaw.port", n.toString());
        }
        if (v != null) {
            ((Hashtable)object).put("org.w3c.jigsaw.host", v);
        }
        if (string != null) {
            ((Hashtable)object).put("org.w3c.jigsaw.root", string);
        }
        if (bl != null) {
            ((Hashtable)object).put("org.w3c.jigsaw.trace", "true");
            ((Hashtable)object).put("org.w3c.jigsaw.client.debug", "true");
        }
        if (string7 != null) {
            ((Hashtable)object).put("org.w3c.jigsaw.loadedstore", string7);
        }
        if (string6 != null) {
            ((Hashtable)object).put(SERVER_GROUP_P, string6);
        }
        if (string5 != null) {
            ((Hashtable)object).put(SERVER_USER_P, string5);
        }
        new ServerHandlerManager(stringArray, file, (Properties)object);
    }

    public void unixStuff() {
        String string;
        int n;
        String string2 = this.props.getString(SERVER_USER_P, null);
        String string3 = this.props.getString(SERVER_GROUP_P, null);
        Unix unix = null;
        if (!(string2 == null && string3 == null || (unix = Unix.getUnix()).isResolved())) {
            String string4 = "You used either the -user or -group command  line option usefull only when running Jigsaw under UNIX.To be able to set these, Jigsaw requires  that libUnix, distributed with Jigsaw, be accessible from your LD_LIBRARY_PATH.";
            this.fatal(string4);
        }
        if (string3 != null) {
            boolean bl = false;
            n = unix.getGID(string3);
            if (n >= 0) {
                try {
                    unix.setGID(n);
                }
                catch (UnixException unixException) {
                    bl = true;
                }
            }
            if (n < 0 || bl) {
                string = "UNIX initialization, unable to setgid(2) to " + string3 + ". Check the -group command line option." + (n < 0 ? "(the group doesn't exist)." : "(setgid call failed).");
                this.fatal(string);
            }
            System.out.println("+ running as group \"" + string3 + "\".");
        }
        if (string2 != null) {
            boolean bl = false;
            n = unix.getUID(string2);
            if (n >= 0) {
                try {
                    unix.setUID(n);
                }
                catch (UnixException unixException) {
                    bl = true;
                }
            }
            if (n < 0 || bl) {
                string = "UNIX initialization, unable to setuid(2) to " + string2 + ". Check the -user command line option." + (n < 0 ? "(the user doesn't exist)." : "(setuid call failed).");
                this.fatal(string);
            }
            System.out.println("+ running as user \"" + string2 + "\".");
        }
    }

    public static void usage() {
        PrintStream printStream = System.out;
        printStream.println("usage: httpd [OPTIONS]");
        printStream.println("-root <directory> : root directory of server.");
        printStream.println("-p     <propfile> : property file to read.");
        printStream.println("-trace            : turns debugging on.");
        printStream.println("-chroot <root>    : chroot Jigsaw at startup.");
        printStream.println("-config <dir>     : use given directory as config dir.");
        printStream.println("-user <user>      : identity of the server (UNIX only).");
        printStream.println("-group <group>    : group of the server (UNIX only).");
        printStream.println("-maxstores <int>  : Max number of stores in memory.");
        System.exit(1);
    }
}

